<x-master-layout>
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                    <div class="card card-block card-stretch">
                        <div class="card-body p-0">
                            <div class="d-flex justify-content-between align-items-center p-3">
                                <h5 class="fw-bold">{{ $pageTitle ?? __('messages.list') }}</h5>
                            </div>
                        </div>
                    </div>
            </div>
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        {{ html()->form('POST', route('term-condition-save'))->attribute('data-toggle', 'validator')->open() }}
                        {{ html()->hidden('id',$setting_data->id ?? null) }}
                        <div class="row">
                            <div class="form-group col-md-12">
                                {{ html()->label(__('messages.terms_condition'), 'terms_condition')->class('form-control-label') }}
                                {{ html()->textarea('value', $terms_condition)->class('form-control tinymce-terms_condition')->placeholder(__('messages.terms_condition')) }}
                            </div>
                            <div class="form-group col-md-4">
                                <div class="form-control d-flex align-items-center justify-content-between">
                                    <label for="status" class="mb-0">{{ __('messages.status') }}</label>
                                    <div class="custom-control custom-switch custom-switch-text custom-switch-color custom-control-inline">
                                        <input type="checkbox" class="custom-control-input" name="status" id="status" value="1" {{ ($status ?? '1') == '1' ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="status"></label>
                                    </div>
                                </div>
                            </div>
                            
                            
                        </div>   
                        @if(auth()->user()->hasRole(['admin', 'demo_admin']))
                        {{ html()->submit(__('messages.save'))->class('btn btn-md btn-primary float-end') }}
                        @endif
                        {{ html()->form()->close() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
    @section('bottom_script')
        <script>
            (function($) {
                $(document).ready(function(){
                    tinymceEditor('.tinymce-terms_condition',' ',function (ed) {
    
                    }, 450)
                
                });
    
            })(jQuery);
        </script>
    @endsection
    </x-master-layout>