<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Arr;
use App\Models\Booking;
use App\Models\BookingAddressMapping;

class BookingsTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        
        $data = [
            [
                'id' => 1,
                'customer_id' => 3,
                'service_id' => 11,
                'provider_id' => 17,
                'date' => '2023-09-04 19:00:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 1.0,
                'total_amount' => 29.99,
                'description' => 'Split AC Setup',
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'accept',
                'address' => 'Elgin, UK',
                'payment_id' => 63,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-04 13:28:21',
                'updated_at' => '2023-09-29 08:14:14',
                'booking_address_id' => NULL,
                'tax' => '[{"id":25,"provider_id":17,"title":"Service Tax","type":"percent","value":5},{"id":26,"provider_id":17,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 5.24,
                'final_sub_total' => 24.75,
                'final_discount_amount' => 0.25,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 2,
                'customer_id' => 41,
                'service_id' => 12,
                'provider_id' => 16,
                'date' => '2023-09-05 12:42:00',
                'start_at' => '2023-09-05 12:45:38',
                'end_at' => '2023-09-05 15:43:23',
                'quantity' => 1,
                'amount' => 30.0,
                'discount' => 2.0,
                'total_amount' => 101.1,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => '2nd Street, Victoria, Australia',
                'payment_id' => 3,
                'duration_diff' => '10665',
                'deleted_at' => NULL,
                'created_at' => '2023-09-05 07:13:09',
                'updated_at' => '2023-09-05 10:27:26',
                'booking_address_id' => NULL,
                'tax' => '[{"id":41,"provider_id":16,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 88.88,
                'final_total_tax' => 4.0,
                'final_sub_total' => 87.1,
                'final_discount_amount' => 1.78,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 4,
                'customer_id' => 42,
                'service_id' => 14,
                'provider_id' => 15,
                'date' => '2023-09-05 13:33:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 23.0,
                'discount' => 2.0,
                'total_amount' => 23.67,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'waiting',
                'address' => 'Ashland, USA',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-05 08:03:58',
                'updated_at' => '2023-09-05 08:03:58',
                'booking_address_id' => NULL,
                'tax' => '[{"id":49,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 23.0,
                'final_total_tax' => 1.13,
                'final_sub_total' => 22.54,
                'final_discount_amount' => 0.46,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 5,
                'customer_id' => 42,
                'service_id' => 14,
                'provider_id' => 15,
                'date' => '2023-09-05 14:00:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 23.0,
                'discount' => 2.0,
                'total_amount' => 23.67,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'waiting',
                'address' => 'Greenbelt, Maryland.',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-05 08:30:18',
                'updated_at' => '2023-09-05 08:30:18',
                'booking_address_id' => NULL,
                'tax' => '[{"id":49,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 23.0,
                'final_total_tax' => 1.13,
                'final_sub_total' => 22.54,
                'final_discount_amount' => 0.46,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 6,
                'customer_id' => 42,
                'service_id' => 14,
                'provider_id' => 15,
                'date' => '2023-09-05 15:18:00',
                'start_at' => '2023-09-05 15:39:28',
                'end_at' => '2023-09-05 15:39:34',
                'quantity' => 1,
                'amount' => 23.0,
                'discount' => 2.0,
                'total_amount' => 34.17,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'US',
                'payment_id' => 2,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-05 09:48:23',
                'updated_at' => '2023-09-05 10:10:32',
                'booking_address_id' => NULL,
                'tax' => '[{"id":49,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 2.367,
                'final_total_service_price' => 23.0,
                'final_total_tax' => 1.63,
                'final_sub_total' => 22.54,
                'final_discount_amount' => 0.46,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 7,
                'customer_id' => 41,
                'service_id' => 14,
                'provider_id' => 15,
                'date' => '2023-09-05 16:06:00',
                'start_at' => '2023-09-05 16:06:00',
                'end_at' => '2023-09-05 16:08:34',
                'quantity' => 1,
                'amount' => 23.0,
                'discount' => 2.0,
                'total_amount' => 23.67,
                'description' => NULL,
                'reason' => 'Sorry, by mistaken i booked wrong service. I need other service.',
                'coupon_id' => NULL,
                'status' => 'cancelled',
                'address' => '23 street, New Bedford',
                'payment_id' => 4,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-05 10:36:57',
                'updated_at' => '2023-09-05 10:38:33',
                'booking_address_id' => NULL,
                'tax' => '[{"id":49,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 2.367,
                'final_total_service_price' => 23.0,
                'final_total_tax' => 1.13,
                'final_sub_total' => 22.54,
                'final_discount_amount' => 0.46,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 8,
                'customer_id' => 43,
                'service_id' => 11,
                'provider_id' => 17,
                'date' => '2023-09-05 16:12:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 1.0,
                'total_amount' => 29.99,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'rejected',
                'address' => 'Browns Home, Yorkton',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-05 10:43:50',
                'updated_at' => '2023-09-05 10:45:46',
                'booking_address_id' => NULL,
                'tax' => '[{"id":25,"provider_id":17,"title":"Service Tax","type":"percent","value":5},{"id":26,"provider_id":17,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 5.24,
                'final_sub_total' => 24.75,
                'final_discount_amount' => 0.25,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 9,
                'customer_id' => 43,
                'service_id' => 13,
                'provider_id' => 16,
                'date' => '2023-09-05 16:16:00',
                'start_at' => '2023-09-05 16:18:25',
                'end_at' => '2023-09-05 16:18:31',
                'quantity' => 1,
                'amount' => 12.0,
                'discount' => 1.0,
                'total_amount' => 15.88,
                'description' => NULL,
                'reason' => 'Done',
                'coupon_id' => NULL,
                'status' => 'pending_approval',
                'address' => 'Home Innovative Centre, Frnakston',
                'payment_id' => NULL,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-05 10:47:16',
                'updated_at' => '2023-09-05 10:48:30',
                'booking_address_id' => NULL,
                'tax' => '[{"id":41,"provider_id":16,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 12.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 11.88,
                'final_discount_amount' => 0.12,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 10,
                'customer_id' => 43,
                'service_id' => 15,
                'provider_id' => 4,
                'date' => '2023-09-05 16:19:00',
                'start_at' => '2023-09-05 16:21:35',
                'end_at' => '2023-09-05 16:21:40',
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 2.0,
                'total_amount' => 29.73,
                'description' => NULL,
                'reason' => 'Done ✅',
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'John Home, Australia',
                'payment_id' => 5,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-05 10:49:49',
                'updated_at' => '2023-09-05 10:53:02',
                'booking_address_id' => NULL,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 5.23,
                'final_sub_total' => 24.5,
                'final_discount_amount' => 0.5,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 11,
                'customer_id' => 44,
                'service_id' => 11,
                'provider_id' => 17,
                'date' => '2023-09-05 16:33:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 1.0,
                'total_amount' => 29.99,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'pending',
                'address' => 'Home Hardware',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-05 11:04:44',
                'updated_at' => '2023-09-05 11:04:44',
                'booking_address_id' => NULL,
                'tax' => '[{"id":25,"provider_id":17,"title":"Service Tax","type":"percent","value":5},{"id":26,"provider_id":17,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 5.24,
                'final_sub_total' => 24.75,
                'final_discount_amount' => 0.25,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 12,
                'customer_id' => 44,
                'service_id' => 12,
                'provider_id' => 16,
                'date' => '2023-09-05 16:35:00',
                'start_at' => '2023-09-05 16:35:00',
                'end_at' => '2023-09-05 16:37:05',
                'quantity' => 1,
                'amount' => 30.0,
                'discount' => 2.0,
                'total_amount' => 33.4,
                'description' => NULL,
                'reason' => 'Sorry, my AC is working fine now. So need for this service.',
                'coupon_id' => NULL,
                'status' => 'cancelled',
                'address' => 'Frankston Houses',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-05 11:05:39',
                'updated_at' => '2023-09-05 11:07:04',
                'booking_address_id' => NULL,
                'tax' => '[{"id":41,"provider_id":16,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 0.0,
                'final_total_service_price' => 30.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 29.4,
                'final_discount_amount' => 0.6,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 13,
                'customer_id' => 3,
                'service_id' => 19,
                'provider_id' => 12,
                'date' => '2023-09-06 00:00:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 4.0,
                'total_amount' => 30.21,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'accept',
                'address' => 'Sandy Beach ⛱️',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-06 08:24:57',
                'updated_at' => '2023-09-06 09:34:19',
                'booking_address_id' => NULL,
                'tax' => '[{"id":35,"provider_id":12,"title":"Service Tax","type":"percent","value":5},{"id":36,"provider_id":12,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => '14:00:00',
                'booking_day' => 'wed',
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 5.25,
                'final_sub_total' => 24.96,
                'final_discount_amount' => 1.04,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 14,
                'customer_id' => 3,
                'service_id' => 18,
                'provider_id' => 4,
                'date' => '2023-09-06 13:55:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 33.0,
                'discount' => 5.0,
                'total_amount' => 36.92,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'accept',
                'address' => 'Street Vila',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-06 08:25:44',
                'updated_at' => '2023-10-05 06:45:42',
                'booking_address_id' => NULL,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 33.0,
                'final_total_tax' => 5.57,
                'final_sub_total' => 31.35,
                'final_discount_amount' => 1.65,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 15,
                'customer_id' => 3,
                'service_id' => 17,
                'provider_id' => 4,
                'date' => '2023-09-06 15:06:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 22.0,
                'discount' => NULL,
                'total_amount' => 27.1,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'pending',
                'address' => 'Vellu Housing',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-06 09:36:12',
                'updated_at' => '2023-09-06 09:36:12',
                'booking_address_id' => NULL,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 22.0,
                'final_total_tax' => 5.1,
                'final_sub_total' => 22.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 16,
                'customer_id' => 3,
                'service_id' => 40,
                'provider_id' => 15,
                'date' => '2023-09-09 11:40:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 12.0,
                'discount' => 0.0,
                'total_amount' => 12.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'on_going',
                'address' => 'Great Home',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 06:10:48',
                'updated_at' => '2023-09-09 06:12:06',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 16,
                    'created_at' => '2023-09-08 22:10:49',
                    'id' => 1,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-09-08 22:10:49',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":49,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 12.0,
                'final_total_tax' => 0.6,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 18,
                'customer_id' => 44,
                'service_id' => 47,
                'provider_id' => 17,
                'date' => '2023-09-09 12:36:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 19.0,
                'discount' => 0.0,
                'total_amount' => 23.95,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'pending',
                'address' => 'Housing No. 3, Vella',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 07:07:14',
                'updated_at' => '2023-09-09 07:07:14',
                'booking_address' =>[
                    'address' => 'Edinburgh, Scotland, UK',
                    'booking_id' => 18,
                    'created_at' => '2023-09-08 23:07:14',
                    'id' => 3,
                    'latitude' => '55.953251',
                    'longitude' => '-3.188267',
                    'updated_at' => '2023-09-08 23:07:14',
                ],
                'booking_address_id' => 29,
                'tax' => '[{"id":25,"provider_id":17,"title":"Service Tax","type":"percent","value":5},{"id":26,"provider_id":17,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 19.0,
                'final_total_tax' => 4.95,
                'final_sub_total' => 19.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 19,
                'customer_id' => 44,
                'service_id' => 45,
                'provider_id' => 4,
                'date' => '2023-09-11 12:37:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 0.0,
                'total_amount' => 30.25,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'on_going',
                'address' => '4, Rest home',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 07:07:45',
                'updated_at' => '2023-09-09 07:08:48',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 19,
                    'created_at' => '2023-09-08 23:07:46',
                    'id' => 4,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-08 23:07:46',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 5.25,
                'final_sub_total' => 25.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 20,
                'customer_id' => 44,
                'service_id' => 50,
                'provider_id' => 12,
                'date' => '2023-09-09 12:49:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 0.0,
                'total_amount' => 30.25,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'accept',
                'address' => 'Destiny world',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 07:19:57',
                'updated_at' => '2023-09-09 07:20:32',
                'booking_address' =>[
                    'address' => 'Sandy Beach, Canada',
                    'booking_id' => 20,
                    'created_at' => '2023-09-08 23:19:58',
                    'id' => 5,
                    'latitude' => '-30.1483',
                    'longitude' => '153.2011',
                    'updated_at' => '2023-09-08 23:19:58',
                ],
                'booking_address_id' => 20,
                'tax' => '[{"id":35,"provider_id":12,"title":"Service Tax","type":"percent","value":5},{"id":36,"provider_id":12,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 5.25,
                'final_sub_total' => 25.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 21,
                'customer_id' => 39,
                'service_id' => 49,
                'provider_id' => 4,
                'date' => '2023-09-09 12:51:00',
                'start_at' => '2023-09-09 12:52:52',
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 41.0,
                'discount' => 1.0,
                'total_amount' => 46.62,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'in_progress',
                'address' => 'Cancan',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 07:21:45',
                'updated_at' => '2023-09-09 07:22:53',
                'booking_address' =>[
                    'address' => 'Mont-Saint-Hilaire, QC, Canada',
                    'booking_id' => 21,
                    'created_at' => '2023-09-08 23:21:46',
                    'id' => 6,
                    'latitude' => '45.562222',
                    'longitude' => '-73.191666',
                    'updated_at' => '2023-09-08 23:21:46',
                ],
                'booking_address_id' => 4,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 41.0,
                'final_total_tax' => 6.03,
                'final_sub_total' => 40.59,
                'final_discount_amount' => 0.41,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 22,
                'customer_id' => 3,
                'service_id' => 49,
                'provider_id' => 4,
                'date' => '2023-09-09 12:53:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 41.0,
                'discount' => 1.0,
                'total_amount' => 46.62,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'accept',
                'address' => 'Brisban',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 07:24:17',
                'updated_at' => '2023-09-09 07:24:40',
                'booking_address_id' => Null,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 41.0,
                'final_total_tax' => 6.03,
                'final_sub_total' => 40.59,
                'final_discount_amount' => 0.41,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 24,
                'customer_id' => 3,
                'service_id' => 59,
                'provider_id' => 4,
                'date' => '2023-09-13 14:38:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 42.0,
                'discount' => 0.0,
                'total_amount' => 48.1,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'accept',
                'address' => 'Drive home ?',
                'payment_id' => 6,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 08:08:38',
                'updated_at' => '2023-09-09 08:09:51',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 24,
                    'created_at' => '2023-09-09 00:08:39',
                    'id' => 9,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-09 00:08:39',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 4.81,
                'final_total_service_price' => 42.0,
                'final_total_tax' => 6.1,
                'final_sub_total' => 42.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 25,
                'customer_id' => 3,
                'service_id' => 45,
                'provider_id' => 4,
                'date' => '2023-09-11 13:39:00',
                'start_at' => '2023-09-09 13:41:29',
                'end_at' => '2023-09-09 13:42:18',
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 0.0,
                'total_amount' => 30.25,
                'description' => NULL,
                'reason' => 'Hold this service due to power cut issue. Sorry for inconvenience ?',
                'coupon_id' => NULL,
                'status' => 'hold',
                'address' => 'Ford',
                'payment_id' => NULL,
                'duration_diff' => '49',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 08:09:37',
                'updated_at' => '2023-09-09 08:12:19',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 25,
                    'created_at' => '2023-09-09 00:09:38',
                    'id' => 10,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-09 00:09:38',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 5.25,
                'final_sub_total' => 25.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 26,
                'customer_id' => 3,
                'service_id' => 55,
                'provider_id' => 4,
                'date' => '2023-09-15 13:42:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 41.0,
                'discount' => 0.0,
                'total_amount' => 47.05,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'pending',
                'address' => 'Great Home',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 08:13:04',
                'updated_at' => '2023-09-09 08:13:04',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 26,
                    'created_at' => '2023-09-09 00:13:05',
                    'id' => 11,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-09 00:13:05',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 41.0,
                'final_total_tax' => 6.05,
                'final_sub_total' => 41.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 27,
                'customer_id' => 3,
                'service_id' => 63,
                'provider_id' => 4,
                'date' => '2023-09-10 00:00:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 20.0,
                'discount' => 0.0,
                'total_amount' => 25.0,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'rejected',
                'address' => '34, Street, Near villa',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 09:32:35',
                'updated_at' => '2023-09-09 09:32:54',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 27,
                    'created_at' => '2023-09-09 01:32:36',
                    'id' => 12,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-09 01:32:36',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => '14:00:00',
                'booking_day' => 'sun',
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 20.0,
                'final_total_tax' => 5.0,
                'final_sub_total' => 20.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 28,
                'customer_id' => 3,
                'service_id' => 62,
                'provider_id' => 4,
                'date' => '2023-09-09 15:03:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 18.0,
                'discount' => 0.0,
                'total_amount' => 22.9,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'pending',
                'address' => 'Villa, Sea view',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 09:33:33',
                'updated_at' => '2023-09-09 09:33:33',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 28,
                    'created_at' => '2023-09-09 01:33:34',
                    'id' => 13,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-09-09 01:33:34',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 18.0,
                'final_total_tax' => 4.9,
                'final_sub_total' => 18.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 29,
                'customer_id' => 3,
                'service_id' => 73,
                'provider_id' => 16,
                'date' => '2023-09-09 16:38:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 16.0,
                'discount' => 0.0,
                'total_amount' => 20.0,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'pending',
                'address' => 'Veli Home',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 11:08:26',
                'updated_at' => '2023-09-09 11:08:26',
                'booking_address' =>[
                    'address' => 'Newcastle, Australia',
                    'booking_id' => 29,
                    'created_at' => '2023-09-09 03:08:27',
                    'id' => 14,
                    'latitude' => '-32.9167',
                    'longitude' => '151.7500',
                    'updated_at' => '2023-09-09 03:08:27',
                ],
                'booking_address_id' => 27,
                'tax' => '[{"id":41,"provider_id":16,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 16.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 16.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 30,
                'customer_id' => 3,
                'service_id' => 100,
                'provider_id' => 4,
                'date' => '2023-09-09 16:39:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 37.0,
                'discount' => 0.0,
                'total_amount' => 42.85,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'on_going',
                'address' => 'Comics House',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 11:09:49',
                'updated_at' => '2023-09-09 11:10:55',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 30,
                    'created_at' => '2023-09-09 03:09:50',
                    'id' => 15,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-09-09 03:09:50',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 37.0,
                'final_total_tax' => 5.85,
                'final_sub_total' => 37.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 31,
                'customer_id' => 3,
                'service_id' => 110,
                'provider_id' => 4,
                'date' => '2023-09-09 18:45:00',
                'start_at' => '2023-09-09 18:46:47',
                'end_at' => '2023-09-09 18:46:52',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 27.1,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Dream vila',
                'payment_id' => 7,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 13:15:48',
                'updated_at' => '2023-09-09 13:17:43',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 31,
                    'created_at' => '2023-09-09 05:15:49',
                    'id' => 16,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-09 05:15:49',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 5.1,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 32,
                'customer_id' => 3,
                'service_id' => 109,
                'provider_id' => 4,
                'date' => '2023-09-10 00:00:00',
                'start_at' => '2023-09-09 18:50:02',
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 43.0,
                'discount' => 0.0,
                'total_amount' => 46.0,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'in_progress',
                'address' => 'Felix Vila',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 13:18:41',
                'updated_at' => '2023-09-09 13:20:03',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 32,
                    'created_at' => '2023-09-09 05:18:42',
                    'id' => 17,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-09 05:18:42',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => '11:00:00',
                'booking_day' => 'sun',
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 43.0,
                'final_total_tax' => 6.0,
                'final_sub_total' => 40.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 33,
                'customer_id' => 3,
                'service_id' => 108,
                'provider_id' => 15,
                'date' => '2023-09-14 18:51:00',
                'start_at' => '2023-09-09 18:53:20',
                'end_at' => '2023-09-09 18:54:29',
                'quantity' => 1,
                'amount' => 18.0,
                'discount' => 2.0,
                'total_amount' => 15.37,
                'description' => NULL,
                'reason' => 'Some instruments are missing so i want to hold this service.',
                'coupon_id' => 7,
                'status' => 'hold',
                'address' => 'Rashi Mall',
                'payment_id' => NULL,
                'duration_diff' => '69',
                'deleted_at' => NULL,
                'created_at' => '2023-09-09 13:21:46',
                'updated_at' => '2023-09-09 13:24:33',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 33,
                    'created_at' => '2023-09-09 05:21:47',
                    'id' => 18,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-09-09 05:21:47',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":49,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 18.0,
                'final_total_tax' => 0.73,
                'final_sub_total' => 14.64,
                'final_discount_amount' => 0.36,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 34,
                'customer_id' => 47,
                'service_id' => 110,
                'provider_id' => 4,
                'date' => '2023-09-11 16:09:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 16.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'on_going',
                'address' => 'Greenville',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-11 10:39:21',
                'updated_at' => '2023-10-05 06:47:39',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 34,
                    'created_at' => '2023-09-11 02:39:21',
                    'id' => 19,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-11 02:39:21',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.6,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 35,
                'customer_id' => 3,
                'service_id' => 11,
                'provider_id' => 17,
                'date' => '2023-09-12 11:23:00',
                'start_at' => '2023-09-12 12:06:19',
                'end_at' => '2023-09-12 12:06:37',
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 1.0,
                'total_amount' => 24.74,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 1,
                'status' => 'completed',
                'address' => 'Setyu Divine',
                'payment_id' => 8,
                'duration_diff' => '18',
                'deleted_at' => NULL,
                'created_at' => '2023-09-12 05:54:54',
                'updated_at' => '2023-09-12 06:38:05',
                'booking_address' =>[
                    'address' => 'Edinburgh, Scotland, UK',
                    'booking_id' => 35,
                    'created_at' => '2023-09-11 21:54:55',
                    'id' => 20,
                    'latitude' => '55.953251',
                    'longitude' => '-3.188267',
                    'updated_at' => '2023-09-11 21:54:55',
                ],
                'booking_address_id' => 29,
                'tax' => '[{"id":25,"provider_id":17,"title":"Service Tax","type":"percent","value":5},{"id":26,"provider_id":17,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 4.99,
                'final_sub_total' => 19.75,
                'final_discount_amount' => 0.25,
                'final_coupon_discount_amount' => 5.0,
            ],
            [
                'id' => 36,
                'customer_id' => 3,
                'service_id' => 12,
                'provider_id' => 16,
                'date' => '2023-09-12 12:47:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 30.0,
                'discount' => 2.0,
                'total_amount' => 28.4,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 1,
                'status' => 'on_going',
                'address' => 'Australia',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-12 07:17:19',
                'updated_at' => '2023-09-12 07:18:50',
                'booking_address' =>[
                    'address' => 'Frankston, Victoria, Australia',
                    'booking_id' => 36,
                    'created_at' => '2023-09-11 23:17:20',
                    'id' => 21,
                    'latitude' => '-38.1580',
                    'longitude' => '145.1350',
                    'updated_at' => '2023-09-11 23:17:20',
                ],
                'booking_address_id' => 28,
                'tax' => '[{"id":41,"provider_id":16,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 30.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 24.4,
                'final_discount_amount' => 0.6,
                'final_coupon_discount_amount' => 5.0,
            ],
            [
                'id' => 37,
                'customer_id' => 3,
                'service_id' => 106,
                'provider_id' => 15,
                'date' => '2023-09-12 12:50:00',
                'start_at' => '2023-09-12 12:54:13',
                'end_at' => '2023-09-12 12:55:03',
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 2.0,
                'total_amount' => 26.75,
                'description' => NULL,
                'reason' => 'Done',
                'coupon_id' => NULL,
                'status' => 'pending_approval',
                'address' => '1 straight street',
                'payment_id' => NULL,
                'duration_diff' => '50',
                'deleted_at' => NULL,
                'created_at' => '2023-09-12 07:20:42',
                'updated_at' => '2023-09-12 07:25:04',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 37,
                    'created_at' => '2023-09-11 23:20:43',
                    'id' => 22,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-09-11 23:20:43',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":49,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 1.27,
                'final_sub_total' => 25.48,
                'final_discount_amount' => 0.52,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 38,
                'customer_id' => 3,
                'service_id' => 105,
                'provider_id' => 4,
                'date' => '2023-09-12 12:55:00',
                'start_at' => '2023-09-12 12:55:00',
                'end_at' => '2023-09-12 12:58:32',
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => 4.0,
                'total_amount' => 39.28,
                'description' => NULL,
                'reason' => 'I placed order at cake shop',
                'coupon_id' => NULL,
                'status' => 'cancelled',
                'address' => 'Canada',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-12 07:26:06',
                'updated_at' => '2023-09-12 07:28:33',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 38,
                    'created_at' => '2023-09-11 23:26:07',
                    'id' => 23,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-11 23:26:07',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 0.0,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 5.68,
                'final_sub_total' => 33.6,
                'final_discount_amount' => 1.4,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 39,
                'customer_id' => 3,
                'service_id' => 107,
                'provider_id' => 4,
                'date' => '2023-09-12 12:59:00',
                'start_at' => '2023-09-12 13:04:18',
                'end_at' => '2023-09-12 13:04:27',
                'quantity' => 1,
                'amount' => 32.0,
                'discount' => 0.0,
                'total_amount' => 37.6,
                'description' => NULL,
                'reason' => 'Done',
                'coupon_id' => NULL,
                'status' => 'pending_approval',
                'address' => 'Sk Canada',
                'payment_id' => 9,
                'duration_diff' => '9',
                'deleted_at' => NULL,
                'created_at' => '2023-09-12 07:29:44',
                'updated_at' => '2023-09-12 07:34:27',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 39,
                    'created_at' => '2023-09-11 23:29:45',
                    'id' => 24,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-11 23:29:45',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 0.752,
                'final_total_service_price' => 32.0,
                'final_total_tax' => 5.6,
                'final_sub_total' => 32.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 40,
                'customer_id' => 3,
                'service_id' => 110,
                'provider_id' => 4,
                'date' => '2023-09-12 13:05:00',
                'start_at' => '2023-09-12 13:06:51',
                'end_at' => '2023-09-12 13:06:59',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 19.75,
                'description' => NULL,
                'reason' => 'Done ✅',
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Canada',
                'payment_id' => 10,
                'duration_diff' => '8',
                'deleted_at' => NULL,
                'created_at' => '2023-09-12 07:35:27',
                'updated_at' => '2023-09-12 07:38:12',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 40,
                    'created_at' => '2023-09-11 23:35:28',
                    'id' => 25,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-11 23:35:28',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.75,
                'final_sub_total' => 15.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 41,
                'customer_id' => 3,
                'service_id' => 86,
                'provider_id' => 4,
                'date' => '2023-09-12 13:29:00',
                'start_at' => '2023-09-12 13:33:08',
                'end_at' => '2023-09-12 13:33:16',
                'quantity' => 1,
                'amount' => 28.0,
                'discount' => 5.0,
                'total_amount' => 31.34,
                'description' => NULL,
                'reason' => 'Done ?',
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Canada',
                'payment_id' => 11,
                'duration_diff' => '8',
                'deleted_at' => NULL,
                'created_at' => '2023-09-12 07:59:24',
                'updated_at' => '2023-09-12 08:04:57',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 41,
                    'created_at' => '2023-09-11 23:59:25',
                    'id' => 26,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-09-11 23:59:25',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 28.0,
                'final_total_tax' => 5.3,
                'final_sub_total' => 26.04,
                'final_discount_amount' => 1.4,
                'final_coupon_discount_amount' => 0.56,
            ],
            [
                'id' => 42,
                'customer_id' => 3,
                'service_id' => 100,
                'provider_id' => 4,
                'date' => '2023-09-12 14:38:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 37.0,
                'discount' => 0.0,
                'total_amount' => 42.85,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'pending',
                'address' => 'Canada',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-12 09:08:45',
                'updated_at' => '2023-09-12 09:08:45',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 42,
                    'created_at' => '2023-09-12 01:08:46',
                    'id' => 27,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-09-12 01:08:46',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 37.0,
                'final_total_tax' => 5.85,
                'final_sub_total' => 37.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 43,
                'customer_id' => 3,
                'service_id' => 107,
                'provider_id' => 4,
                'date' => '2023-09-13 14:57:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 32.0,
                'discount' => 0.0,
                'total_amount' => 37.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'pending',
                'address' => 'America',
                'payment_id' => 12,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-12 09:28:02',
                'updated_at' => '2023-09-12 09:30:13',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 43,
                    'created_at' => '2023-09-12 01:28:03',
                    'id' => 28,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-12 01:28:03',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 0.752,
                'final_total_service_price' => 32.0,
                'final_total_tax' => 5.6,
                'final_sub_total' => 32.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 44,
                'customer_id' => 3,
                'service_id' => 107,
                'provider_id' => 4,
                'date' => '2023-09-12 15:04:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 32.0,
                'discount' => 0.0,
                'total_amount' => 37.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'waiting',
                'address' => 'Canada',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-12 09:34:31',
                'updated_at' => '2023-09-12 09:34:31',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 44,
                    'created_at' => '2023-09-12 01:34:33',
                    'id' => 29,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-12 01:34:33',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 32.0,
                'final_total_tax' => 5.6,
                'final_sub_total' => 32.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 45,
                'customer_id' => 3,
                'service_id' => 14,
                'provider_id' => 15,
                'date' => '2023-09-21 15:20:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 23.0,
                'discount' => 2.0,
                'total_amount' => 23.67,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'waiting',
                'address' => 'America',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-12 09:50:16',
                'updated_at' => '2023-09-12 09:50:16',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 45,
                    'created_at' => '2023-09-12 01:50:17',
                    'id' => 30,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-09-12 01:50:17',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":49,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 23.0,
                'final_total_tax' => 1.13,
                'final_sub_total' => 22.54,
                'final_discount_amount' => 0.46,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 46,
                'customer_id' => 3,
                'service_id' => 38,
                'provider_id' => 4,
                'date' => '2023-09-12 15:21:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => 0.0,
                'total_amount' => 40.75,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'pending',
                'address' => 'SK, Canada',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-12 09:51:16',
                'updated_at' => '2023-09-12 09:51:16',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 46,
                    'created_at' => '2023-09-12 01:51:17',
                    'id' => 31,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-12 01:51:17',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 5.75,
                'final_sub_total' => 35.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 47,
                'customer_id' => 3,
                'service_id' => 82,
                'provider_id' => 4,
                'date' => '2023-09-12 15:47:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 36.0,
                'discount' => 5.0,
                'total_amount' => 39.91,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'rejected',
                'address' => 'USA',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-12 10:18:00',
                'updated_at' => '2023-09-12 10:18:22',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 47,
                    'created_at' => '2023-09-12 02:18:01',
                    'id' => 32,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-09-12 02:18:01',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 36.0,
                'final_total_tax' => 5.71,
                'final_sub_total' => 34.2,
                'final_discount_amount' => 1.8,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 48,
                'customer_id' => 3,
                'service_id' => 95,
                'provider_id' => 4,
                'date' => '2023-09-13 11:38:00',
                'start_at' => '2023-09-13 11:40:59',
                'end_at' => '2023-09-13 11:41:05',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 29.94,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Australia',
                'payment_id' => NULL,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-13 06:08:45',
                'updated_at' => '2023-09-13 06:11:32',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 48,
                    'created_at' => '2023-09-12 22:08:46',
                    'id' => 33,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-09-12 22:08:46',
                ],
                'booking_address_id' => 5,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 5.24,
                'final_sub_total' => 14.7,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.3,
            ],
            [
                'id' => 49,
                'customer_id' => 3,
                'service_id' => 106,
                'provider_id' => 15,
                'date' => '2023-09-19 11:27:00',
                'start_at' => '2023-09-19 12:16:00',
                'end_at' => '2023-09-19 12:16:07',
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 2.0,
                'total_amount' => 23.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Canada',
                'payment_id' => 13,
                'duration_diff' => '7',
                'deleted_at' => NULL,
                'created_at' => '2023-09-19 05:57:33',
                'updated_at' => '2023-09-19 06:47:04',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 49,
                    'created_at' => '2023-09-18 21:57:34',
                    'id' => 34,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-09-18 21:57:34',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":49,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 1.12,
                'final_sub_total' => 22.48,
                'final_discount_amount' => 0.52,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 50,
                'customer_id' => 3,
                'service_id' => 109,
                'provider_id' => 4,
                'date' => '2023-09-19 00:00:00',
                'start_at' => '2023-09-19 12:27:38',
                'end_at' => '2023-09-19 12:27:45',
                'quantity' => 1,
                'amount' => 43.0,
                'discount' => 0.0,
                'total_amount' => 46.0,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Atlanta',
                'payment_id' => 14,
                'duration_diff' => '7',
                'deleted_at' => NULL,
                'created_at' => '2023-09-19 06:55:37',
                'updated_at' => '2023-09-19 06:58:14',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 50,
                    'created_at' => '2023-09-18 22:55:38',
                    'id' => 35,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-18 22:55:38',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => '14:00:00',
                'booking_day' => 'tue',
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 43.0,
                'final_total_tax' => 6.0,
                'final_sub_total' => 40.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 52,
                'customer_id' => 3,
                'service_id' => 105,
                'provider_id' => 4,
                'date' => '2023-09-20 12:14:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => 4.0,
                'total_amount' => 36.13,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'pending',
                'address' => 'SK Canada',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-20 06:45:20',
                'updated_at' => '2023-09-20 06:45:20',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 52,
                    'created_at' => '2023-09-19 22:45:21',
                    'id' => 37,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-19 22:45:21',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 5.53,
                'final_sub_total' => 30.6,
                'final_discount_amount' => 1.4,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 53,
                'customer_id' => 3,
                'service_id' => 36,
                'provider_id' => 4,
                'date' => '2023-09-21 08:16:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 53.0,
                'discount' => 5.0,
                'total_amount' => 52.67,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'accept',
                'address' => 'UK',
                'payment_id' => 16,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-20 06:46:40',
                'updated_at' => '2023-09-20 06:48:22',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 53,
                    'created_at' => '2023-09-19 22:46:41',
                    'id' => 38,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-19 22:46:41',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 2.1068,
                'final_total_service_price' => 53.0,
                'final_total_tax' => 6.32,
                'final_sub_total' => 46.35,
                'final_discount_amount' => 2.65,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 54,
                'customer_id' => 3,
                'service_id' => 31,
                'provider_id' => 4,
                'date' => '2023-09-22 09:19:00',
                'start_at' => '2023-09-20 12:22:32',
                'end_at' => '2023-09-20 12:22:37',
                'quantity' => 1,
                'amount' => 12.0,
                'discount' => 1.0,
                'total_amount' => 12.27,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'completed',
                'address' => 'Brisbane Australia',
                'payment_id' => 17,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-20 06:49:32',
                'updated_at' => '2023-09-20 06:53:05',
                'booking_address' =>[
                    'address' => 'Brisbane, Australia',
                    'booking_id' => 54,
                    'created_at' => '2023-09-19 22:49:33',
                    'id' => 39,
                    'latitude' => '-27.4678',
                    'longitude' => '153.0281',
                    'updated_at' => '2023-09-19 22:49:33',
                ],
                'booking_address_id' => 6,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 12.0,
                'final_total_tax' => 4.39,
                'final_sub_total' => 7.88,
                'final_discount_amount' => 0.12,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 55,
                'customer_id' => 3,
                'service_id' => 96,
                'provider_id' => 4,
                'date' => '2023-09-20 12:26:00',
                'start_at' => '2023-09-20 12:31:09',
                'end_at' => '2023-09-20 12:31:15',
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 0.0,
                'total_amount' => 30.75,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'UK',
                'payment_id' => 18,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-20 06:57:10',
                'updated_at' => '2023-09-20 07:02:41',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 55,
                    'created_at' => '2023-09-19 22:57:11',
                    'id' => 40,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-19 22:57:11',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 5.27,
                'final_sub_total' => 25.48,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.52,
            ],
            [
                'id' => 56,
                'customer_id' => 3,
                'service_id' => 81,
                'provider_id' => 4,
                'date' => '2023-09-20 12:43:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 38.0,
                'discount' => 4.0,
                'total_amount' => 42.3,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'accept',
                'address' => 'Canada',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-20 07:13:14',
                'updated_at' => '2023-09-20 07:13:28',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 56,
                    'created_at' => '2023-09-19 23:13:15',
                    'id' => 41,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-09-19 23:13:15',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 38.0,
                'final_total_tax' => 5.82,
                'final_sub_total' => 36.48,
                'final_discount_amount' => 1.52,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 57,
                'customer_id' => 3,
                'service_id' => 72,
                'provider_id' => 4,
                'date' => '2023-09-20 12:44:00',
                'start_at' => '2023-09-20 12:45:50',
                'end_at' => '2023-09-20 12:46:05',
                'quantity' => 1,
                'amount' => 50.0,
                'discount' => 10.0,
                'total_amount' => 51.25,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Canada',
                'payment_id' => 19,
                'duration_diff' => '15',
                'deleted_at' => NULL,
                'created_at' => '2023-09-20 07:14:14',
                'updated_at' => '2023-09-20 07:16:55',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 57,
                    'created_at' => '2023-09-19 23:14:15',
                    'id' => 42,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-09-19 23:14:15',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 50.0,
                'final_total_tax' => 6.25,
                'final_sub_total' => 45.0,
                'final_discount_amount' => 5.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 58,
                'customer_id' => 3,
                'service_id' => 78,
                'provider_id' => 4,
                'date' => '2023-09-20 15:45:00',
                'start_at' => '2023-09-20 15:48:41',
                'end_at' => '2023-09-20 15:48:47',
                'quantity' => 1,
                'amount' => 37.0,
                'discount' => 2.0,
                'total_amount' => 52.57,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Brisban',
                'payment_id' => 20,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-20 10:15:58',
                'updated_at' => '2023-09-20 10:22:32',
                'booking_address' =>[
                    'address' => 'Brisbane, Australia',
                    'booking_id' => 58,
                    'created_at' => '2023-09-20 15:45:59',
                    'id' => 43,
                    'latitude' => '-27.4678',
                    'longitude' => '153.0281',
                    'updated_at' => '2023-09-20 15:45:59',
                ],
                'booking_address_id' => 6,
                'tax' => '[{"id":52,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":53,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 37.0,
                'final_total_tax' => 6.31,
                'final_sub_total' => 36.26,
                'final_discount_amount' => 0.74,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 59,
                'customer_id' => 3,
                'service_id' => 94,
                'provider_id' => 4,
                'date' => '2023-09-27 14:28:00',
                'start_at' => '2023-09-27 14:28:00',
                'end_at' => '2023-09-27 11:32:56',
                'quantity' => 1,
                'amount' => 34.0,
                'discount' => 0.0,
                'total_amount' => 38.99,
                'description' => NULL,
                'reason' => 'I\'m sorry, but I had an unexpected emergency come up, so I won\'t be able to make it to my hair cutting appointment.',
                'coupon_id' => 6,
                'status' => 'cancelled',
                'address' => 'Gulbarga, USA',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 05:59:04',
                'updated_at' => '2023-09-27 06:02:59',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 59,
                    'created_at' => '2023-09-27 11:29:05',
                    'id' => 44,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-09-27 11:29:05',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 0.0,
                'final_total_service_price' => 34.0,
                'final_total_tax' => 5.67,
                'final_sub_total' => 33.32,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.68,
            ],
            [
                'id' => 60,
                'customer_id' => 3,
                'service_id' => 83,
                'provider_id' => 4,
                'date' => '2023-09-27 11:42:00',
                'start_at' => '2023-09-27 11:48:39',
                'end_at' => '2023-09-27 11:48:44',
                'quantity' => 1,
                'amount' => 42.0,
                'discount' => 2.0,
                'total_amount' => 46.34,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Australia',
                'payment_id' => 21,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 06:12:24',
                'updated_at' => '2023-09-27 06:19:12',
                'booking_address_id' => NULL,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 42.0,
                'final_total_tax' => 6.02,
                'final_sub_total' => 40.32,
                'final_discount_amount' => 0.84,
                'final_coupon_discount_amount' => 0.84,
            ],
            [
                'id' => 61,
                'customer_id' => 3,
                'service_id' => 59,
                'provider_id' => 4,
                'date' => '2023-09-27 12:31:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 42.0,
                'discount' => 0.0,
                'total_amount' => 46.78,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'pending',
                'address' => 'Brenda street, UK',
                'payment_id' => 22,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 07:01:32',
                'updated_at' => '2023-09-27 07:02:07',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 61,
                    'created_at' => '2023-09-27 12:31:33',
                    'id' => 45,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-27 12:31:33',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 4.678,
                'final_total_service_price' => 42.0,
                'final_total_tax' => 6.04,
                'final_sub_total' => 40.74,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 1.26,
            ],
            [
                'id' => 62,
                'customer_id' => 3,
                'service_id' => 110,
                'provider_id' => 4,
                'date' => '2023-09-27 15:55:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 16.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'on_going',
                'address' => 'SJ, Canada',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 10:25:54',
                'updated_at' => '2023-09-27 10:27:36',
                'booking_address' =>[
                    'address' => 'Yorkton, SK, Canada',
                    'booking_id' => 62,
                    'created_at' => '2023-09-27 15:55:55',
                    'id' => 46,
                    'latitude' => '51.213890',
                    'longitude' => '102.462776',
                    'updated_at' => '2023-09-27 15:55:55',
                ],
                'booking_address_id' => 7,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.6,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 63,
                'customer_id' => 3,
                'service_id' => 38,
                'provider_id' => 4,
                'date' => '2023-09-27 15:58:00',
                'start_at' => '2023-09-27 16:03:50',
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => 0.0,
                'total_amount' => 40.75,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'in_progress',
                'address' => 'Umbrella Villa,UK',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 10:29:29',
                'updated_at' => '2023-09-27 10:33:53',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 63,
                    'created_at' => '2023-09-27 15:59:31',
                    'id' => 47,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-27 15:59:31',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 5.75,
                'final_sub_total' => 35.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 64,
                'customer_id' => 3,
                'service_id' => 34,
                'provider_id' => 4,
                'date' => '2023-09-29 00:00:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 0.0,
                'total_amount' => 27.1,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'accept',
                'address' => 'Australia',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 10:34:43',
                'updated_at' => '2023-09-27 10:35:33',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 64,
                    'created_at' => '2023-09-27 16:04:44',
                    'id' => 48,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-27 16:04:44',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => '11:00:00',
                'booking_day' => 'fri',
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 5.1,
                'final_sub_total' => 22.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 65,
                'customer_id' => 3,
                'service_id' => 63,
                'provider_id' => 4,
                'date' => '2023-09-27 00:00:00',
                'start_at' => '2023-09-27 16:09:41',
                'end_at' => '2023-09-27 16:09:52',
                'quantity' => 1,
                'amount' => 20.0,
                'discount' => 0.0,
                'total_amount' => 54.4,
                'description' => NULL,
                'reason' => 'Done ✅',
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'United States',
                'payment_id' => 23,
                'duration_diff' => '11',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 10:37:53',
                'updated_at' => '2023-09-27 11:39:42',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 65,
                    'created_at' => '2023-09-27 16:07:54',
                    'id' => 49,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-27 16:07:54',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => '18:00:00',
                'booking_day' => 'wed',
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 20.0,
                'final_total_tax' => 6.4,
                'final_sub_total' => 20.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 66,
                'customer_id' => 3,
                'service_id' => 104,
                'provider_id' => 4,
                'date' => '2023-09-29 17:12:00',
                'start_at' => '2023-09-27 17:15:30',
                'end_at' => '2023-09-27 17:15:49',
                'quantity' => 1,
                'amount' => 45.0,
                'discount' => 0.0,
                'total_amount' => 48.1,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Southampton',
                'payment_id' => 24,
                'duration_diff' => '19',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 11:42:16',
                'updated_at' => '2023-09-27 11:47:16',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 66,
                    'created_at' => '2023-09-27 17:12:17',
                    'id' => 50,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-27 17:12:17',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 45.0,
                'final_total_tax' => 6.1,
                'final_sub_total' => 42.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 67,
                'customer_id' => 3,
                'service_id' => 103,
                'provider_id' => 15,
                'date' => '2023-09-30 17:18:00',
                'start_at' => '2023-09-27 17:20:03',
                'end_at' => '2023-09-27 17:20:07',
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 0.0,
                'total_amount' => 26.25,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Roof top, Usa',
                'payment_id' => 25,
                'duration_diff' => '4',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 11:48:47',
                'updated_at' => '2023-09-27 11:51:02',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 67,
                    'created_at' => '2023-09-27 17:18:48',
                    'id' => 51,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-09-27 17:18:48',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":81,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 1.25,
                'final_sub_total' => 25.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 68,
                'customer_id' => 3,
                'service_id' => 90,
                'provider_id' => 17,
                'date' => '2023-10-01 17:21:00',
                'start_at' => '2023-09-27 17:23:10',
                'end_at' => '2023-09-27 17:23:15',
                'quantity' => 1,
                'amount' => 42.0,
                'discount' => 0.0,
                'total_amount' => 47.22,
                'description' => NULL,
                'reason' => 'Confirm ?',
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Scotland',
                'payment_id' => 26,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 11:51:41',
                'updated_at' => '2023-09-27 11:54:12',
                'booking_address' =>[
                    'address' => 'Elgin, Scotland, UK',
                    'booking_id' => 68,
                    'created_at' => '2023-09-27 17:21:42',
                    'id' => 52,
                    'latitude' => '57.653484',
                    'longitude' => '-3.335724',
                    'updated_at' => '2023-09-27 17:21:42',
                ],
                'booking_address_id' => 30,
                'tax' => '[{"id":99,"provider_id":17,"title":"Service Tax","type":"percent","value":5},{"id":100,"provider_id":17,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 42.0,
                'final_total_tax' => 6.06,
                'final_sub_total' => 41.16,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.84,
            ],
            [
                'id' => 69,
                'customer_id' => 3,
                'service_id' => 109,
                'provider_id' => 4,
                'date' => '2023-10-01 00:00:00',
                'start_at' => '2023-09-27 17:32:16',
                'end_at' => '2023-09-27 17:32:21',
                'quantity' => 1,
                'amount' => 43.0,
                'discount' => 0.0,
                'total_amount' => 73.3,
                'description' => NULL,
                'reason' => 'Done ?✅',
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Uk',
                'payment_id' => 27,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 11:55:24',
                'updated_at' => '2023-09-27 12:03:13',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 69,
                    'created_at' => '2023-09-27 17:25:25',
                    'id' => 53,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-27 17:25:25',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => '10:00:00',
                'booking_day' => 'sun',
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 43.0,
                'final_total_tax' => 7.3,
                'final_sub_total' => 40.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 70,
                'customer_id' => 3,
                'service_id' => 102,
                'provider_id' => 4,
                'date' => '2023-09-29 17:34:00',
                'start_at' => '2023-09-27 17:35:36',
                'end_at' => '2023-09-27 17:35:41',
                'quantity' => 1,
                'amount' => 28.0,
                'discount' => 0.0,
                'total_amount' => 30.25,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Saint hostel, Canada',
                'payment_id' => 28,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 12:04:33',
                'updated_at' => '2023-09-27 12:06:40',
                'booking_address' =>[
                    'address' => 'Mont-Saint-Hilaire, QC, Canada',
                    'booking_id' => 70,
                    'created_at' => '2023-09-27 17:34:34',
                    'id' => 54,
                    'latitude' => '45.562222',
                    'longitude' => '-73.191666',
                    'updated_at' => '2023-09-27 17:34:34',
                ],
                'booking_address_id' => 4,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 28.0,
                'final_total_tax' => 5.25,
                'final_sub_total' => 25.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 71,
                'customer_id' => 3,
                'service_id' => 108,
                'provider_id' => 15,
                'date' => '2023-10-05 17:37:00',
                'start_at' => '2023-09-27 17:40:44',
                'end_at' => '2023-09-27 17:40:50',
                'quantity' => 1,
                'amount' => 18.0,
                'discount' => 2.0,
                'total_amount' => 18.52,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Greenbelt, USA',
                'payment_id' => 29,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 12:07:47',
                'updated_at' => '2023-09-27 12:11:26',
                'booking_address' =>[
                    'address' => 'Greenbelt, MD, USA',
                    'booking_id' => 71,
                    'created_at' => '2023-09-27 17:37:48',
                    'id' => 55,
                    'latitude' => '38.998318',
                    'longitude' => '-76.896332',
                    'updated_at' => '2023-09-27 17:37:48',
                ],
                'booking_address_id' => 26,
                'tax' => '[{"id":81,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 18.0,
                'final_total_tax' => 0.88,
                'final_sub_total' => 17.64,
                'final_discount_amount' => 0.36,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 72,
                'customer_id' => 3,
                'service_id' => 82,
                'provider_id' => 4,
                'date' => '2023-09-27 17:43:00',
                'start_at' => '2023-09-27 17:50:20',
                'end_at' => '2023-09-27 17:50:25',
                'quantity' => 1,
                'amount' => 36.0,
                'discount' => 5.0,
                'total_amount' => 65.4,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Belinda,USA',
                'payment_id' => 30,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 12:14:20',
                'updated_at' => '2023-09-27 12:30:07',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 72,
                    'created_at' => '2023-09-27 17:44:21',
                    'id' => 56,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-09-27 17:44:21',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 36.0,
                'final_total_tax' => 6.92,
                'final_sub_total' => 33.48,
                'final_discount_amount' => 1.8,
                'final_coupon_discount_amount' => 0.72,
            ],
            [
                'id' => 73,
                'customer_id' => 3,
                'service_id' => 83,
                'provider_id' => 4,
                'date' => '2023-09-27 18:00:00',
                'start_at' => '2023-09-27 18:02:46',
                'end_at' => '2023-09-27 18:02:51',
                'quantity' => 1,
                'amount' => 42.0,
                'discount' => 2.0,
                'total_amount' => 46.34,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Canada',
                'payment_id' => 31,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 12:30:47',
                'updated_at' => '2023-09-27 12:33:39',
                'booking_address_id' => NULL,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 42.0,
                'final_total_tax' => 6.02,
                'final_sub_total' => 40.32,
                'final_discount_amount' => 0.84,
                'final_coupon_discount_amount' => 0.84,
            ],
            [
                'id' => 74,
                'customer_id' => 3,
                'service_id' => 84,
                'provider_id' => 4,
                'date' => '2023-09-27 18:06:00',
                'start_at' => '2023-09-27 18:08:41',
                'end_at' => '2023-09-27 18:08:46',
                'quantity' => 1,
                'amount' => 36.0,
                'discount' => 4.0,
                'total_amount' => 40.29,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Uk',
                'payment_id' => 32,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 12:37:05',
                'updated_at' => '2023-09-27 12:41:48',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 74,
                    'created_at' => '2023-09-27 18:07:06',
                    'id' => 57,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-27 18:07:06',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 36.0,
                'final_total_tax' => 5.73,
                'final_sub_total' => 34.56,
                'final_discount_amount' => 1.44,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 75,
                'customer_id' => 3,
                'service_id' => 100,
                'provider_id' => 4,
                'date' => '2023-10-02 18:12:00',
                'start_at' => '2023-09-29 11:15:22',
                'end_at' => '2023-09-29 11:15:28',
                'quantity' => 1,
                'amount' => 37.0,
                'discount' => 0.0,
                'total_amount' => 39.7,
                'description' => 'Vendor, Australia',
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Canada',
                'payment_id' => 33,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-27 12:43:12',
                'updated_at' => '2023-09-29 05:45:58',
                'booking_address' =>[
                    'address' => 'Brisbane, Australia',
                    'booking_id' => 75,
                    'created_at' => '2023-09-27 18:13:13',
                    'id' => 58,
                    'latitude' => '-27.4678',
                    'longitude' => '153.0281',
                    'updated_at' => '2023-09-27 18:13:13',
                ],
                'booking_address_id' => 6,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 37.0,
                'final_total_tax' => 5.7,
                'final_sub_total' => 34.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 76,
                'customer_id' => 3,
                'service_id' => 92,
                'provider_id' => 7,
                'date' => '2023-09-29 11:16:00',
                'start_at' => '2023-09-29 11:16:00',
                'end_at' => '2023-09-29 11:17:55',
                'quantity' => 1,
                'amount' => 20.0,
                'discount' => 2.0,
                'total_amount' => 20.58,
                'description' => NULL,
                'reason' => 'I don\'t want this service now',
                'coupon_id' => NULL,
                'status' => 'cancelled',
                'address' => 'Canada',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 05:46:39',
                'updated_at' => '2023-09-29 05:47:57',
                'booking_address' =>[
                    'address' => 'Belfast, UK',
                    'booking_id' => 76,
                    'created_at' => '2023-09-29 11:16:40',
                    'id' => 59,
                    'latitude' => '54.607868',
                    'longitude' => '-5.926437',
                    'updated_at' => '2023-09-29 11:16:40',
                ],
                'booking_address_id' => 13,
                'tax' => '[{"id":93,"provider_id":7,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 0.0,
                'final_total_service_price' => 20.0,
                'final_total_tax' => 0.98,
                'final_sub_total' => 19.6,
                'final_discount_amount' => 0.4,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 77,
                'customer_id' => 3,
                'service_id' => 92,
                'provider_id' => 7,
                'date' => '2023-09-30 11:18:00',
                'start_at' => '2023-09-29 11:20:07',
                'end_at' => '2023-09-29 11:20:14',
                'quantity' => 1,
                'amount' => 20.0,
                'discount' => 2.0,
                'total_amount' => 20.16,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Keh vila, UK',
                'payment_id' => 34,
                'duration_diff' => '7',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 05:48:30',
                'updated_at' => '2023-09-29 05:50:42',
                'booking_address' =>[
                    'address' => 'Belfast, UK',
                    'booking_id' => 77,
                    'created_at' => '2023-09-29 11:18:31',
                    'id' => 60,
                    'latitude' => '54.607868',
                    'longitude' => '-5.926437',
                    'updated_at' => '2023-09-29 11:18:31',
                ],
                'booking_address_id' => 13,
                'tax' => '[{"id":93,"provider_id":7,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 20.0,
                'final_total_tax' => 0.96,
                'final_sub_total' => 19.2,
                'final_discount_amount' => 0.4,
                'final_coupon_discount_amount' => 0.4,
            ],
            [
                'id' => 78,
                'customer_id' => 3,
                'service_id' => 86,
                'provider_id' => 4,
                'date' => '2023-09-29 11:21:00',
                'start_at' => '2023-09-29 11:49:49',
                'end_at' => '2023-09-29 11:50:11',
                'quantity' => 1,
                'amount' => 28.0,
                'discount' => 5.0,
                'total_amount' => 31.93,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Canada',
                'payment_id' => 36,
                'duration_diff' => '22',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 05:51:20',
                'updated_at' => '2023-09-29 06:21:22',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 78,
                    'created_at' => '2023-09-29 11:21:21',
                    'id' => 61,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-09-29 11:21:21',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 28.0,
                'final_total_tax' => 5.33,
                'final_sub_total' => 26.6,
                'final_discount_amount' => 1.4,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 79,
                'customer_id' => 3,
                'service_id' => 106,
                'provider_id' => 15,
                'date' => '2023-09-29 11:51:00',
                'start_at' => '2023-09-29 11:54:14',
                'end_at' => '2023-09-29 11:54:19',
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 2.0,
                'total_amount' => 23.6,
                'description' => NULL,
                'reason' => 'Done ?',
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Fresh house',
                'payment_id' => 37,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 06:22:02',
                'updated_at' => '2023-09-29 06:25:09',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 79,
                    'created_at' => '2023-09-29 11:52:03',
                    'id' => 62,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-09-29 11:52:03',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":81,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 1.12,
                'final_sub_total' => 22.48,
                'final_discount_amount' => 0.52,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 80,
                'customer_id' => 3,
                'service_id' => 105,
                'provider_id' => 4,
                'date' => '2023-10-02 11:56:00',
                'start_at' => '2023-09-29 11:58:53',
                'end_at' => '2023-09-29 11:59:00',
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => 4.0,
                'total_amount' => 36.13,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Australia ??',
                'payment_id' => 38,
                'duration_diff' => '7',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 06:27:02',
                'updated_at' => '2023-09-29 06:29:45',
                'booking_address' =>[
                    'address' => 'Brisbane, Australia',
                    'booking_id' => 80,
                    'created_at' => '2023-09-29 11:57:03',
                    'id' => 63,
                    'latitude' => '-27.4678',
                    'longitude' => '153.0281',
                    'updated_at' => '2023-09-29 11:57:03',
                ],
                'booking_address_id' => 6,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 5.53,
                'final_sub_total' => 30.6,
                'final_discount_amount' => 1.4,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 84,
                'customer_id' => 3,
                'service_id' => 107,
                'provider_id' => 4,
                'date' => '2023-09-29 12:29:00',
                'start_at' => '2023-09-29 12:31:43',
                'end_at' => '2023-09-29 12:31:50',
                'quantity' => 1,
                'amount' => 32.0,
                'discount' => 0.0,
                'total_amount' => 37.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Canada',
                'payment_id' => 46,
                'duration_diff' => '7',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 06:59:47',
                'updated_at' => '2023-09-29 07:02:31',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 84,
                    'created_at' => '2023-09-29 12:29:48',
                    'id' => 67,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-29 12:29:48',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 0.752,
                'final_total_service_price' => 32.0,
                'final_total_tax' => 5.6,
                'final_sub_total' => 32.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 85,
                'customer_id' => 3,
                'service_id' => 34,
                'provider_id' => 4,
                'date' => '2023-09-29 00:00:00',
                'start_at' => '2023-09-29 12:59:16',
                'end_at' => '2023-09-29 12:59:22',
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 0.0,
                'total_amount' => 31.3,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Greenville',
                'payment_id' => 47,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 07:28:18',
                'updated_at' => '2023-09-29 07:29:49',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 85,
                    'created_at' => '2023-09-29 12:58:19',
                    'id' => 68,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-29 12:58:19',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => '14:00:00',
                'booking_day' => 'fri',
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 5.3,
                'final_sub_total' => 26.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 86,
                'customer_id' => 3,
                'service_id' => 38,
                'provider_id' => 4,
                'date' => '2023-10-12 13:02:00',
                'start_at' => '2023-09-29 13:05:41',
                'end_at' => '2023-09-29 13:05:47',
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => 0.0,
                'total_amount' => 47.05,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'completed',
                'address' => 'Hexagon House',
                'payment_id' => 49,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 07:32:17',
                'updated_at' => '2023-09-29 07:36:32',
                'booking_address' =>[
                    'address' => 'Hazard, KY, USA',
                    'booking_id' => 86,
                    'created_at' => '2023-09-29 13:02:18',
                    'id' => 69,
                    'latitude' => '37.250626',
                    'longitude' => '-83.195503',
                    'updated_at' => '2023-09-29 13:02:18',
                ],
                'booking_address_id' => 10,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 6.05,
                'final_sub_total' => 31.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 87,
                'customer_id' => 3,
                'service_id' => 110,
                'provider_id' => 4,
                'date' => '2023-10-06 13:07:00',
                'start_at' => '2023-09-29 13:09:56',
                'end_at' => '2023-09-29 13:10:02',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 16.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Australia ?',
                'payment_id' => 52,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 07:38:07',
                'updated_at' => '2023-09-29 07:40:27',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 87,
                    'created_at' => '2023-09-29 13:08:08',
                    'id' => 70,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-09-29 13:08:08',
                ],
                'booking_address_id' => 5,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.6,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 88,
                'customer_id' => 3,
                'service_id' => 97,
                'provider_id' => 4,
                'date' => '2023-10-06 13:11:00',
                'start_at' => '2023-09-29 13:13:15',
                'end_at' => '2023-09-29 13:13:20',
                'quantity' => 1,
                'amount' => 39.0,
                'discount' => 0.0,
                'total_amount' => 41.8,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Erom Vila',
                'payment_id' => 54,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 07:42:03',
                'updated_at' => '2023-09-29 07:44:08',
                'booking_address' =>[
                    'address' => 'Morgan City, LA, USA',
                    'booking_id' => 88,
                    'created_at' => '2023-09-29 13:12:04',
                    'id' => 71,
                    'latitude' => '29.706043',
                    'longitude' => '-91.206917',
                    'updated_at' => '2023-09-29 13:12:04',
                ],
                'booking_address_id' => 8,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 39.0,
                'final_total_tax' => 5.8,
                'final_sub_total' => 36.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 89,
                'customer_id' => 3,
                'service_id' => 33,
                'provider_id' => 4,
                'date' => '2023-10-04 13:14:00',
                'start_at' => '2023-09-29 13:16:11',
                'end_at' => '2023-09-29 13:18:43',
                'quantity' => 1,
                'amount' => 42.0,
                'discount' => 2.0,
                'total_amount' => 43.02,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'completed',
                'address' => 'Ashland',
                'payment_id' => 57,
                'duration_diff' => '152',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 07:44:42',
                'updated_at' => '2023-09-29 07:49:01',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 89,
                    'created_at' => '2023-09-29 13:14:43',
                    'id' => 72,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-09-29 13:14:43',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 42.0,
                'final_total_tax' => 5.86,
                'final_sub_total' => 37.16,
                'final_discount_amount' => 0.84,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 90,
                'customer_id' => 3,
                'service_id' => 17,
                'provider_id' => 4,
                'date' => '2023-10-04 13:19:00',
                'start_at' => '2023-09-29 13:21:07',
                'end_at' => '2023-09-29 13:21:11',
                'quantity' => 1,
                'amount' => 22.0,
                'discount' => NULL,
                'total_amount' => 21.85,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 1,
                'status' => 'completed',
                'address' => 'USA',
                'payment_id' => 58,
                'duration_diff' => '4',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 07:49:56',
                'updated_at' => '2023-09-29 07:51:57',
                'booking_address' =>[
                    'address' => 'Morgan City, LA, USA',
                    'booking_id' => 90,
                    'created_at' => '2023-09-29 13:19:57',
                    'id' => 73,
                    'latitude' => '29.706043',
                    'longitude' => '-91.206917',
                    'updated_at' => '2023-09-29 13:19:57',
                ],
                'booking_address_id' => 8,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 22.0,
                'final_total_tax' => 4.85,
                'final_sub_total' => 17.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 5.0,
            ],
            [
                'id' => 91,
                'customer_id' => 3,
                'service_id' => 35,
                'provider_id' => 4,
                'date' => '2023-09-29 13:23:00',
                'start_at' => '2023-09-29 13:27:10',
                'end_at' => '2023-09-29 13:27:16',
                'quantity' => 1,
                'amount' => 38.0,
                'discount' => 4.0,
                'total_amount' => 42.3,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Trusty street',
                'payment_id' => 59,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 07:54:09',
                'updated_at' => '2023-09-29 07:58:23',
                'booking_address' =>[
                    'address' => 'Brisbane, Australia',
                    'booking_id' => 91,
                    'created_at' => '2023-09-29 13:24:10',
                    'id' => 74,
                    'latitude' => '-27.4678',
                    'longitude' => '153.0281',
                    'updated_at' => '2023-09-29 13:24:10',
                ],
                'booking_address_id' => 6,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 38.0,
                'final_total_tax' => 5.82,
                'final_sub_total' => 36.48,
                'final_discount_amount' => 1.52,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 92,
                'customer_id' => 3,
                'service_id' => 46,
                'provider_id' => 13,
                'date' => '2023-09-30 13:28:00',
                'start_at' => '2023-09-29 13:30:19',
                'end_at' => '2023-09-29 13:30:25',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 19.28,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'completed',
                'address' => 'Warna street',
                'payment_id' => 60,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 07:59:11',
                'updated_at' => '2023-09-29 08:00:49',
                'booking_address' =>[
                    'address' => 'Warman, SK, Canada',
                    'booking_id' => 92,
                    'created_at' => '2023-09-29 13:29:12',
                    'id' => 75,
                    'latitude' => '52.321945',
                    'longitude' => '-106.584167',
                    'updated_at' => '2023-09-29 13:29:12',
                ],
                'booking_address_id' => 22,
                'tax' => '[{"id":84,"provider_id":13,"title":"Service Tax","type":"percent","value":5},{"id":85,"provider_id":13,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.73,
                'final_sub_total' => 14.55,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.45,
            ],
            [
                'id' => 93,
                'customer_id' => 3,
                'service_id' => 99,
                'provider_id' => 4,
                'date' => '2023-10-04 13:31:00',
                'start_at' => '2023-09-29 13:38:16',
                'end_at' => '2023-09-29 13:38:21',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 19.75,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => '☀️ gill house',
                'payment_id' => 61,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 08:01:41',
                'updated_at' => '2023-09-29 08:08:46',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 93,
                    'created_at' => '2023-09-29 13:31:42',
                    'id' => 76,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-09-29 13:31:42',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.75,
                'final_sub_total' => 15.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 94,
                'customer_id' => 3,
                'service_id' => 49,
                'provider_id' => 4,
                'date' => '2023-10-10 13:39:00',
                'start_at' => '2023-09-29 13:41:51',
                'end_at' => '2023-09-29 13:41:57',
                'quantity' => 1,
                'amount' => 41.0,
                'discount' => 1.0,
                'total_amount' => 46.62,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Sour hill',
                'payment_id' => 62,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 08:10:20',
                'updated_at' => '2023-09-29 08:12:24',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 94,
                    'created_at' => '2023-09-29 13:40:21',
                    'id' => 77,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-29 13:40:21',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 41.0,
                'final_total_tax' => 6.03,
                'final_sub_total' => 40.59,
                'final_discount_amount' => 0.41,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 95,
                'customer_id' => 3,
                'service_id' => 80,
                'provider_id' => 4,
                'date' => '2023-09-29 13:44:00',
                'start_at' => '2023-09-29 13:46:22',
                'end_at' => '2023-09-29 13:46:27',
                'quantity' => 1,
                'amount' => 28.0,
                'discount' => 7.0,
                'total_amount' => 30.75,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Freedom',
                'payment_id' => 64,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 08:15:17',
                'updated_at' => '2023-09-29 08:16:52',
                'booking_address' =>[
                    'address' => 'Mont-Saint-Hilaire, QC, Canada',
                    'booking_id' => 95,
                    'created_at' => '2023-09-29 13:45:18',
                    'id' => 78,
                    'latitude' => '45.562222',
                    'longitude' => '-73.191666',
                    'updated_at' => '2023-09-29 13:45:18',
                ],
                'booking_address_id' => 4,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 28.0,
                'final_total_tax' => 5.27,
                'final_sub_total' => 25.48,
                'final_discount_amount' => 1.96,
                'final_coupon_discount_amount' => 0.56,
            ],
            [
                'id' => 96,
                'customer_id' => 3,
                'service_id' => 91,
                'provider_id' => 4,
                'date' => '2023-10-09 13:51:00',
                'start_at' => '2023-09-29 13:53:58',
                'end_at' => '2023-09-29 13:54:05',
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 2.0,
                'total_amount' => 30.21,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Southampton',
                'payment_id' => 65,
                'duration_diff' => '7',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 08:22:10',
                'updated_at' => '2023-09-29 08:25:08',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 96,
                    'created_at' => '2023-09-29 13:52:11',
                    'id' => 79,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-29 13:52:11',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 5.25,
                'final_sub_total' => 24.96,
                'final_discount_amount' => 0.52,
                'final_coupon_discount_amount' => 0.52,
            ],
            [
                'id' => 97,
                'customer_id' => 3,
                'service_id' => 62,
                'provider_id' => 4,
                'date' => '2023-10-07 13:55:00',
                'start_at' => '2023-09-29 13:57:21',
                'end_at' => '2023-09-29 13:57:26',
                'quantity' => 1,
                'amount' => 18.0,
                'discount' => 0.0,
                'total_amount' => 15.55,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => 'QC Canada',
                'payment_id' => 66,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 08:25:46',
                'updated_at' => '2023-09-29 08:27:54',
                'booking_address' =>[
                    'address' => 'Mont-Saint-Hilaire, QC, Canada',
                    'booking_id' => 97,
                    'created_at' => '2023-09-29 13:55:47',
                    'id' => 80,
                    'latitude' => '45.562222',
                    'longitude' => '-73.191666',
                    'updated_at' => '2023-09-29 13:55:47',
                ],
                'booking_address_id' => 4,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 18.0,
                'final_total_tax' => 4.55,
                'final_sub_total' => 11.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 98,
                'customer_id' => 3,
                'service_id' => 65,
                'provider_id' => 14,
                'date' => '2023-10-05 14:00:00',
                'start_at' => '2023-09-29 14:03:22',
                'end_at' => '2023-09-29 14:03:27',
                'quantity' => 1,
                'amount' => 40.0,
                'discount' => 0.0,
                'total_amount' => 37.0,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => 'Canada',
                'payment_id' => 67,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 08:31:10',
                'updated_at' => '2023-09-29 08:34:10',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 98,
                    'created_at' => '2023-09-29 14:01:11',
                    'id' => 81,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-09-29 14:01:11',
                ],
                'booking_address_id' => 23,
                'tax' => '[{"id":101,"provider_id":14,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 40.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 33.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 99,
                'customer_id' => 3,
                'service_id' => 73,
                'provider_id' => 16,
                'date' => '2023-10-09 14:36:00',
                'start_at' => '2023-09-29 14:39:13',
                'end_at' => '2023-09-29 14:39:19',
                'quantity' => 1,
                'amount' => 16.0,
                'discount' => 0.0,
                'total_amount' => 13.0,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => 'Australia',
                'payment_id' => 68,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 09:06:55',
                'updated_at' => '2023-09-29 09:09:50',
                'booking_address' =>[
                    'address' => 'Newcastle, Australia',
                    'booking_id' => 99,
                    'created_at' => '2023-09-29 14:36:56',
                    'id' => 82,
                    'latitude' => '-32.9167',
                    'longitude' => '151.7500',
                    'updated_at' => '2023-09-29 14:36:56',
                ],
                'booking_address_id' => 27,
                'tax' => '[{"id":71,"provider_id":16,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 16.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 9.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 100,
                'customer_id' => 3,
                'service_id' => 108,
                'provider_id' => 15,
                'date' => '2023-09-29 14:40:00',
                'start_at' => '2023-09-29 14:42:33',
                'end_at' => '2023-09-29 14:44:45',
                'quantity' => 1,
                'amount' => 18.0,
                'discount' => 2.0,
                'total_amount' => 18.52,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Rooftop',
                'payment_id' => 69,
                'duration_diff' => '132',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 09:10:24',
                'updated_at' => '2023-09-29 09:15:11',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 100,
                    'created_at' => '2023-09-29 14:40:25',
                    'id' => 83,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-09-29 14:40:25',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":81,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 18.0,
                'final_total_tax' => 0.88,
                'final_sub_total' => 17.64,
                'final_discount_amount' => 0.36,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 101,
                'customer_id' => 3,
                'service_id' => 96,
                'provider_id' => 4,
                'date' => '2023-10-08 14:47:00',
                'start_at' => '2023-09-29 14:49:21',
                'end_at' => '2023-09-29 14:50:34',
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 0.0,
                'total_amount' => 31.3,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Tyga point',
                'payment_id' => 70,
                'duration_diff' => '73',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 09:17:48',
                'updated_at' => '2023-09-29 09:21:22',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 101,
                    'created_at' => '2023-09-29 14:47:49',
                    'id' => 84,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-29 14:47:49',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 5.3,
                'final_sub_total' => 26.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 102,
                'customer_id' => 3,
                'service_id' => 95,
                'provider_id' => 4,
                'date' => '2023-10-06 14:53:00',
                'start_at' => '2023-09-29 14:55:25',
                'end_at' => '2023-09-29 14:55:30',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 19.43,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Destiny housing',
                'payment_id' => 71,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 09:23:43',
                'updated_at' => '2023-09-29 09:25:55',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 102,
                    'created_at' => '2023-09-29 14:53:44',
                    'id' => 85,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-09-29 14:53:44',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.73,
                'final_sub_total' => 14.7,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.3,
            ],
            [
                'id' => 103,
                'customer_id' => 3,
                'service_id' => 68,
                'provider_id' => 15,
                'date' => '2023-10-02 14:57:00',
                'start_at' => '2023-09-29 14:59:48',
                'end_at' => '2023-09-29 14:59:57',
                'quantity' => 1,
                'amount' => 41.0,
                'discount' => 0.0,
                'total_amount' => 35.7,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => 'Red fort housing',
                'payment_id' => 72,
                'duration_diff' => '9',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 09:27:59',
                'updated_at' => '2023-09-29 09:31:02',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 103,
                    'created_at' => '2023-09-29 14:58:00',
                    'id' => 86,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-09-29 14:58:00',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":81,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 41.0,
                'final_total_tax' => 1.7,
                'final_sub_total' => 34.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 104,
                'customer_id' => 3,
                'service_id' => 98,
                'provider_id' => 12,
                'date' => '2023-10-04 15:04:00',
                'start_at' => '2023-09-29 15:06:10',
                'end_at' => '2023-09-29 15:06:15',
                'quantity' => 1,
                'amount' => 24.0,
                'discount' => 0.0,
                'total_amount' => 26.05,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Candy ? beach',
                'payment_id' => 73,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 09:34:26',
                'updated_at' => '2023-09-29 09:36:43',
                'booking_address' =>[
                    'address' => 'Sandy Beach, Canada',
                    'booking_id' => 104,
                    'created_at' => '2023-09-29 15:04:27',
                    'id' => 87,
                    'latitude' => '-30.1483',
                    'longitude' => '153.2011',
                    'updated_at' => '2023-09-29 15:04:27',
                ],
                'booking_address_id' => 20,
                'tax' => '[{"id":65,"provider_id":12,"title":"Service Tax","type":"percent","value":5},{"id":66,"provider_id":12,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 24.0,
                'final_total_tax' => 5.05,
                'final_sub_total' => 21.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 105,
                'customer_id' => 3,
                'service_id' => 70,
                'provider_id' => 4,
                'date' => '2023-09-29 19:08:00',
                'start_at' => '2023-09-29 15:10:09',
                'end_at' => '2023-09-29 15:10:14',
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 0.0,
                'total_amount' => 23.95,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => 'Sera town',
                'payment_id' => 74,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 09:38:27',
                'updated_at' => '2023-09-29 09:41:03',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 105,
                    'created_at' => '2023-09-29 15:08:28',
                    'id' => 88,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-09-29 15:08:28',
                ],
                'booking_address_id' => 5,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 4.95,
                'final_sub_total' => 19.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 106,
                'customer_id' => 3,
                'service_id' => 101,
                'provider_id' => 4,
                'date' => '2023-09-29 18:40:00',
                'start_at' => '2023-09-29 18:43:47',
                'end_at' => '2023-09-29 18:43:52',
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => 0.0,
                'total_amount' => 37.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Hill road ?️',
                'payment_id' => 75,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 13:11:24',
                'updated_at' => '2023-09-29 13:14:17',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 106,
                    'created_at' => '2023-09-29 18:41:25',
                    'id' => 89,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-29 18:41:25',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 5.6,
                'final_sub_total' => 32.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 107,
                'customer_id' => 3,
                'service_id' => 70,
                'provider_id' => 4,
                'date' => '2023-10-11 18:49:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 0.0,
                'total_amount' => 23.95,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'pending',
                'address' => 'Roy villa house ?',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 13:19:57',
                'updated_at' => '2023-09-29 13:19:57',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 107,
                    'created_at' => '2023-09-29 18:49:58',
                    'id' => 90,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-29 18:49:58',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 4.95,
                'final_sub_total' => 19.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 108,
                'customer_id' => 3,
                'service_id' => 59,
                'provider_id' => 4,
                'date' => '2023-10-09 18:50:00',
                'start_at' => '2023-09-29 18:55:48',
                'end_at' => '2023-09-29 18:55:54',
                'quantity' => 1,
                'amount' => 42.0,
                'discount' => 0.0,
                'total_amount' => 46.78,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'completed',
                'address' => 'Toys Market building ?',
                'payment_id' => 77,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 13:21:05',
                'updated_at' => '2023-09-29 13:27:41',
                'booking_address' =>[
                    'address' => 'Yorkton, SK, Canada',
                    'booking_id' => 108,
                    'created_at' => '2023-09-29 18:51:06',
                    'id' => 91,
                    'latitude' => '51.213890',
                    'longitude' => '102.462776',
                    'updated_at' => '2023-09-29 18:51:06',
                ],
                'booking_address_id' => 7,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 4.678,
                'final_total_service_price' => 42.0,
                'final_total_tax' => 6.04,
                'final_sub_total' => 40.74,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 1.26,
            ],
            [
                'id' => 109,
                'customer_id' => 3,
                'service_id' => 71,
                'provider_id' => 4,
                'date' => '2023-10-05 18:59:00',
                'start_at' => '2023-09-29 19:03:32',
                'end_at' => '2023-09-29 19:06:26',
                'quantity' => 1,
                'amount' => 45.0,
                'discount' => 2.0,
                'total_amount' => 42.95,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => 'Mountain ?️ view apartment',
                'payment_id' => 78,
                'duration_diff' => '174',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 13:29:25',
                'updated_at' => '2023-09-29 13:37:14',
                'booking_address' =>[
                    'address' => 'Mont-Saint-Hilaire, QC, Canada',
                    'booking_id' => 109,
                    'created_at' => '2023-09-29 18:59:26',
                    'id' => 92,
                    'latitude' => '45.562222',
                    'longitude' => '-73.191666',
                    'updated_at' => '2023-09-29 18:59:26',
                ],
                'booking_address_id' => 4,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 45.0,
                'final_total_tax' => 5.85,
                'final_sub_total' => 37.1,
                'final_discount_amount' => 0.9,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 110,
                'customer_id' => 3,
                'service_id' => 55,
                'provider_id' => 4,
                'date' => '2023-10-06 19:10:00',
                'start_at' => '2023-09-29 19:12:38',
                'end_at' => '2023-09-29 19:12:43',
                'quantity' => 1,
                'amount' => 41.0,
                'discount' => 0.0,
                'total_amount' => 45.76,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'completed',
                'address' => 'Morgantown housing',
                'payment_id' => 79,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-29 13:41:00',
                'updated_at' => '2023-09-29 13:43:14',
                'booking_address' =>[
                    'address' => 'Morgan City, LA, USA',
                    'booking_id' => 110,
                    'created_at' => '2023-09-29 19:11:01',
                    'id' => 93,
                    'latitude' => '29.706043',
                    'longitude' => '-91.206917',
                    'updated_at' => '2023-09-29 19:11:01',
                ],
                'booking_address_id' => 8,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 41.0,
                'final_total_tax' => 5.99,
                'final_sub_total' => 39.77,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 1.23,
            ],
            [
                'id' => 111,
                'customer_id' => 3,
                'service_id' => 89,
                'provider_id' => 4,
                'date' => '2023-09-30 10:59:00',
                'start_at' => '2023-09-30 11:01:55',
                'end_at' => '2023-09-30 11:02:01',
                'quantity' => 1,
                'amount' => 34.0,
                'discount' => 3.0,
                'total_amount' => 37.91,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Retro road ?️',
                'payment_id' => 80,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 05:30:05',
                'updated_at' => '2023-09-30 05:32:28',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 111,
                    'created_at' => '2023-09-30 11:00:06',
                    'id' => 94,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-09-30 11:00:06',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 34.0,
                'final_total_tax' => 5.61,
                'final_sub_total' => 32.3,
                'final_discount_amount' => 1.02,
                'final_coupon_discount_amount' => 0.68,
            ],
            [
                'id' => 112,
                'customer_id' => 3,
                'service_id' => 94,
                'provider_id' => 4,
                'date' => '2023-10-12 11:02:00',
                'start_at' => '2023-09-30 11:06:17',
                'end_at' => '2023-09-30 11:06:22',
                'quantity' => 1,
                'amount' => 34.0,
                'discount' => 0.0,
                'total_amount' => 39.7,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Ashland City Center',
                'payment_id' => 81,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 05:33:14',
                'updated_at' => '2023-09-30 05:36:46',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 112,
                    'created_at' => '2023-09-30 11:03:15',
                    'id' => 95,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-09-30 11:03:15',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 34.0,
                'final_total_tax' => 5.7,
                'final_sub_total' => 34.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 113,
                'customer_id' => 3,
                'service_id' => 87,
                'provider_id' => 4,
                'date' => '2023-10-09 11:13:00',
                'start_at' => '2023-09-30 11:17:15',
                'end_at' => '2023-09-30 11:17:20',
                'quantity' => 1,
                'amount' => 27.0,
                'discount' => 3.0,
                'total_amount' => 30.93,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Fortune ? housing',
                'payment_id' => 82,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 05:44:06',
                'updated_at' => '2023-09-30 05:47:49',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 113,
                    'created_at' => '2023-09-30 11:14:07',
                    'id' => 96,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-09-30 11:14:07',
                ],
                'booking_address_id' => 5,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 27.0,
                'final_total_tax' => 5.28,
                'final_sub_total' => 25.65,
                'final_discount_amount' => 0.81,
                'final_coupon_discount_amount' => 0.54,
            ],
            [
                'id' => 114,
                'customer_id' => 3,
                'service_id' => 44,
                'provider_id' => 4,
                'date' => '2023-10-03 12:19:00',
                'start_at' => '2023-09-30 11:22:21',
                'end_at' => '2023-09-30 11:22:26',
                'quantity' => 1,
                'amount' => 50.0,
                'discount' => 4.0,
                'total_amount' => 79.08,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'completed',
                'address' => 'Taylor street',
                'payment_id' => 84,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 05:50:30',
                'updated_at' => '2023-09-30 05:53:07',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 114,
                    'created_at' => '2023-09-30 11:20:31',
                    'id' => 97,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-30 11:20:31',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 2.6415,
                'final_total_service_price' => 50.0,
                'final_total_tax' => 7.58,
                'final_sub_total' => 46.5,
                'final_discount_amount' => 2.0,
                'final_coupon_discount_amount' => 1.5,
            ],
            [
                'id' => 115,
                'customer_id' => 3,
                'service_id' => 63,
                'provider_id' => 4,
                'date' => '2023-09-30 00:00:00',
                'start_at' => '2023-09-30 11:31:08',
                'end_at' => '2023-09-30 11:31:14',
                'quantity' => 1,
                'amount' => 20.0,
                'discount' => 0.0,
                'total_amount' => 17.65,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => 'Western view ? building',
                'payment_id' => 85,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 05:59:04',
                'updated_at' => '2023-09-30 06:01:51',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 115,
                    'created_at' => '2023-09-30 11:29:06',
                    'id' => 98,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-09-30 11:29:06',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => '16:00:00',
                'booking_day' => 'sat',
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 20.0,
                'final_total_tax' => 4.65,
                'final_sub_total' => 13.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 116,
                'customer_id' => 3,
                'service_id' => 51,
                'provider_id' => 4,
                'date' => '2023-10-08 20:35:00',
                'start_at' => '2023-09-30 11:37:05',
                'end_at' => '2023-09-30 11:37:10',
                'quantity' => 1,
                'amount' => 45.0,
                'discount' => 3.0,
                'total_amount' => 48.42,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'completed',
                'address' => 'Melbourne, Australia ?',
                'payment_id' => 86,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 06:05:27',
                'updated_at' => '2023-09-30 06:08:07',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 116,
                    'created_at' => '2023-09-30 11:35:28',
                    'id' => 99,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                'updated_at' => '2023-09-30 11:35:28',
                ],
                'booking_address_id' => 5,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 45.0,
                'final_total_tax' => 6.12,
                'final_sub_total' => 42.3,
                'final_discount_amount' => 1.35,
                'final_coupon_discount_amount' => 1.35,
            ],
            [
                'id' => 117,
                'customer_id' => 3,
                'service_id' => 81,
                'provider_id' => 4,
                'date' => '2023-10-06 17:33:00',
                'start_at' => '2023-09-30 11:44:12',
                'end_at' => '2023-09-30 11:44:17',
                'quantity' => 1,
                'amount' => 38.0,
                'discount' => 4.0,
                'total_amount' => 41.51,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => '2, Della House',
                'payment_id' => 87,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 06:12:38',
                'updated_at' => '2023-09-30 06:14:38',
                'booking_address' =>[
                    'address' => 'Morgan City, LA, USA',
                    'booking_id' => 117,
                    'created_at' => '2023-09-30 11:42:39',
                    'id' => 100,
                    'latitude' => '29.706043',
                    'longitude' => '-91.206917',
                    'updated_at' => '2023-09-30 11:42:39',
                ],
                'booking_address_id' => 8,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 38.0,
                'final_total_tax' => 5.79,
                'final_sub_total' => 35.72,
                'final_discount_amount' => 1.52,
                'final_coupon_discount_amount' => 0.76,
            ],
            [
                'id' => 118,
                'customer_id' => 3,
                'service_id' => 76,
                'provider_id' => 4,
                'date' => '2023-10-12 11:48:00',
                'start_at' => '2023-09-30 11:54:54',
                'end_at' => '2023-09-30 11:55:04',
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => 5.0,
                'total_amount' => 31.56,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => '23, Freedom housing',
                'payment_id' => 88,
                'duration_diff' => '10',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 06:18:27',
                'updated_at' => '2023-09-30 06:25:32',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 118,
                    'created_at' => '2023-09-30 11:48:28',
                    'id' => 101,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-09-30 11:48:28',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 5.31,
                'final_sub_total' => 26.25,
                'final_discount_amount' => 1.75,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 119,
                'customer_id' => 3,
                'service_id' => 47,
                'provider_id' => 17,
                'date' => '2023-09-30 11:57:00',
                'start_at' => '2023-09-30 12:05:59',
                'end_at' => '2023-09-30 12:06:08',
                'quantity' => 1,
                'amount' => 19.0,
                'discount' => 0.0,
                'total_amount' => 23.95,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Eastern roads',
                'payment_id' => 89,
                'duration_diff' => '9',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 06:27:47',
                'updated_at' => '2023-09-30 06:37:15',
                'booking_address' =>[
                    'address' => 'Edinburgh, Scotland, UK',
                    'booking_id' => 119,
                    'created_at' => '2023-09-30 11:57:48',
                    'id' => 102,
                    'latitude' => '55.953251',
                    'longitude' => '-3.188267',
                    'updated_at' => '2023-09-30 11:57:48',
                ],
                'booking_address_id' => 29,
                'tax' => '[{"id":99,"provider_id":17,"title":"Service Tax","type":"percent","value":5},{"id":100,"provider_id":17,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 19.0,
                'final_total_tax' => 4.95,
                'final_sub_total' => 19.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 120,
                'customer_id' => 3,
                'service_id' => 85,
                'provider_id' => 16,
                'date' => '2023-10-07 12:07:00',
                'start_at' => '2023-09-30 12:09:51',
                'end_at' => '2023-09-30 12:09:56',
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 0.0,
                'total_amount' => 29.0,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Fortune housing building, Australia ?',
                'payment_id' => 90,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 06:38:21',
                'updated_at' => '2023-09-30 06:40:21',
                'booking_address' =>[
                    'address' => 'Newcastle, Australia',
                    'booking_id' => 120,
                    'created_at' => '2023-09-30 12:08:22',
                    'id' => 103,
                    'latitude' => '-32.9167',
                    'longitude' => '151.7500',
                    'updated_at' => '2023-09-30 12:08:22',
                ],
                'booking_address_id' => 27,
                'tax' => '[{"id":71,"provider_id":16,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 25.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 121,
                'customer_id' => 3,
                'service_id' => 27,
                'provider_id' => 4,
                'date' => '2023-10-04 12:16:00',
                'start_at' => '2023-09-30 12:24:55',
                'end_at' => '2023-09-30 12:25:12',
                'quantity' => 1,
                'amount' => 10.0,
                'discount' => NULL,
                'total_amount' => 14.29,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 2,
                'status' => 'completed',
                'address' => 'Rooftop appartment, SK, Canada',
                'payment_id' => 91,
                'duration_diff' => '17',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 06:46:37',
                'updated_at' => '2023-09-30 06:55:52',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 121,
                    'created_at' => '2023-09-30 12:16:39',
                    'id' => 104,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-30 12:16:39',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 10.0,
                'final_total_tax' => 4.49,
                'final_sub_total' => 9.8,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.2,
            ],
            [
                'id' => 122,
                'customer_id' => 3,
                'service_id' => 22,
                'provider_id' => 4,
                'date' => '2023-10-02 12:27:00',
                'start_at' => '2023-09-30 12:30:31',
                'end_at' => '2023-09-30 12:32:30',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 2.0,
                'total_amount' => 19.12,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 2,
                'status' => 'completed',
                'address' => '24, Street, USA',
                'payment_id' => 92,
                'duration_diff' => '119',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 06:57:54',
                'updated_at' => '2023-09-30 07:03:21',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 122,
                    'created_at' => '2023-09-30 12:27:56',
                    'id' => 105,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-09-30 12:27:56',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.72,
                'final_sub_total' => 14.4,
                'final_discount_amount' => 0.3,
                'final_coupon_discount_amount' => 0.3,
            ],
            [
                'id' => 123,
                'customer_id' => 3,
                'service_id' => 16,
                'provider_id' => 8,
                'date' => '2023-09-30 13:40:00',
                'start_at' => '2023-09-30 12:42:18',
                'end_at' => '2023-09-30 12:42:23',
                'quantity' => 1,
                'amount' => 20.0,
                'discount' => 1.0,
                'total_amount' => 19.54,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 1,
                'status' => 'completed',
                'address' => 'Destiny appartment',
                'payment_id' => 93,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 07:10:38',
                'updated_at' => '2023-09-30 07:12:47',
                'booking_address' =>[
                    'address' => 'Cambridge, MD, USA',
                    'booking_id' => 123,
                    'created_at' => '2023-09-30 12:40:39',
                    'id' => 106,
                    'latitude' => '38.563461',
                    'longitude' => '-76.085251',
                    'updated_at' => '2023-09-30 12:40:39',
                ],
                'booking_address_id' => 14,
                'tax' => '[{"id":82,"provider_id":8,"title":"Service Tax","type":"percent","value":5},{"id":83,"provider_id":8,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 20.0,
                'final_total_tax' => 4.74,
                'final_sub_total' => 14.8,
                'final_discount_amount' => 0.2,
                'final_coupon_discount_amount' => 5.0,
            ],
            [
                'id' => 124,
                'customer_id' => 3,
                'service_id' => 32,
                'provider_id' => 4,
                'date' => '2023-10-09 12:44:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 45.0,
                'discount' => 10.0,
                'total_amount' => 64.38,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'completed',
                'address' => '3, Sadie Street, UK',
                'payment_id' => 95,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 07:15:22',
                'updated_at' => '2023-09-30 07:21:17',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 124,
                    'created_at' => '2023-09-30 12:45:23',
                    'id' => 107,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-30 12:45:23',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 4.232,
                'final_total_service_price' => 45.0,
                'final_total_tax' => 6.88,
                'final_sub_total' => 36.5,
                'final_discount_amount' => 4.5,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 126,
                'customer_id' => 3,
                'service_id' => 93,
                'provider_id' => 4,
                'date' => '2023-09-30 12:58:00',
                'start_at' => '2023-09-30 13:01:49',
                'end_at' => '2023-09-30 13:01:55',
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => 3.0,
                'total_amount' => 39.65,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Atlanta Complex, Canada',
                'payment_id' => 98,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 07:29:09',
                'updated_at' => '2023-09-30 07:32:29',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 126,
                    'created_at' => '2023-09-30 12:59:10',
                    'id' => 109,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-30 12:59:10',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 3.965,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 5.7,
                'final_sub_total' => 33.95,
                'final_discount_amount' => 1.05,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 127,
                'customer_id' => 3,
                'service_id' => 37,
                'provider_id' => 4,
                'date' => '2023-10-05 13:07:00',
                'start_at' => '2023-09-30 13:13:47',
                'end_at' => '2023-09-30 13:14:03',
                'quantity' => 1,
                'amount' => 40.0,
                'discount' => 0.0,
                'total_amount' => 41.8,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'completed',
                'address' => 'Southampton',
                'payment_id' => 99,
                'duration_diff' => '16',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 07:38:17',
                'updated_at' => '2023-09-30 07:45:30',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 127,
                    'created_at' => '2023-09-30 13:08:19',
                    'id' => 110,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-09-30 13:08:19',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 40.0,
                'final_total_tax' => 5.8,
                'final_sub_total' => 36.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 128,
                'customer_id' => 3,
                'service_id' => 31,
                'provider_id' => 4,
                'date' => '2023-10-06 15:24:00',
                'start_at' => '2023-09-30 15:51:38',
                'end_at' => '2023-09-30 15:51:42',
                'quantity' => 1,
                'amount' => 12.0,
                'discount' => 1.0,
                'total_amount' => 12.27,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'completed',
                'address' => 'Triple building ??',
                'payment_id' => 100,
                'duration_diff' => '4',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 09:54:41',
                'updated_at' => '2023-09-30 10:22:09',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 128,
                    'created_at' => '2023-09-30 15:24:42',
                    'id' => 111,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-09-30 15:24:42',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 12.0,
                'final_total_tax' => 4.39,
                'final_sub_total' => 7.88,
                'final_discount_amount' => 0.12,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 129,
                'customer_id' => 3,
                'service_id' => 15,
                'provider_id' => 4,
                'date' => '2023-10-07 17:01:00',
                'start_at' => '2023-09-30 16:02:38',
                'end_at' => '2023-09-30 16:02:43',
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 2.0,
                'total_amount' => 29.73,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Freedom valley',
                'payment_id' => 101,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 10:31:26',
                'updated_at' => '2023-09-30 10:33:08',
                'booking_address' =>[
                    'address' => 'Yorkton, SK, Canada',
                    'booking_id' => 129,
                    'created_at' => '2023-09-30 16:01:27',
                    'id' => 112,
                    'latitude' => '51.213890',
                    'longitude' => '102.462776',
                    'updated_at' => '2023-09-30 16:01:27',
                ],
                'booking_address_id' => 7,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 5.23,
                'final_sub_total' => 24.5,
                'final_discount_amount' => 0.5,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 130,
                'customer_id' => 3,
                'service_id' => 21,
                'provider_id' => 14,
                'date' => '2023-10-08 18:04:00',
                'start_at' => '2023-09-30 16:06:21',
                'end_at' => '2023-09-30 16:06:29',
                'quantity' => 1,
                'amount' => 0.0,
                'discount' => 0.0,
                'total_amount' => 4.0,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => '23, Main Street Australia ?',
                'payment_id' => NULL,
                'duration_diff' => '8',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 10:34:27',
                'updated_at' => '2023-09-30 10:36:46',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 130,
                    'created_at' => '2023-09-30 16:04:28',
                    'id' => 113,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-09-30 16:04:28',
                ],
                'booking_address_id' => 23,
                'tax' => '[{"id":101,"provider_id":14,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 0.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 0.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 131,
                'customer_id' => 3,
                'service_id' => 26,
                'provider_id' => 4,
                'date' => '2023-10-10 17:00:00',
                'start_at' => '2023-09-30 16:09:59',
                'end_at' => '2023-09-30 16:10:03',
                'quantity' => 1,
                'amount' => 41.0,
                'discount' => NULL,
                'total_amount' => 46.19,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 2,
                'status' => 'completed',
                'address' => 'Retro road ?️',
                'payment_id' => 102,
                'duration_diff' => '4',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 10:37:59',
                'updated_at' => '2023-09-30 10:40:44',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 131,
                    'created_at' => '2023-09-30 16:08:00',
                    'id' => 114,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-09-30 16:08:00',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 41.0,
                'final_total_tax' => 6.01,
                'final_sub_total' => 40.18,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.82,
            ],
            [
                'id' => 133,
                'customer_id' => 3,
                'service_id' => 30,
                'provider_id' => 14,
                'date' => '2023-10-02 19:05:00',
                'start_at' => '2023-09-30 19:07:29',
                'end_at' => '2023-09-30 19:18:46',
                'quantity' => 1,
                'amount' => 30.0,
                'discount' => NULL,
                'total_amount' => 33.4,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 2,
                'status' => 'completed',
                'address' => 'Top roof',
                'payment_id' => 104,
                'duration_diff' => '677',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 13:35:45',
                'updated_at' => '2023-09-30 13:50:08',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 133,
                    'created_at' => '2023-09-30 19:05:46',
                    'id' => 116,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-09-30 19:05:46',
                ],
                'booking_address_id' => 23,
                'tax' => '[{"id":101,"provider_id":14,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 30.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 29.4,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.6,
            ],
            [
                'id' => 134,
                'customer_id' => 3,
                'service_id' => 74,
                'provider_id' => 7,
                'date' => '2023-10-03 19:09:00',
                'start_at' => '2023-09-30 19:11:37',
                'end_at' => '2023-09-30 19:11:43',
                'quantity' => 1,
                'amount' => 45.0,
                'discount' => NULL,
                'total_amount' => 39.9,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => 'Top roof',
                'payment_id' => 103,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 13:40:09',
                'updated_at' => '2023-09-30 13:43:15',
                'booking_address' =>[
                    'address' => 'Belfast, UK',
                    'booking_id' => 134,
                    'created_at' => '2023-09-30 19:10:10',
                    'id' => 117,
                    'latitude' => '54.607868',
                    'longitude' => '-5.926437',
                    'updated_at' => '2023-09-30 19:10:10',
                ],
                'booking_address_id' => 13,
                'tax' => '[{"id":93,"provider_id":7,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 45.0,
                'final_total_tax' => 1.9,
                'final_sub_total' => 38.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 135,
                'customer_id' => 3,
                'service_id' => 79,
                'provider_id' => 17,
                'date' => '2023-10-04 19:21:00',
                'start_at' => '2023-09-30 19:23:50',
                'end_at' => '2023-09-30 19:23:55',
                'quantity' => 1,
                'amount' => 12.0,
                'discount' => 0.0,
                'total_amount' => 16.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Tree ? view, Scotland',
                'payment_id' => 105,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 13:52:25',
                'updated_at' => '2023-09-30 13:54:25',
                'booking_address' =>[
                    'address' => 'Edinburgh, Scotland, UK',
                    'booking_id' => 135,
                    'created_at' => '2023-09-30 19:22:26',
                    'id' => 118,
                    'latitude' => '55.953251',
                    'longitude' => '-3.188267',
                    'updated_at' => '2023-09-30 19:22:26',
                ],
                'booking_address_id' => 29,
                'tax' => '[{"id":99,"provider_id":17,"title":"Service Tax","type":"percent","value":5},{"id":100,"provider_id":17,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 12.0,
                'final_total_tax' => 4.6,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 136,
                'customer_id' => 3,
                'service_id' => 42,
                'provider_id' => 4,
                'date' => '2023-10-05 19:24:00',
                'start_at' => '2023-10-02 10:59:32',
                'end_at' => '2023-10-02 10:59:37',
                'quantity' => 1,
                'amount' => 30.0,
                'discount' => 0.0,
                'total_amount' => 35.5,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Depending building',
                'payment_id' => 106,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-09-30 13:55:11',
                'updated_at' => '2023-10-02 05:30:03',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 136,
                    'created_at' => '2023-09-30 19:25:12',
                    'id' => 119,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-09-30 19:25:12',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 30.0,
                'final_total_tax' => 5.5,
                'final_sub_total' => 30.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 137,
                'customer_id' => 3,
                'service_id' => 43,
                'provider_id' => 4,
                'date' => '2023-10-02 11:02:00',
                'start_at' => '2023-10-02 11:05:09',
                'end_at' => '2023-10-02 11:05:19',
                'quantity' => 1,
                'amount' => 40.0,
                'discount' => 4.0,
                'total_amount' => 40.12,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'completed',
                'address' => 'Canada',
                'payment_id' => 107,
                'duration_diff' => '10',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 05:33:02',
                'updated_at' => '2023-10-02 05:35:51',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 137,
                    'created_at' => '2023-10-02 11:03:03',
                    'id' => 120,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-02 11:03:03',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 40.0,
                'final_total_tax' => 5.72,
                'final_sub_total' => 34.4,
                'final_discount_amount' => 1.6,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 138,
                'customer_id' => 3,
                'service_id' => 66,
                'provider_id' => 16,
                'date' => '2023-10-02 11:13:00',
                'start_at' => '2023-10-02 11:18:08',
                'end_at' => '2023-10-02 11:18:13',
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 0.0,
                'total_amount' => 29.0,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Fresh housing, Australia ?',
                'payment_id' => 108,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 05:44:20',
                'updated_at' => '2023-10-02 05:48:43',
                'booking_address' =>[
                    'address' => 'Newcastle, Australia',
                    'booking_id' => 138,
                    'created_at' => '2023-10-02 11:14:21',
                    'id' => 121,
                    'latitude' => '-32.9167',
                    'longitude' => '151.7500',
                    'updated_at' => '2023-10-02 11:14:21',
                ],
                'booking_address_id' => 27,
                'tax' => '[{"id":71,"provider_id":16,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 25.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 139,
                'customer_id' => 3,
                'service_id' => 88,
                'provider_id' => 4,
                'date' => '2023-10-02 11:23:00',
                'start_at' => '2023-10-02 11:26:38',
                'end_at' => '2023-10-02 11:26:43',
                'quantity' => 1,
                'amount' => 30.0,
                'discount' => 5.0,
                'total_amount' => 33.3,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Retro street, KY, USA',
                'payment_id' => 109,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 05:54:04',
                'updated_at' => '2023-10-02 05:57:10',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 139,
                    'created_at' => '2023-10-02 11:24:05',
                    'id' => 122,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-10-02 11:24:05',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 30.0,
                'final_total_tax' => 5.4,
                'final_sub_total' => 27.9,
                'final_discount_amount' => 1.5,
                'final_coupon_discount_amount' => 0.6,
            ],
            [
                'id' => 140,
                'customer_id' => 3,
                'service_id' => 72,
                'provider_id' => 4,
                'date' => '2023-10-02 11:30:00',
                'start_at' => '2023-10-02 11:32:58',
                'end_at' => '2023-10-02 11:33:03',
                'quantity' => 1,
                'amount' => 50.0,
                'discount' => 10.0,
                'total_amount' => 51.25,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Southampton',
                'payment_id' => 110,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 06:00:21',
                'updated_at' => '2023-10-02 06:03:29',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 140,
                    'created_at' => '2023-10-02 11:30:22',
                    'id' => 123,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-10-02 11:30:22',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 50.0,
                'final_total_tax' => 6.25,
                'final_sub_total' => 45.0,
                'final_discount_amount' => 5.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 141,
                'customer_id' => 3,
                'service_id' => 52,
                'provider_id' => 8,
                'date' => '2023-10-03 11:36:00',
                'start_at' => '2023-10-02 11:38:26',
                'end_at' => '2023-10-02 11:38:31',
                'quantity' => 1,
                'amount' => 40.0,
                'discount' => 10.0,
                'total_amount' => 40.54,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'completed',
                'address' => 'Free fire ? building',
                'payment_id' => 111,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 06:07:11',
                'updated_at' => '2023-10-02 06:09:17',
                'booking_address' =>[
                    'address' => 'Cambridge, MD, USA',
                    'booking_id' => 141,
                    'created_at' => '2023-10-02 11:37:12',
                    'id' => 124,
                    'latitude' => '38.563461',
                    'longitude' => '-76.085251',
                    'updated_at' => '2023-10-02 11:37:12',
                ],
                'booking_address_id' => 14,
                'tax' => '[{"id":82,"provider_id":8,"title":"Service Tax","type":"percent","value":5},{"id":83,"provider_id":8,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 40.0,
                'final_total_tax' => 5.74,
                'final_sub_total' => 34.8,
                'final_discount_amount' => 4.0,
                'final_coupon_discount_amount' => 1.2,
            ],
            [
                'id' => 142,
                'customer_id' => 3,
                'service_id' => 69,
                'provider_id' => 12,
                'date' => '2023-10-02 11:42:00',
                'start_at' => '2023-10-02 11:44:06',
                'end_at' => '2023-10-02 11:44:11',
                'quantity' => 1,
                'amount' => 16.0,
                'discount' => 0.0,
                'total_amount' => 13.45,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => 'Envelope ? house ?',
                'payment_id' => 112,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 06:12:51',
                'updated_at' => '2023-10-02 06:14:32',
                'booking_address' =>[
                    'address' => 'Sandy Beach, Canada',
                    'booking_id' => 142,
                    'created_at' => '2023-10-02 11:42:52',
                    'id' => 125,
                    'latitude' => '-30.1483',
                    'longitude' => '153.2011',
                    'updated_at' => '2023-10-02 11:42:52',
                ],
                'booking_address_id' => 20,
                'tax' => '[{"id":65,"provider_id":12,"title":"Service Tax","type":"percent","value":5},{"id":66,"provider_id":12,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 16.0,
                'final_total_tax' => 4.45,
                'final_sub_total' => 9.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 143,
                'customer_id' => 3,
                'service_id' => 57,
                'provider_id' => 4,
                'date' => '2023-10-03 11:46:00',
                'start_at' => '2023-10-02 11:49:32',
                'end_at' => '2023-10-02 11:49:39',
                'quantity' => 1,
                'amount' => 40.0,
                'discount' => 2.0,
                'total_amount' => 43.9,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'completed',
                'address' => 'Adventure ✨ house line',
                'payment_id' => 113,
                'duration_diff' => '7',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 06:16:55',
                'updated_at' => '2023-10-02 06:22:00',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 143,
                    'created_at' => '2023-10-02 11:46:56',
                    'id' => 126,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-02 11:46:56',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 40.0,
                'final_total_tax' => 5.9,
                'final_sub_total' => 38.0,
                'final_discount_amount' => 0.8,
                'final_coupon_discount_amount' => 1.2,
            ],
            [
                'id' => 144,
                'customer_id' => 3,
                'service_id' => 41,
                'provider_id' => 12,
                'date' => '2023-10-03 12:37:00',
                'start_at' => '2023-10-02 12:39:26',
                'end_at' => '2023-10-02 12:39:31',
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => NULL,
                'total_amount' => 40.75,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Sendy appartment',
                'payment_id' => 114,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 07:07:54',
                'updated_at' => '2023-10-02 07:11:05',
                'booking_address' =>[
                    'address' => 'Sandy Beach, Canada',
                    'booking_id' => 144,
                    'created_at' => '2023-10-02 12:37:55',
                    'id' => 127,
                    'latitude' => '-30.1483',
                    'longitude' => '153.2011',
                    'updated_at' => '2023-10-02 12:37:55',
                ],
                'booking_address_id' => 20,
                'tax' => '[{"id":65,"provider_id":12,"title":"Service Tax","type":"percent","value":5},{"id":66,"provider_id":12,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 5.75,
                'final_sub_total' => 35.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 145,
                'customer_id' => 3,
                'service_id' => 58,
                'provider_id' => 4,
                'date' => '2023-10-04 12:42:00',
                'start_at' => '2023-10-02 12:58:43',
                'end_at' => '2023-10-02 12:58:48',
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 0.0,
                'total_amount' => 29.46,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'completed',
                'address' => 'Western view apartment',
                'payment_id' => 115,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 07:12:56',
                'updated_at' => '2023-10-02 07:29:20',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 145,
                    'created_at' => '2023-10-02 12:42:57',
                    'id' => 128,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-02 12:42:57',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 5.21,
                'final_sub_total' => 24.25,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.75,
            ],
            [
                'id' => 146,
                'customer_id' => 3,
                'service_id' => 67,
                'provider_id' => 13,
                'date' => '2023-10-05 13:01:00',
                'start_at' => '2023-10-02 13:04:34',
                'end_at' => '2023-10-02 13:04:39',
                'quantity' => 1,
                'amount' => 27.0,
                'discount' => 4.0,
                'total_amount' => 23.87,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => 'Rooftop Canada',
                'payment_id' => 116,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 07:31:22',
                'updated_at' => '2023-10-02 07:35:09',
                'booking_address' =>[
                    'address' => 'Warman, SK, Canada',
                    'booking_id' => 146,
                    'created_at' => '2023-10-02 13:01:23',
                    'id' => 129,
                    'latitude' => '52.321945',
                    'longitude' => '-106.584167',
                    'updated_at' => '2023-10-02 13:01:23',
                ],
                'booking_address_id' => 22,
                'tax' => '[{"id":84,"provider_id":13,"title":"Service Tax","type":"percent","value":5},{"id":85,"provider_id":13,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 27.0,
                'final_total_tax' => 4.95,
                'final_sub_total' => 18.92,
                'final_discount_amount' => 1.08,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 147,
                'customer_id' => 3,
                'service_id' => 78,
                'provider_id' => 4,
                'date' => '2023-10-02 13:10:00',
                'start_at' => '2023-10-02 13:13:02',
                'end_at' => '2023-10-02 13:13:07',
                'quantity' => 1,
                'amount' => 37.0,
                'discount' => 2.0,
                'total_amount' => 42.07,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Morgantown',
                'payment_id' => 117,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 07:40:10',
                'updated_at' => '2023-10-02 07:44:25',
                'booking_address' =>[
                    'address' => 'Morgan City, LA, USA',
                    'booking_id' => 147,
                    'created_at' => '2023-10-02 13:10:11',
                    'id' => 130,
                    'latitude' => '29.706043',
                    'longitude' => '-91.206917',
                    'updated_at' => '2023-10-02 13:10:11',
                ],
                'booking_address_id' => 8,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 37.0,
                'final_total_tax' => 5.81,
                'final_sub_total' => 36.26,
                'final_discount_amount' => 0.74,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 148,
                'customer_id' => 3,
                'service_id' => 60,
                'provider_id' => 4,
                'date' => '2023-10-02 15:01:00',
                'start_at' => '2023-10-02 15:03:43',
                'end_at' => '2023-10-02 15:04:09',
                'quantity' => 1,
                'amount' => 36.0,
                'discount' => 0.0,
                'total_amount' => 40.67,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'completed',
                'address' => 'Sutherland Road?️',
                'payment_id' => 118,
                'duration_diff' => '26',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 09:32:03',
                'updated_at' => '2023-10-02 09:34:39',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 148,
                    'created_at' => '2023-10-02 15:02:04',
                    'id' => 131,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-10-02 15:02:04',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 36.0,
                'final_total_tax' => 5.75,
                'final_sub_total' => 34.92,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 1.08,
            ],
            [
                'id' => 149,
                'customer_id' => 3,
                'service_id' => 77,
                'provider_id' => 13,
                'date' => '2023-10-04 15:09:00',
                'start_at' => '2023-10-02 15:11:22',
                'end_at' => '2023-10-02 15:11:28',
                'quantity' => 1,
                'amount' => 32.0,
                'discount' => 1.0,
                'total_amount' => 37.26,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Maple Avenue',
                'payment_id' => 119,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 09:40:04',
                'updated_at' => '2023-10-02 09:44:04',
                'booking_address' =>[
                    'address' => 'Warman, SK, Canada',
                    'booking_id' => 149,
                    'created_at' => '2023-10-02 15:10:05',
                    'id' => 132,
                    'latitude' => '52.321945',
                    'longitude' => '-106.584167',
                    'updated_at' => '2023-10-02 15:10:05',
                ],
                'booking_address_id' => 22,
                'tax' => '[{"id":84,"provider_id":13,"title":"Service Tax","type":"percent","value":5},{"id":85,"provider_id":13,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 32.0,
                'final_total_tax' => 5.58,
                'final_sub_total' => 31.68,
                'final_discount_amount' => 0.32,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 150,
                'customer_id' => 3,
                'service_id' => 48,
                'provider_id' => 4,
                'date' => '2023-10-02 15:19:00',
                'start_at' => '2023-10-02 15:22:44',
                'end_at' => '2023-10-02 15:22:49',
                'quantity' => 1,
                'amount' => 18.0,
                'discount' => 0.0,
                'total_amount' => 22.33,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'completed',
                'address' => 'Ashland',
                'payment_id' => 120,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 09:49:20',
                'updated_at' => '2023-10-02 09:53:18',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 150,
                    'created_at' => '2023-10-02 15:19:21',
                    'id' => 133,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-10-02 15:19:21',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 18.0,
                'final_total_tax' => 4.87,
                'final_sub_total' => 17.46,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.54,
            ],
            [
                'id' => 151,
                'customer_id' => 3,
                'service_id' => 29,
                'provider_id' => 4,
                'date' => '2023-10-04 15:25:00',
                'start_at' => '2023-10-02 15:28:37',
                'end_at' => '2023-10-02 15:28:52',
                'quantity' => 1,
                'amount' => 28.0,
                'discount' => NULL,
                'total_amount' => 32.81,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 2,
                'status' => 'completed',
                'address' => 'Melbourne Australia ?',
                'payment_id' => 121,
                'duration_diff' => '15',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 09:55:27',
                'updated_at' => '2023-10-02 10:00:23',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 151,
                    'created_at' => '2023-10-02 15:25:29',
                    'id' => 134,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-10-02 15:25:29',
                ],
                'booking_address_id' => 5,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 28.0,
                'final_total_tax' => 5.37,
                'final_sub_total' => 27.44,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.56,
            ],
            [
                'id' => 152,
                'customer_id' => 3,
                'service_id' => 25,
                'provider_id' => 4,
                'date' => '2023-10-02 15:34:00',
                'start_at' => '2023-10-02 15:36:37',
                'end_at' => '2023-10-02 15:36:42',
                'quantity' => 1,
                'amount' => 16.0,
                'discount' => NULL,
                'total_amount' => 20.8,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Torrent appartment, B wing',
                'payment_id' => 122,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 10:04:56',
                'updated_at' => '2023-10-02 10:07:23',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 152,
                    'created_at' => '2023-10-02 15:34:57',
                    'id' => 135,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-10-02 15:34:57',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 16.0,
                'final_total_tax' => 4.8,
                'final_sub_total' => 16.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 153,
                'customer_id' => 3,
                'service_id' => 20,
                'provider_id' => 4,
                'date' => '2023-10-05 15:46:00',
                'start_at' => '2023-10-02 15:47:53',
                'end_at' => '2023-10-02 15:47:58',
                'quantity' => 1,
                'amount' => 40.0,
                'discount' => NULL,
                'total_amount' => 46.0,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Red fort',
                'payment_id' => 123,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 10:16:14',
                'updated_at' => '2023-10-02 10:18:50',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 153,
                    'created_at' => '2023-10-02 15:46:16',
                    'id' => 136,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-02 15:46:16',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 40.0,
                'final_total_tax' => 6.0,
                'final_sub_total' => 40.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 154,
                'customer_id' => 3,
                'service_id' => 14,
                'provider_id' => 15,
                'date' => '2023-10-05 16:53:00',
                'start_at' => '2023-10-02 15:57:32',
                'end_at' => '2023-10-02 15:58:55',
                'quantity' => 1,
                'amount' => 23.0,
                'discount' => 2.0,
                'total_amount' => 23.67,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Lake view',
                'payment_id' => 125,
                'duration_diff' => '83',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 10:23:37',
                'updated_at' => '2023-10-02 10:29:32',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 154,
                    'created_at' => '2023-10-02 15:53:38',
                    'id' => 137,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-10-02 15:53:38',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":81,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 2.367,
                'final_total_service_price' => 23.0,
                'final_total_tax' => 1.13,
                'final_sub_total' => 22.54,
                'final_discount_amount' => 0.46,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 155,
                'customer_id' => 3,
                'service_id' => 36,
                'provider_id' => 4,
                'date' => '2023-10-02 16:02:00',
                'start_at' => '2023-10-02 16:07:40',
                'end_at' => '2023-10-02 16:07:45',
                'quantity' => 1,
                'amount' => 53.0,
                'discount' => 5.0,
                'total_amount' => 52.67,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'completed',
                'address' => 'Bamford',
                'payment_id' => 127,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 10:33:09',
                'updated_at' => '2023-10-02 10:46:52',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 155,
                    'created_at' => '2023-10-02 16:03:10',
                    'id' => 138,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-02 16:03:10',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 2.1068,
                'final_total_service_price' => 53.0,
                'final_total_tax' => 6.32,
                'final_sub_total' => 46.35,
                'final_discount_amount' => 2.65,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 156,
                'customer_id' => 3,
                'service_id' => 12,
                'provider_id' => 16,
                'date' => '2023-10-07 17:02:00',
                'start_at' => '2023-10-02 17:06:24',
                'end_at' => '2023-10-02 17:08:58',
                'quantity' => 1,
                'amount' => 30.0,
                'discount' => 2.0,
                'total_amount' => 28.4,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 1,
                'status' => 'completed',
                'address' => 'Tourism building',
                'payment_id' => 128,
                'duration_diff' => '154',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 11:33:01',
                'updated_at' => '2023-10-02 11:39:23',
                'booking_address' =>[
                    'address' => 'Newcastle, Australia',
                    'booking_id' => 156,
                    'created_at' => '2023-10-02 17:03:02',
                    'id' => 139,
                    'latitude' => '-32.9167',
                    'longitude' => '151.7500',
                    'updated_at' => '2023-10-02 17:03:02',
                ],
                'booking_address_id' => 27,
                'tax' => '[{"id":71,"provider_id":16,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 30.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 24.4,
                'final_discount_amount' => 0.6,
                'final_coupon_discount_amount' => 5.0,
            ],
            [
                'id' => 157,
                'customer_id' => 3,
                'service_id' => 13,
                'provider_id' => 16,
                'date' => '2023-10-06 17:10:00',
                'start_at' => '2023-10-02 17:13:44',
                'end_at' => '2023-10-02 17:14:00',
                'quantity' => 1,
                'amount' => 12.0,
                'discount' => 1.0,
                'total_amount' => 10.88,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 1,
                'status' => 'completed',
                'address' => 'Melbourne',
                'payment_id' => 129,
                'duration_diff' => '16',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 11:41:15',
                'updated_at' => '2023-10-02 11:45:51',
                'booking_address' =>[
                    'address' => 'Newcastle, Australia',
                    'booking_id' => 157,
                    'created_at' => '2023-10-02 17:11:16',
                    'id' => 140,
                    'latitude' => '-32.9167',
                    'longitude' => '151.7500',
                    'updated_at' => '2023-10-02 17:11:16',
                ],
                'booking_address_id' => 27,
                'tax' => '[{"id":71,"provider_id":16,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 12.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 6.88,
                'final_discount_amount' => 0.12,
                'final_coupon_discount_amount' => 5.0,
            ],
            [
                'id' => 158,
                'customer_id' => 3,
                'service_id' => 19,
                'provider_id' => 12,
                'date' => '2023-10-03 00:00:00',
                'start_at' => '2023-10-02 17:22:56',
                'end_at' => '2023-10-02 17:23:00',
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 4.0,
                'total_amount' => 29.66,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 2,
                'status' => 'completed',
                'address' => 'Onterio Canada',
                'payment_id' => 130,
                'duration_diff' => '4',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 11:51:54',
                'updated_at' => '2023-10-02 11:54:37',
                'booking_address' =>[
                    'address' => 'Ontario, Barrie, Canada',
                    'booking_id' => 158,
                    'created_at' => '2023-10-02 17:21:55',
                    'id' => 141,
                    'latitude' => '44.389355',
                    'longitude' => '-79.690331',
                    'updated_at' => '2023-10-02 17:21:55',
                ],
                'booking_address_id' => 21,
                'tax' => '[{"id":65,"provider_id":12,"title":"Service Tax","type":"percent","value":5},{"id":66,"provider_id":12,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => '10:00:00',
                'booking_day' => 'tue',
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 5.22,
                'final_sub_total' => 24.44,
                'final_discount_amount' => 1.04,
                'final_coupon_discount_amount' => 0.52,
            ],
            [
                'id' => 159,
                'customer_id' => 3,
                'service_id' => 24,
                'provider_id' => 7,
                'date' => '2023-10-02 17:26:00',
                'start_at' => '2023-10-02 17:29:32',
                'end_at' => '2023-10-02 17:29:37',
                'quantity' => 1,
                'amount' => 32.0,
                'discount' => NULL,
                'total_amount' => 33.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Rental house',
                'payment_id' => 131,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 11:56:23',
                'updated_at' => '2023-10-02 12:03:03',
                'booking_address' =>[
                    'address' => 'Belfast, UK',
                    'booking_id' => 159,
                    'created_at' => '2023-10-02 17:26:24',
                    'id' => 142,
                    'latitude' => '54.607868',
                    'longitude' => '-5.926437',
                    'updated_at' => '2023-10-02 17:26:24',
                ],
                'booking_address_id' => 13,
                'tax' => '[{"id":93,"provider_id":7,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 32.0,
                'final_total_tax' => 1.6,
                'final_sub_total' => 32.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 160,
                'customer_id' => 3,
                'service_id' => 28,
                'provider_id' => 4,
                'date' => '2023-10-10 17:35:00',
                'start_at' => '2023-10-02 17:40:26',
                'end_at' => '2023-10-02 17:40:32',
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => NULL,
                'total_amount' => 30.75,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 2,
                'status' => 'completed',
                'address' => 'Rest building',
                'payment_id' => 132,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 12:06:09',
                'updated_at' => '2023-10-02 12:11:24',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 160,
                    'created_at' => '2023-10-02 17:36:10',
                    'id' => 143,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-02 17:36:10',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 5.27,
                'final_sub_total' => 25.48,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.52,
            ],
            [
                'id' => 161,
                'customer_id' => 3,
                'service_id' => 61,
                'provider_id' => 4,
                'date' => '2023-10-03 17:43:00',
                'start_at' => '2023-10-02 17:45:08',
                'end_at' => '2023-10-02 17:45:18',
                'quantity' => 1,
                'amount' => 37.0,
                'discount' => 0.0,
                'total_amount' => 35.5,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => 'Trivenyu emporium',
                'payment_id' => 133,
                'duration_diff' => '10',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 12:13:52',
                'updated_at' => '2023-10-02 12:15:44',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 161,
                    'created_at' => '2023-10-02 17:43:53',
                    'id' => 144,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-02 17:43:53',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 37.0,
                'final_total_tax' => 5.5,
                'final_sub_total' => 30.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 162,
                'customer_id' => 3,
                'service_id' => 75,
                'provider_id' => 12,
                'date' => '2023-10-05 17:50:00',
                'start_at' => '2023-10-02 17:52:44',
                'end_at' => '2023-10-02 17:52:49',
                'quantity' => 1,
                'amount' => 23.0,
                'discount' => 4.0,
                'total_amount' => 19.83,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => 'Sandy beach resort',
                'payment_id' => 134,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 12:20:53',
                'updated_at' => '2023-10-02 12:23:44',
                'booking_address' =>[
                    'address' => 'Sandy Beach, Canada',
                    'booking_id' => 162,
                    'created_at' => '2023-10-02 17:50:54',
                    'id' => 145,
                    'latitude' => '-30.1483',
                    'longitude' => '153.2011',
                    'updated_at' => '2023-10-02 17:50:54',
                ],
                'booking_address_id' => 20,
                'tax' => '[{"id":65,"provider_id":12,"title":"Service Tax","type":"percent","value":5},{"id":66,"provider_id":12,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 23.0,
                'final_total_tax' => 4.75,
                'final_sub_total' => 15.08,
                'final_discount_amount' => 0.92,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 164,
                'customer_id' => 3,
                'service_id' => 53,
                'provider_id' => 4,
                'date' => '2023-10-06 18:02:00',
                'start_at' => '2023-10-02 18:04:00',
                'end_at' => '2023-10-02 18:04:05',
                'quantity' => 1,
                'amount' => 0.0,
                'discount' => 0.0,
                'total_amount' => 4.0,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Rooftop appartment',
                'payment_id' => NULL,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 12:32:46',
                'updated_at' => '2023-10-02 12:34:15',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 164,
                    'created_at' => '2023-10-02 18:02:47',
                    'id' => 147,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-02 18:02:47',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 0.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 0.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 165,
                'customer_id' => 3,
                'service_id' => 64,
                'provider_id' => 4,
                'date' => '2023-10-07 18:05:00',
                'start_at' => '2023-10-02 18:08:30',
                'end_at' => '2023-10-02 18:08:38',
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 4.0,
                'total_amount' => 21.85,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'completed',
                'address' => 'Southampton',
                'payment_id' => 135,
                'duration_diff' => '8',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 12:35:57',
                'updated_at' => '2023-10-02 12:39:08',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 165,
                    'created_at' => '2023-10-02 18:05:58',
                    'id' => 148,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-10-02 18:05:58',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 4.85,
                'final_sub_total' => 17.0,
                'final_discount_amount' => 1.0,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 166,
                'customer_id' => 3,
                'service_id' => 54,
                'provider_id' => 4,
                'date' => '2023-10-05 18:11:00',
                'start_at' => '2023-10-02 18:14:19',
                'end_at' => '2023-10-02 18:14:23',
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => 5.0,
                'total_amount' => 37.81,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'completed',
                'address' => 'Melbourne',
                'payment_id' => 136,
                'duration_diff' => '4',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 12:42:08',
                'updated_at' => '2023-10-02 12:44:45',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 166,
                    'created_at' => '2023-10-02 18:12:09',
                    'id' => 149,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-10-02 18:12:09',
                ],
                'booking_address_id' => 5,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 5.61,
                'final_sub_total' => 32.2,
                'final_discount_amount' => 1.75,
                'final_coupon_discount_amount' => 1.05,
            ],
            [
                'id' => 167,
                'customer_id' => 3,
                'service_id' => 56,
                'provider_id' => 4,
                'date' => '2023-10-02 18:16:00',
                'start_at' => '2023-10-02 18:18:07',
                'end_at' => '2023-10-02 18:18:11',
                'quantity' => 1,
                'amount' => 50.0,
                'discount' => 4.0,
                'total_amount' => 63.33,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'completed',
                'address' => 'Trident appartment',
                'payment_id' => 137,
                'duration_diff' => '4',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 12:47:09',
                'updated_at' => '2023-10-02 12:48:45',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 167,
                    'created_at' => '2023-10-02 18:17:10',
                    'id' => 150,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-02 18:17:10',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 50.0,
                'final_total_tax' => 6.83,
                'final_sub_total' => 46.5,
                'final_discount_amount' => 2.0,
                'final_coupon_discount_amount' => 1.5,
            ],
            [
                'id' => 168,
                'customer_id' => 3,
                'service_id' => 39,
                'provider_id' => 4,
                'date' => '2023-10-04 18:20:00',
                'start_at' => '2023-10-02 18:27:36',
                'end_at' => '2023-10-02 18:27:56',
                'quantity' => 1,
                'amount' => 42.0,
                'discount' => 4.0,
                'total_amount' => 42.14,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'completed',
                'address' => 'Ashland USA',
                'payment_id' => 138,
                'duration_diff' => '20',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 12:51:08',
                'updated_at' => '2023-10-02 12:58:42',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 168,
                    'created_at' => '2023-10-02 18:21:09',
                    'id' => 151,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-10-02 18:21:09',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 42.0,
                'final_total_tax' => 5.82,
                'final_sub_total' => 36.32,
                'final_discount_amount' => 1.68,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 169,
                'customer_id' => 3,
                'service_id' => 40,
                'provider_id' => 15,
                'date' => '2023-10-02 18:33:00',
                'start_at' => '2023-10-02 18:35:00',
                'end_at' => '2023-10-02 18:35:05',
                'quantity' => 1,
                'amount' => 12.0,
                'discount' => 0.0,
                'total_amount' => 34.65,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'completed',
                'address' => 'USA',
                'payment_id' => 139,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 13:03:29',
                'updated_at' => '2023-10-02 13:05:36',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 169,
                    'created_at' => '2023-10-02 18:33:30',
                    'id' => 152,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-10-02 18:33:30',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":81,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 12.0,
                'final_total_tax' => 1.65,
                'final_sub_total' => 8.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 170,
                'customer_id' => 3,
                'service_id' => 45,
                'provider_id' => 4,
                'date' => '2023-10-02 18:38:00',
                'start_at' => '2023-10-02 18:41:12',
                'end_at' => '2023-10-02 18:41:16',
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 0.0,
                'total_amount' => 30.25,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Onterio Canada',
                'payment_id' => 140,
                'duration_diff' => '4',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 13:08:42',
                'updated_at' => '2023-10-02 13:11:59',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 170,
                    'created_at' => '2023-10-02 18:38:43',
                    'id' => 153,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-02 18:38:43',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 5.25,
                'final_sub_total' => 25.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 171,
                'customer_id' => 3,
                'service_id' => 50,
                'provider_id' => 12,
                'date' => '2023-10-09 18:44:00',
                'start_at' => '2023-10-02 18:46:59',
                'end_at' => '2023-10-02 18:47:05',
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 0.0,
                'total_amount' => 55.71,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'completed',
                'address' => 'Sandy beach ?️ apartment',
                'payment_id' => 141,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 13:15:06',
                'updated_at' => '2023-10-02 13:17:48',
                'booking_address' =>[
                    'address' => 'Sandy Beach, Canada',
                    'booking_id' => 171,
                    'created_at' => '2023-10-02 18:45:07',
                    'id' => 154,
                    'latitude' => '-30.1483',
                    'longitude' => '153.2011',
                    'updated_at' => '2023-10-02 18:45:07',
                ],
                'booking_address_id' => 20,
                'tax' => '[{"id":65,"provider_id":12,"title":"Service Tax","type":"percent","value":5},{"id":66,"provider_id":12,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 6.46,
                'final_sub_total' => 24.25,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.75,
            ],
            [
                'id' => 172,
                'customer_id' => 3,
                'service_id' => 23,
                'provider_id' => 4,
                'date' => '2023-10-07 18:53:00',
                'start_at' => '2023-10-02 18:55:16',
                'end_at' => '2023-10-02 18:55:21',
                'quantity' => 1,
                'amount' => 23.0,
                'discount' => NULL,
                'total_amount' => 27.67,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 2,
                'status' => 'completed',
                'address' => 'Melville',
                'payment_id' => 143,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 13:23:59',
                'updated_at' => '2023-10-02 13:26:57',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 172,
                    'created_at' => '2023-10-02 18:54:00',
                    'id' => 155,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-02 18:54:00',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 1.3835,
                'final_total_service_price' => 23.0,
                'final_total_tax' => 5.13,
                'final_sub_total' => 22.54,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.46,
            ],
            [
                'id' => 173,
                'customer_id' => 3,
                'service_id' => 18,
                'provider_id' => 4,
                'date' => '2023-10-03 18:59:00',
                'start_at' => '2023-10-02 19:01:30',
                'end_at' => '2023-10-02 19:01:35',
                'quantity' => 1,
                'amount' => 33.0,
                'discount' => 5.0,
                'total_amount' => 63.17,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 1,
                'status' => 'completed',
                'address' => '23, Real street',
                'payment_id' => 144,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-02 13:30:33',
                'updated_at' => '2023-10-02 13:32:17',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 173,
                    'created_at' => '2023-10-02 19:00:35',
                    'id' => 156,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-10-02 19:00:35',
                ],
                'booking_address_id' => 5,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 33.0,
                'final_total_tax' => 6.82,
                'final_sub_total' => 26.35,
                'final_discount_amount' => 1.65,
                'final_coupon_discount_amount' => 5.0,
            ],
            [
                'id' => 174,
                'customer_id' => 40,
                'service_id' => 104,
                'provider_id' => 4,
                'date' => '2023-10-03 17:22:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 45.0,
                'discount' => 0.0,
                'total_amount' => 48.1,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'pending',
                'address' => 'Caption appartment, Canada',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-03 11:52:42',
                'updated_at' => '2023-10-03 11:52:42',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 174,
                    'created_at' => '2023-10-03 17:22:43',
                    'id' => 157,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-03 17:22:43',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 45.0,
                'final_total_tax' => 6.1,
                'final_sub_total' => 42.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 175,
                'customer_id' => 38,
                'service_id' => 109,
                'provider_id' => 4,
                'date' => '2023-10-07 00:00:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 43.0,
                'discount' => 0.0,
                'total_amount' => 46.0,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'pending',
                'address' => 'Rooftop building',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-03 11:54:48',
                'updated_at' => '2023-10-03 11:54:48',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 175,
                    'created_at' => '2023-10-03 17:24:49',
                    'id' => 158,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-10-03 17:24:49',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => '08:00:00',
                'booking_day' => 'sat',
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 43.0,
                'final_total_tax' => 6.0,
                'final_sub_total' => 40.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 176,
                'customer_id' => 41,
                'service_id' => 108,
                'provider_id' => 15,
                'date' => '2023-10-11 17:25:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 18.0,
                'discount' => 2.0,
                'total_amount' => 15.37,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'pending',
                'address' => 'Eastern Sea ⛵ view',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-03 11:55:57',
                'updated_at' => '2023-10-03 11:55:57',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 176,
                    'created_at' => '2023-10-03 17:25:58',
                    'id' => 159,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-10-03 17:25:58',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":81,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 18.0,
                'final_total_tax' => 0.73,
                'final_sub_total' => 14.64,
                'final_discount_amount' => 0.36,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 177,
                'customer_id' => 42,
                'service_id' => 106,
                'provider_id' => 15,
                'date' => '2023-10-05 17:26:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 2.0,
                'total_amount' => 23.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'pending',
                'address' => 'Tree ? plant housing',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-03 11:56:50',
                'updated_at' => '2023-10-03 11:56:50',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 177,
                    'created_at' => '2023-10-03 17:26:51',
                    'id' => 160,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-10-03 17:26:51',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":81,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 1.12,
                'final_sub_total' => 22.48,
                'final_discount_amount' => 0.52,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 178,
                'customer_id' => 50,
                'service_id' => 104,
                'provider_id' => 4,
                'date' => '2023-10-04 17:44:00',
                'start_at' => '2023-10-03 17:45:39',
                'end_at' => '2023-10-03 17:45:45',
                'quantity' => 1,
                'amount' => 45.0,
                'discount' => 0.0,
                'total_amount' => 51.25,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Town',
                'payment_id' => 145,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-10-03 12:14:09',
                'updated_at' => '2023-10-03 12:16:33',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 178,
                    'created_at' => '2023-10-03 17:44:11',
                    'id' => 161,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-03 17:44:11',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 45.0,
                'final_total_tax' => 6.25,
                'final_sub_total' => 45.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 179,
                'customer_id' => 50,
                'service_id' => 110,
                'provider_id' => 4,
                'date' => '2023-10-03 17:51:00',
                'start_at' => '2023-10-03 17:53:43',
                'end_at' => '2023-10-03 17:53:48',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 16.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Canada',
                'payment_id' => 146,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-03 12:21:59',
                'updated_at' => '2023-10-03 12:24:44',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 179,
                    'created_at' => '2023-10-03 17:52:00',
                    'id' => 162,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-03 17:52:00',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.6,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 180,
                'customer_id' => 49,
                'service_id' => 100,
                'provider_id' => 4,
                'date' => '2023-10-03 18:59:00',
                'start_at' => '2023-10-03 18:02:40',
                'end_at' => '2023-10-03 18:02:45',
                'quantity' => 1,
                'amount' => 37.0,
                'discount' => 0.0,
                'total_amount' => 42.85,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Tree house',
                'payment_id' => 147,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-03 12:29:51',
                'updated_at' => '2023-10-03 12:35:12',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 180,
                    'created_at' => '2023-10-03 17:59:52',
                    'id' => 163,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-03 17:59:52',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 37.0,
                'final_total_tax' => 5.85,
                'final_sub_total' => 37.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 181,
                'customer_id' => 48,
                'service_id' => 110,
                'provider_id' => 4,
                'date' => '2023-10-03 18:07:00',
                'start_at' => '2023-10-03 18:09:59',
                'end_at' => '2023-10-03 18:10:09',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 16.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Rooftop appartment, SK, Canada',
                'payment_id' => 148,
                'duration_diff' => '10',
                'deleted_at' => NULL,
                'created_at' => '2023-10-03 12:38:00',
                'updated_at' => '2023-10-03 12:40:33',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 181,
                    'created_at' => '2023-10-03 18:08:01',
                    'id' => 164,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-03 18:08:01',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.6,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 182,
                'customer_id' => 48,
                'service_id' => 107,
                'provider_id' => 4,
                'date' => '2023-10-04 18:34:00',
                'start_at' => '2023-10-03 18:36:25',
                'end_at' => '2023-10-03 18:36:32',
                'quantity' => 1,
                'amount' => 32.0,
                'discount' => 0.0,
                'total_amount' => 44.95,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Brisbane, Australia',
                'payment_id' => 150,
                'duration_diff' => '7',
                'deleted_at' => NULL,
                'created_at' => '2023-10-03 13:04:20',
                'updated_at' => '2023-10-03 13:07:26',
                'booking_address' =>[
                    'address' => 'Brisbane, Australia',
                    'booking_id' => 182,
                    'created_at' => '2023-10-03 18:34:21',
                    'id' => 165,
                    'latitude' => '-27.4678',
                    'longitude' => '153.0281',
                    'updated_at' => '2023-10-03 18:34:21',
                ],
                'booking_address_id' => 6,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 0.689,
                'final_total_service_price' => 32.0,
                'final_total_tax' => 5.95,
                'final_sub_total' => 29.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 183,
                'customer_id' => 47,
                'service_id' => 104,
                'provider_id' => 4,
                'date' => '2023-10-05 18:39:00',
                'start_at' => '2023-10-03 18:41:01',
                'end_at' => '2023-10-03 18:41:06',
                'quantity' => 1,
                'amount' => 45.0,
                'discount' => 0.0,
                'total_amount' => 48.1,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Morgantown housing',
                'payment_id' => 151,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-03 13:09:38',
                'updated_at' => '2023-10-03 13:11:34',
                'booking_address' =>[
                    'address' => 'Morgan City, LA, USA',
                    'booking_id' => 183,
                    'created_at' => '2023-10-03 18:39:39',
                    'id' => 166,
                    'latitude' => '29.706043',
                    'longitude' => '-91.206917',
                    'updated_at' => '2023-10-03 18:39:39',
                ],
                'booking_address_id' => 8,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 45.0,
                'final_total_tax' => 6.1,
                'final_sub_total' => 42.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 184,
                'customer_id' => 46,
                'service_id' => 107,
                'provider_id' => 4,
                'date' => '2023-10-03 18:43:00',
                'start_at' => '2023-10-03 18:45:34',
                'end_at' => '2023-10-03 18:45:40',
                'quantity' => 1,
                'amount' => 32.0,
                'discount' => 0.0,
                'total_amount' => 34.45,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Canada',
                'payment_id' => 153,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-10-03 13:13:46',
                'updated_at' => '2023-10-03 13:16:28',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 184,
                    'created_at' => '2023-10-03 18:43:47',
                    'id' => 167,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-03 18:43:47',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 0.689,
                'final_total_service_price' => 32.0,
                'final_total_tax' => 5.45,
                'final_sub_total' => 29.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 185,
                'customer_id' => 45,
                'service_id' => 110,
                'provider_id' => 4,
                'date' => '2023-10-05 18:55:00',
                'start_at' => '2023-10-03 19:01:14',
                'end_at' => '2023-10-03 19:01:27',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 16.6,
                'description' => NULL,
                'reason' => 'Done',
                'coupon_id' => 7,
                'status' => 'pending_approval',
                'address' => 'Western view ?',
                'payment_id' => NULL,
                'duration_diff' => '13',
                'deleted_at' => NULL,
                'created_at' => '2023-10-03 13:26:01',
                'updated_at' => '2023-10-03 13:31:29',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 185,
                    'created_at' => '2023-10-03 18:56:04',
                    'id' => 168,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-03 18:56:04',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.6,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 186,
                'customer_id' => 41,
                'service_id' => 110,
                'provider_id' => 4,
                'date' => '2023-10-07 11:29:00',
                'start_at' => '2023-10-05 11:31:05',
                'end_at' => '2023-10-05 11:31:09',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 16.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Ontario Canada',
                'payment_id' => 154,
                'duration_diff' => '4',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 05:59:50',
                'updated_at' => '2023-10-05 06:01:38',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 186,
                    'created_at' => '2023-10-05 11:29:51',
                    'id' => 169,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-05 11:29:51',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.6,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 187,
                'customer_id' => 40,
                'service_id' => 100,
                'provider_id' => 4,
                'date' => '2023-10-05 11:34:00',
                'start_at' => '2023-10-05 11:38:36',
                'end_at' => '2023-10-05 11:38:41',
                'quantity' => 1,
                'amount' => 37.0,
                'discount' => 0.0,
                'total_amount' => 39.7,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Torrent appartment',
                'payment_id' => 155,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 06:05:11',
                'updated_at' => '2023-10-05 06:09:07',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 187,
                    'created_at' => '2023-10-05 11:35:12',
                    'id' => 170,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-05 11:35:12',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 37.0,
                'final_total_tax' => 5.7,
                'final_sub_total' => 34.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 188,
                'customer_id' => 39,
                'service_id' => 104,
                'provider_id' => 4,
                'date' => '2023-10-05 11:41:00',
                'start_at' => '2023-10-05 11:43:46',
                'end_at' => '2023-10-05 11:43:52',
                'quantity' => 1,
                'amount' => 45.0,
                'discount' => 0.0,
                'total_amount' => 48.1,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Freedom valley',
                'payment_id' => 156,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 06:11:46',
                'updated_at' => '2023-10-05 06:14:54',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 188,
                    'created_at' => '2023-10-05 11:41:47',
                    'id' => 171,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-05 11:41:47',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 45.0,
                'final_total_tax' => 6.1,
                'final_sub_total' => 42.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 189,
                'customer_id' => 39,
                'service_id' => 110,
                'provider_id' => 4,
                'date' => '2023-10-09 11:46:00',
                'start_at' => '2023-10-05 11:48:11',
                'end_at' => '2023-10-05 11:48:16',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 16.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Fortune housing building',
                'payment_id' => 157,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 06:16:37',
                'updated_at' => '2023-10-05 06:19:17',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 189,
                    'created_at' => '2023-10-05 11:46:38',
                    'id' => 172,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-05 11:46:38',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.6,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 190,
                'customer_id' => 38,
                'service_id' => 110,
                'provider_id' => 4,
                'date' => '2023-10-06 11:54:00',
                'start_at' => '2023-10-05 12:06:19',
                'end_at' => '2023-10-05 12:06:25',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 16.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Melbourne Australia',
                'payment_id' => 159,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 06:24:39',
                'updated_at' => '2023-10-05 06:36:59',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 190,
                    'created_at' => '2023-10-05 11:54:41',
                    'id' => 173,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-10-05 11:54:41',
                ],
                'booking_address_id' => 5,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.6,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 191,
                'customer_id' => 38,
                'service_id' => 104,
                'provider_id' => 4,
                'date' => '2023-10-06 11:56:00',
                'start_at' => '2023-10-05 12:05:14',
                'end_at' => '2023-10-05 12:05:21',
                'quantity' => 1,
                'amount' => 45.0,
                'discount' => 0.0,
                'total_amount' => 51.25,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Roof design',
                'payment_id' => 158,
                'duration_diff' => '7',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 06:27:12',
                'updated_at' => '2023-10-05 06:35:50',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 191,
                    'created_at' => '2023-10-05 11:57:13',
                    'id' => 174,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-05 11:57:13',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 45.0,
                'final_total_tax' => 6.25,
                'final_sub_total' => 45.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 192,
                'customer_id' => 39,
                'service_id' => 83,
                'provider_id' => 4,
                'date' => '2023-10-05 12:13:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 42.0,
                'discount' => 2.0,
                'total_amount' => 47.22,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'accept',
                'address' => 'Fighter house',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 06:43:45',
                'updated_at' => '2023-10-05 07:22:45',
                'booking_address_id' => NULL,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 42.0,
                'final_total_tax' => 6.06,
                'final_sub_total' => 41.16,
                'final_discount_amount' => 0.84,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 193,
                'customer_id' => 37,
                'service_id' => 107,
                'provider_id' => 4,
                'date' => '2023-10-05 12:14:00',
                'start_at' => '2023-10-05 12:19:49',
                'end_at' => '2023-10-05 12:19:56',
                'quantity' => 1,
                'amount' => 32.0,
                'discount' => 0.0,
                'total_amount' => 34.45,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Relay Appartment',
                'payment_id' => 161,
                'duration_diff' => '7',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 06:44:50',
                'updated_at' => '2023-10-05 06:50:32',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 193,
                    'created_at' => '2023-10-05 12:14:51',
                    'id' => 175,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-05 12:14:51',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 0.689,
                'final_total_service_price' => 32.0,
                'final_total_tax' => 5.45,
                'final_sub_total' => 29.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 194,
                'customer_id' => 48,
                'service_id' => 97,
                'provider_id' => 4,
                'date' => '2023-10-05 12:37:00',
                'start_at' => '2023-10-05 12:39:29',
                'end_at' => '2023-10-05 12:39:33',
                'quantity' => 1,
                'amount' => 39.0,
                'discount' => 0.0,
                'total_amount' => 41.8,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Morgantown housing',
                'payment_id' => 162,
                'duration_diff' => '4',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 07:07:57',
                'updated_at' => '2023-10-05 07:10:21',
                'booking_address' =>[
                    'address' => 'Morgan City, LA, USA',
                    'booking_id' => 194,
                    'created_at' => '2023-10-05 12:37:58',
                    'id' => 176,
                    'latitude' => '29.706043',
                    'longitude' => '-91.206917',
                    'updated_at' => '2023-10-05 12:37:58',
                ],
                'booking_address_id' => 8,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 39.0,
                'final_total_tax' => 5.8,
                'final_sub_total' => 36.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 195,
                'customer_id' => 3,
                'service_id' => 26,
                'provider_id' => 4,
                'date' => '2023-10-05 12:47:00',
                'start_at' => '2023-10-05 12:48:14',
                'end_at' => '2023-10-05 12:48:19',
                'quantity' => 1,
                'amount' => 41.0,
                'discount' => NULL,
                'total_amount' => 46.19,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 2,
                'status' => 'completed',
                'address' => 'Melbourne Australia ??',
                'payment_id' => 163,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 07:17:15',
                'updated_at' => '2023-10-05 07:19:19',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 195,
                    'created_at' => '2023-10-05 12:47:16',
                    'id' => 177,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-10-05 12:47:16',
                ],
                'booking_address_id' => 5,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 41.0,
                'final_total_tax' => 6.01,
                'final_sub_total' => 40.18,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.82,
            ],
            [
                'id' => 196,
                'customer_id' => 50,
                'service_id' => 32,
                'provider_id' => 4,
                'date' => '2023-10-06 12:53:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 45.0,
                'discount' => 10.0,
                'total_amount' => 42.32,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'waiting',
                'address' => 'Ashland',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 07:23:59',
                'updated_at' => '2023-10-05 07:23:59',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 196,
                    'created_at' => '2023-10-05 12:54:00',
                    'id' => 178,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-10-05 12:54:00',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 45.0,
                'final_total_tax' => 5.82,
                'final_sub_total' => 36.5,
                'final_discount_amount' => 4.5,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 197,
                'customer_id' => 50,
                'service_id' => 81,
                'provider_id' => 4,
                'date' => '2023-10-05 17:56:00',
                'start_at' => '2023-10-05 12:58:01',
                'end_at' => '2023-10-05 12:58:06',
                'quantity' => 1,
                'amount' => 38.0,
                'discount' => 4.0,
                'total_amount' => 41.51,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Melbourne Australia ??',
                'payment_id' => 164,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 07:26:24',
                'updated_at' => '2023-10-05 07:29:23',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 197,
                    'created_at' => '2023-10-05 12:56:25',
                    'id' => 179,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-10-05 12:56:25',
                ],
                'booking_address_id' => 5,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 38.0,
                'final_total_tax' => 5.79,
                'final_sub_total' => 35.72,
                'final_discount_amount' => 1.52,
                'final_coupon_discount_amount' => 0.76,
            ],
            [
                'id' => 198,
                'customer_id' => 49,
                'service_id' => 16,
                'provider_id' => 8,
                'date' => '2023-10-05 14:02:00',
                'start_at' => '2023-10-05 14:02:00',
                'end_at' => '2023-10-05 13:03:34',
                'quantity' => 1,
                'amount' => 20.0,
                'discount' => 1.0,
                'total_amount' => 19.54,
                'description' => NULL,
                'reason' => 'I don\'t want this service now',
                'coupon_id' => 1,
                'status' => 'cancelled',
                'address' => 'Cambridge',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 07:32:51',
                'updated_at' => '2023-10-05 07:33:37',
                'booking_address' =>[
                    'address' => 'Cambridge, MD, USA',
                    'booking_id' => 198,
                    'created_at' => '2023-10-05 13:02:52',
                    'id' => 180,
                    'latitude' => '38.563461',
                    'longitude' => '-76.085251',
                    'updated_at' => '2023-10-05 13:02:52',
                ],
                'booking_address_id' => 14,
                'tax' => '[{"id":82,"provider_id":8,"title":"Service Tax","type":"percent","value":5},{"id":83,"provider_id":8,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 0.0,
                'final_total_service_price' => 20.0,
                'final_total_tax' => 4.74,
                'final_sub_total' => 14.8,
                'final_discount_amount' => 0.2,
                'final_coupon_discount_amount' => 5.0,
            ],
            [
                'id' => 199,
                'customer_id' => 49,
                'service_id' => 15,
                'provider_id' => 4,
                'date' => '2023-10-05 13:03:00',
                'start_at' => '2023-10-05 13:05:20',
                'end_at' => '2023-10-05 13:05:25',
                'quantity' => 1,
                'amount' => 25.0,
                'discount' => 2.0,
                'total_amount' => 24.47,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 1,
                'status' => 'completed',
                'address' => 'Hazard',
                'payment_id' => 165,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 07:34:11',
                'updated_at' => '2023-10-05 07:35:54',
                'booking_address' =>[
                    'address' => 'Hazard, KY, USA',
                    'booking_id' => 199,
                    'created_at' => '2023-10-05 13:04:12',
                    'id' => 181,
                    'latitude' => '37.250626',
                    'longitude' => '-83.195503',
                    'updated_at' => '2023-10-05 13:04:12',
                ],
                'booking_address_id' => 10,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 25.0,
                'final_total_tax' => 4.97,
                'final_sub_total' => 19.5,
                'final_discount_amount' => 0.5,
                'final_coupon_discount_amount' => 5.0,
            ],
            [
                'id' => 200,
                'customer_id' => 49,
                'service_id' => 35,
                'provider_id' => 4,
                'date' => '2023-10-06 13:08:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 38.0,
                'discount' => 4.0,
                'total_amount' => 38.1,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'accept',
                'address' => 'Melville Street',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 07:38:56',
                'updated_at' => '2023-10-05 07:40:08',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 200,
                    'created_at' => '2023-10-05 13:08:57',
                    'id' => 182,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-05 13:08:57',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 38.0,
                'final_total_tax' => 5.62,
                'final_sub_total' => 32.48,
                'final_discount_amount' => 1.52,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 201,
                'customer_id' => 47,
                'service_id' => 105,
                'provider_id' => 4,
                'date' => '2023-10-05 13:37:00',
                'start_at' => '2023-10-05 13:41:37',
                'end_at' => '2023-10-05 13:41:43',
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => 4.0,
                'total_amount' => 36.13,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Ashland KY USA',
                'payment_id' => 166,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 08:07:45',
                'updated_at' => '2023-10-05 08:12:09',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 201,
                    'created_at' => '2023-10-05 13:37:46',
                    'id' => 183,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-10-05 13:37:46',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 5.53,
                'final_sub_total' => 30.6,
                'final_discount_amount' => 1.4,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 202,
                'customer_id' => 43,
                'service_id' => 35,
                'provider_id' => 4,
                'date' => '2023-10-05 13:46:00',
                'start_at' => '2023-10-05 13:47:52',
                'end_at' => '2023-10-05 13:47:58',
                'quantity' => 1,
                'amount' => 38.0,
                'discount' => 4.0,
                'total_amount' => 38.1,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'completed',
                'address' => 'Belinda Appartment',
                'payment_id' => 167,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 08:16:44',
                'updated_at' => '2023-10-05 08:18:49',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 202,
                    'created_at' => '2023-10-05 13:46:45',
                    'id' => 184,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-05 13:46:45',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 38.0,
                'final_total_tax' => 5.62,
                'final_sub_total' => 32.48,
                'final_discount_amount' => 1.52,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 203,
                'customer_id' => 46,
                'service_id' => 80,
                'provider_id' => 4,
                'date' => '2023-10-06 14:01:00',
                'start_at' => '2023-10-05 14:49:06',
                'end_at' => '2023-10-05 14:49:11',
                'quantity' => 1,
                'amount' => 28.0,
                'discount' => 7.0,
                'total_amount' => 30.75,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Melville',
                'payment_id' => 168,
                'duration_diff' => '5',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 08:31:41',
                'updated_at' => '2023-10-05 09:20:38',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 203,
                    'created_at' => '2023-10-05 14:01:42',
                    'id' => 185,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-05 14:01:42',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 28.0,
                'final_total_tax' => 5.27,
                'final_sub_total' => 25.48,
                'final_discount_amount' => 1.96,
                'final_coupon_discount_amount' => 0.56,
            ],
            [
                'id' => 204,
                'customer_id' => 46,
                'service_id' => 32,
                'provider_id' => 4,
                'date' => '2023-10-05 15:26:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 45.0,
                'discount' => 10.0,
                'total_amount' => 46.52,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'waiting',
                'address' => 'Rooftop',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 09:56:09',
                'updated_at' => '2023-10-05 09:56:09',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 204,
                    'created_at' => '2023-10-05 15:26:10',
                    'id' => 186,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-10-05 15:26:10',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 45.0,
                'final_total_tax' => 6.02,
                'final_sub_total' => 40.5,
                'final_discount_amount' => 4.5,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 205,
                'customer_id' => 45,
                'service_id' => 23,
                'provider_id' => 4,
                'date' => '2023-10-13 15:31:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 23.0,
                'discount' => NULL,
                'total_amount' => 27.67,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 2,
                'status' => 'waiting',
                'address' => 'Melville',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 10:02:02',
                'updated_at' => '2023-10-05 10:02:02',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 205,
                    'created_at' => '2023-10-05 15:32:03',
                    'id' => 187,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-05 15:32:03',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 23.0,
                'final_total_tax' => 5.13,
                'final_sub_total' => 22.54,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.46,
            ],
            [
                'id' => 206,
                'customer_id' => 44,
                'service_id' => 106,
                'provider_id' => 15,
                'date' => '2023-10-07 15:32:00',
                'start_at' => '2023-10-07 15:32:00',
                'end_at' => '2023-10-05 15:33:51',
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 2.0,
                'total_amount' => 23.6,
                'description' => NULL,
                'reason' => 'I selected wrong service. I don\'t want this service.',
                'coupon_id' => 7,
                'status' => 'cancelled',
                'address' => 'New Bedford Street',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 10:03:03',
                'updated_at' => '2023-10-05 10:03:53',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 206,
                    'created_at' => '2023-10-05 15:33:04',
                    'id' => 188,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-10-05 15:33:04',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":81,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 0.0,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 1.12,
                'final_sub_total' => 22.48,
                'final_discount_amount' => 0.52,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 207,
                'customer_id' => 44,
                'service_id' => 94,
                'provider_id' => 4,
                'date' => '2023-10-06 15:35:00',
                'start_at' => '2023-10-05 15:36:40',
                'end_at' => '2023-10-05 15:36:46',
                'quantity' => 1,
                'amount' => 34.0,
                'discount' => 0.0,
                'total_amount' => 38.99,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Sunbury Australia',
                'payment_id' => 169,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 10:05:37',
                'updated_at' => '2023-10-05 10:07:14',
                'booking_address_id' => Null,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 34.0,
                'final_total_tax' => 5.67,
                'final_sub_total' => 33.32,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.68,
            ],
            [
                'id' => 208,
                'customer_id' => 45,
                'service_id' => 110,
                'provider_id' => 4,
                'date' => '2023-10-06 15:40:00',
                'start_at' => '2023-10-05 15:41:40',
                'end_at' => '2023-10-05 15:41:46',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 16.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Northern fort housing',
                'payment_id' => 170,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 10:10:36',
                'updated_at' => '2023-10-05 10:12:15',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 208,
                    'created_at' => '2023-10-05 15:40:37',
                    'id' => 190,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-05 15:40:37',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.6,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 209,
                'customer_id' => 42,
                'service_id' => 101,
                'provider_id' => 4,
                'date' => '2023-10-06 15:44:00',
                'start_at' => '2023-10-05 15:45:37',
                'end_at' => '2023-10-05 15:45:43',
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => 0.0,
                'total_amount' => 37.6,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'completed',
                'address' => 'Router housing building',
                'payment_id' => 171,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-10-05 10:14:24',
                'updated_at' => '2023-10-05 10:16:08',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 209,
                    'created_at' => '2023-10-05 15:44:25',
                    'id' => 191,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                'updated_at' => '2023-10-05 15:44:25',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 5.6,
                'final_sub_total' => 32.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 210,
                'customer_id' => 42,
                'service_id' => 94,
                'provider_id' => 4,
                'date' => '2023-10-06 11:45:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 34.0,
                'discount' => 0.0,
                'total_amount' => 56.5,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'accept',
                'address' => 'New business hub housing',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 06:16:01',
                'updated_at' => '2023-10-06 06:16:58',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 210,
                    'created_at' => '2023-10-06 11:46:03',
                    'id' => 192,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-06 11:46:03',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 50.0,
                'final_total_tax' => 6.5,
                'final_sub_total' => 50.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 211,
                'customer_id' => 3,
                'service_id' => 90,
                'provider_id' => 17,
                'date' => '2023-10-06 11:58:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 42.0,
                'discount' => 0.0,
                'total_amount' => 47.22,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'pending',
                'address' => 'Oklahoma',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 06:28:40',
                'updated_at' => '2023-10-06 06:28:40',
                'booking_address' =>[
                    'address' => 'Edinburgh, Scotland, UK',
                    'booking_id' => 211,
                    'created_at' => '2023-10-06 11:58:42',
                    'id' => 193,
                    'latitude' => '55.953251',
                    'longitude' => '-3.188267',
                    'updated_at' => '2023-10-06 11:58:42',
                ],
                'booking_address_id' => 29,
                'tax' => '[{"id":99,"provider_id":17,"title":"Service Tax","type":"percent","value":5},{"id":100,"provider_id":17,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 42.0,
                'final_total_tax' => 6.06,
                'final_sub_total' => 41.16,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.84,
            ],
            [
                'id' => 212,
                'customer_id' => 3,
                'service_id' => 59,
                'provider_id' => 4,
                'date' => '2023-10-06 14:53:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 42.0,
                'discount' => 0.0,
                'total_amount' => 46.78,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 4,
                'status' => 'waiting',
                'address' => 'KY, USA',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 09:24:09',
                'updated_at' => '2023-10-06 09:24:09',
                'booking_address' =>[
                    'address' => 'Ashland, KY, USA',
                    'booking_id' => 212,
                    'created_at' => '2023-10-06 14:54:10',
                    'id' => 194,
                    'latitude' => '38.460304',
                    'longitude' => '-82.649666',
                    'updated_at' => '2023-10-06 14:54:10',
                ],
                'booking_address_id' => 3,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 42.0,
                'final_total_tax' => 6.04,
                'final_sub_total' => 40.74,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 1.26,
            ],
            [
                'id' => 213,
                'customer_id' => 3,
                'service_id' => 65,
                'provider_id' => 14,
                'date' => '2023-10-06 14:55:00',
                'start_at' => '2023-10-06 14:58:59',
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 40.0,
                'discount' => 0.0,
                'total_amount' => 37.0,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 5,
                'status' => 'in_progress',
                'address' => 'Melbourne Australia ??',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 09:25:40',
                'updated_at' => '2023-10-06 09:29:02',
                'booking_address' =>[
                    'address' => 'Melbourne, Australia',
                    'booking_id' => 213,
                    'created_at' => '2023-10-06 14:55:41',
                    'id' => 195,
                    'latitude' => '-37.8142',
                    'longitude' => '144.9631',
                    'updated_at' => '2023-10-06 14:55:41',
                ],
                'booking_address_id' => 23,
                'tax' => '[{"id":101,"provider_id":14,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 40.0,
                'final_total_tax' => 4.0,
                'final_sub_total' => 33.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 7.0,
            ],
            [
                'id' => 214,
                'customer_id' => 3,
                'service_id' => 80,
                'provider_id' => 4,
                'date' => '2023-10-06 15:59:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 28.0,
                'discount' => 7.0,
                'total_amount' => 30.75,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'rejected',
                'address' => 'Trio building',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 09:29:49',
                'updated_at' => '2023-10-06 09:30:27',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 214,
                    'created_at' => '2023-10-06 14:59:50',
                    'id' => 196,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-06 14:59:50',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 28.0,
                'final_total_tax' => 5.27,
                'final_sub_total' => 25.48,
                'final_discount_amount' => 1.96,
                'final_coupon_discount_amount' => 0.56,
            ],
            [
                'id' => 215,
                'customer_id' => 3,
                'service_id' => 46,
                'provider_id' => 13,
                'date' => '2023-10-19 15:01:00',
                'start_at' => '2023-10-19 15:01:00',
                'end_at' => '2023-10-06 15:02:27',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 19.28,
                'description' => NULL,
                'reason' => 'Sorry for inconvenience. I booked wrong service unfortunately. So, sorry.',
                'coupon_id' => 4,
                'status' => 'cancelled',
                'address' => 'Orieo appartment',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 09:31:56',
                'updated_at' => '2023-10-06 09:32:30',
                'booking_address' =>[
                    'address' => 'Warman, SK, Canada',
                    'booking_id' => 215,
                    'created_at' => '2023-10-06 15:01:58',
                    'id' => 197,
                    'latitude' => '52.321945',
                    'longitude' => '-106.584167',
                    'updated_at' => '2023-10-06 15:01:58',
                ],
                'booking_address_id' => 22,
                'tax' => '[{"id":84,"provider_id":13,"title":"Service Tax","type":"percent","value":5},{"id":85,"provider_id":13,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => 0.0,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.73,
                'final_sub_total' => 14.55,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.45,
            ],
            [
                'id' => 216,
                'customer_id' => 3,
                'service_id' => 78,
                'provider_id' => 4,
                'date' => '2023-10-06 15:03:00',
                'start_at' => '2023-10-06 15:05:00',
                'end_at' => '2023-10-06 15:05:34',
                'quantity' => 1,
                'amount' => 37.0,
                'discount' => 2.0,
                'total_amount' => 41.3,
                'description' => NULL,
                'reason' => 'Due to power cut UV light gel polish machine not working.',
                'coupon_id' => 6,
                'status' => 'hold',
                'address' => 'Northern fort',
                'payment_id' => NULL,
                'duration_diff' => '34',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 09:33:39',
                'updated_at' => '2023-10-06 09:35:36',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 216,
                    'created_at' => '2023-10-06 15:03:40',
                    'id' => 198,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-06 15:03:40',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 37.0,
                'final_total_tax' => 5.78,
                'final_sub_total' => 35.52,
                'final_discount_amount' => 0.74,
                'final_coupon_discount_amount' => 0.74,
            ],
            [
                'id' => 217,
                'customer_id' => 3,
                'service_id' => 108,
                'provider_id' => 15,
                'date' => '2023-10-07 15:06:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 18.0,
                'discount' => 2.0,
                'total_amount' => 15.37,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'accept',
                'address' => 'New house line',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 09:36:34',
                'updated_at' => '2023-10-06 09:37:34',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 217,
                    'created_at' => '2023-10-06 15:06:35',
                    'id' => 199,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-10-06 15:06:35',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":81,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 18.0,
                'final_total_tax' => 0.73,
                'final_sub_total' => 14.64,
                'final_discount_amount' => 0.36,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 218,
                'customer_id' => 3,
                'service_id' => 96,
                'provider_id' => 4,
                'date' => '2023-10-06 15:08:00',
                'start_at' => '2023-10-06 15:11:27',
                'end_at' => '2023-10-06 15:11:35',
                'quantity' => 1,
                'amount' => 26.0,
                'discount' => 0.0,
                'total_amount' => 30.75,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 6,
                'status' => 'completed',
                'address' => 'Melville',
                'payment_id' => NULL,
                'duration_diff' => '8',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 09:38:59',
                'updated_at' => '2023-10-06 09:41:50',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 218,
                    'created_at' => '2023-10-06 15:09:00',
                    'id' => 200,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-06 15:09:00',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 26.0,
                'final_total_tax' => 5.27,
                'final_sub_total' => 25.48,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.52,
            ],
            [
                'id' => 219,
                'customer_id' => 3,
                'service_id' => 99,
                'provider_id' => 4,
                'date' => '2023-10-06 15:12:00',
                'start_at' => '2023-10-06 15:13:54',
                'end_at' => '2023-10-06 15:14:01',
                'quantity' => 1,
                'amount' => 15.0,
                'discount' => 0.0,
                'total_amount' => 16.6,
                'description' => NULL,
                'reason' => 'Done',
                'coupon_id' => 7,
                'status' => 'pending_approval',
                'address' => 'Melville',
                'payment_id' => NULL,
                'duration_diff' => '7',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 09:42:44',
                'updated_at' => '2023-10-06 09:44:04',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 219,
                    'created_at' => '2023-10-06 15:12:45',
                    'id' => 201,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-06 15:12:45',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 15.0,
                'final_total_tax' => 4.6,
                'final_sub_total' => 12.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 220,
                'customer_id' => 3,
                'service_id' => 109,
                'provider_id' => 4,
                'date' => '2023-10-06 00:00:00',
                'start_at' => '2023-10-06 15:17:01',
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 43.0,
                'discount' => 0.0,
                'total_amount' => 49.15,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'in_progress',
                'address' => 'Kerlie house ?',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 09:45:32',
                'updated_at' => '2023-10-06 09:47:03',
                'booking_address' =>[
                    'address' => 'Southampton, UK',
                    'booking_id' => 220,
                    'created_at' => '2023-10-06 15:15:33',
                    'id' => 202,
                    'latitude' => '50.909698',
                    'longitude' => '-1.404351',
                    'updated_at' => '2023-10-06 15:15:33',
                ],
                'booking_address_id' => 31,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => '17:00:00',
                'booking_day' => 'fri',
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 43.0,
                'final_total_tax' => 6.15,
                'final_sub_total' => 43.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 221,
                'customer_id' => 3,
                'service_id' => 80,
                'provider_id' => 4,
                'date' => '2023-10-08 15:25:00',
                'start_at' => '2023-10-06 15:28:09',
                'end_at' => '2023-10-06 15:28:15',
                'quantity' => 1,
                'amount' => 28.0,
                'discount' => 7.0,
                'total_amount' => 43.9,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => NULL,
                'status' => 'completed',
                'address' => 'Candy ? beach resort ⛵',
                'payment_id' => 172,
                'duration_diff' => '6',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 09:55:40',
                'updated_at' => '2023-10-06 09:59:15',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 221,
                    'created_at' => '2023-10-06 15:25:41',
                    'id' => 203,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-06 15:25:41',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 28.0,
                'final_total_tax' => 5.9,
                'final_sub_total' => 28.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 0.0,
            ],
            [
                'id' => 222,
                'customer_id' => 3,
                'service_id' => 108,
                'provider_id' => 15,
                'date' => '2023-10-06 15:29:00',
                'start_at' => '2023-10-06 15:31:31',
                'end_at' => '2023-10-06 15:31:44',
                'quantity' => 1,
                'amount' => 18.0,
                'discount' => 2.0,
                'total_amount' => 15.37,
                'description' => NULL,
                'reason' => 'Done',
                'coupon_id' => 7,
                'status' => 'pending_approval',
                'address' => 'Rio building',
                'payment_id' => NULL,
                'duration_diff' => '13',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 10:00:00',
                'updated_at' => '2023-10-06 10:01:47',
                'booking_address' =>[
                    'address' => 'New Bedford, MA, USA',
                    'booking_id' => 222,
                    'created_at' => '2023-10-06 15:30:01',
                    'id' => 204,
                    'latitude' => '41.638409',
                    'longitude' => '-70.941208',
                    'updated_at' => '2023-10-06 15:30:01',
                ],
                'booking_address_id' => 25,
                'tax' => '[{"id":81,"provider_id":15,"title":"Service Tax","type":"percent","value":5}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 18.0,
                'final_total_tax' => 0.73,
                'final_sub_total' => 14.64,
                'final_discount_amount' => 0.36,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 223,
                'customer_id' => 3,
                'service_id' => 36,
                'provider_id' => 4,
                'date' => '2023-10-06 15:33:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 53.0,
                'discount' => 5.0,
                'total_amount' => 52.67,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'waiting',
                'address' => 'Northern fort housing',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 10:04:31',
                'updated_at' => '2023-10-06 10:04:31',
                'booking_address' =>[
                    'address' => 'North Battleford, SK, Canada',
                    'booking_id' => 223,
                    'created_at' => '2023-10-06 15:34:32',
                    'id' => 205,
                    'latitude' => '52.757500',
                    'longitude' => '-108.286110',
                    'updated_at' => '2023-10-06 15:34:32',
                ],
                'booking_address_id' => 1,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 53.0,
                'final_total_tax' => 6.32,
                'final_sub_total' => 46.35,
                'final_discount_amount' => 2.65,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 224,
                'customer_id' => 3,
                'service_id' => 41,
                'provider_id' => 12,
                'date' => '2023-10-07 15:34:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 35.0,
                'discount' => NULL,
                'total_amount' => 36.55,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 3,
                'status' => 'accept',
                'address' => 'Tree house Sandy beach',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 10:05:16',
                'updated_at' => '2023-10-06 10:18:06',
                'booking_address' =>[
                    'address' => 'Sandy Beach, Canada',
                    'booking_id' => 224,
                    'created_at' => '2023-10-06 15:35:17',
                    'id' => 206,
                    'latitude' => '-30.1483',
                    'longitude' => '153.2011',
                'updated_at' => '2023-10-06 15:35:17',
                ],
                'booking_address_id' => 20,
                'tax' => '[{"id":65,"provider_id":12,"title":"Service Tax","type":"percent","value":5},{"id":66,"provider_id":12,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 35.0,
                'final_total_tax' => 5.55,
                'final_sub_total' => 31.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 4.0,
            ],
            [
                'id' => 225,
                'customer_id' => 3,
                'service_id' => 100,
                'provider_id' => 4,
                'date' => '2023-10-06 15:36:00',
                'start_at' => NULL,
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 37.0,
                'discount' => 0.0,
                'total_amount' => 39.7,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'accept',
                'address' => 'Red fort housing',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 10:06:23',
                'updated_at' => '2023-10-06 10:16:57',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 225,
                    'created_at' => '2023-10-06 15:36:24',
                    'id' => 207,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-06 15:36:24',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 37.0,
                'final_total_tax' => 5.7,
                'final_sub_total' => 34.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
            [
                'id' => 226,
                'customer_id' => 3,
                'service_id' => 100,
                'provider_id' => 4,
                'date' => '2023-10-06 15:36:00',
                'start_at' => '2023-10-06 15:37:35',
                'end_at' => NULL,
                'quantity' => 1,
                'amount' => 37.0,
                'discount' => 0.0,
                'total_amount' => 39.7,
                'description' => NULL,
                'reason' => NULL,
                'coupon_id' => 7,
                'status' => 'in_progress',
                'address' => 'Red fort housing',
                'payment_id' => NULL,
                'duration_diff' => '0',
                'deleted_at' => NULL,
                'created_at' => '2023-10-06 10:06:33',
                'updated_at' => '2023-10-06 10:07:38',
                'booking_address' =>[
                    'address' => 'Melville, SK, Canada',
                    'booking_id' => 226,
                    'created_at' => '2023-10-06 15:36:35',
                    'id' => 208,
                    'latitude' => '50.930557',
                    'longitude' => '-102.807777',
                    'updated_at' => '2023-10-06 15:36:35',
                ],
                'booking_address_id' => 2,
                'tax' => '[{"id":76,"provider_id":4,"title":"Service Tax","type":"percent","value":5},{"id":77,"provider_id":4,"title":"Booking Fee","type":"fixed","value":4}]',
                'type' => 'service',
                'post_request_id' => NULL,
                'booking_slot' => NULL,
                'booking_day' => NULL,
                'booking_package' => NULL,
                'advance_paid_amount' => NULL,
                'final_total_service_price' => 37.0,
                'final_total_tax' => 5.7,
                'final_sub_total' => 34.0,
                'final_discount_amount' => 0.0,
                'final_coupon_discount_amount' => 3.0,
            ],
        ];
        
        foreach ($data as $key => $val) {
            $bookingData = Arr::except($val, ['booking_address']);
            $booking = Booking::create($bookingData);

            if (isset($val['booking_address'])) {
                $addresses = $val['booking_address'];
                $address = new BookingAddressMapping($addresses);
                $address->save();
            }
        }
    }
}