<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Arr;
use App\Models\Service;
use App\Models\ProviderServiceAddressMapping;

class ServicesTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        

        // \DB::table('services')->delete();
        
        // \DB::table('services')->insert(array (
            $data = [
                [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 9,
                'created_at' => '2023-09-04 13:27:09',
                'deleted_at' => NULL,
                'description' => 'Our experienced technicians ensure your Split AC is flawlessly installed and configured. Experience efficient cooling with precise placement and professional setup.',
                'discount' => 1.0,
                'duration' => '00:35',
                'id' => 11,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Split AC Setup',
                'price' => 25.0,
                'provider_id' => 17,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/ac_coolcare/split_ac_setup.png'),
                'subcategory_id' => 1,
                'type' => 'fixed',
                'updated_at' => '2023-09-04 13:27:09',
                'provider_address_mapping'=>[
                    [
                        'id' => 832,
                        'service_id' => 11,
                        'provider_address_id' => 29,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 833,
                        'service_id' => 11,
                        'provider_address_id' => 30,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 9,
                'created_at' => '2023-09-04 13:31:06',
                'deleted_at' => NULL,
                'description' => 'Enjoy hassle-free cooling with our Window AC installation service. Our experts provide a snug fit and optimal sealing, ensuring your unit is installed securely and operates effectively.',
                'discount' => 2.0,
                'duration' => '00:30',
                'id' => 12,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Window AC Installation',
                'price' => 30.0,
                'provider_id' => 16,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/ac_coolcare/window_ac_installation.png'),
                'subcategory_id' => 1,
                'type' => 'hourly',
                'updated_at' => '2023-09-04 13:31:06',
                'provider_address_mapping'=>[
                    [
                        'id' => 5,
                        'service_id' => 12,
                        'provider_address_id' => 27,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 6,
                        'service_id' => 12,
                        'provider_address_id' => 28,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 21,
                'created_at' => '2023-09-04 13:33:12',
                'deleted_at' => NULL,
                'description' => 'Ensure engine health. Our experts perform regular oil changes and fluid checks to maintain peak performance.',
                'discount' => 1.0,
                'duration' => '00:30',
                'id' => 13,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Oil Change and Fluid Checks',
                'price' => 12.0,
                'provider_id' => 16,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/automotive_care/oil_change_and_fluid_checks.png'),
                'subcategory_id' => 3,
                'type' => 'fixed',
                'updated_at' => '2023-09-04 13:33:12',
                'provider_address_mapping'=>[
                    [
                        'id' => 11,
                        'service_id' => 13,
                        'provider_address_id' => 27,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 12,
                        'service_id' => 13,
                        'provider_address_id' => 28,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => 10.0,
                'category_id' => 21,
                'created_at' => '2023-09-04 13:34:45',
                'deleted_at' => NULL,
                'description' => 'Maximize tire lifespan. We rotate and balance tires to even out wear and ensure a smooth, safe ride.',
                'discount' => 2.0,
                'duration' => '00:30',
                'id' => 14,
                'is_enable_advance_payment' => 1,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Tire Rotation and Balancing',
                'price' => 23.0,
                'provider_id' => 15,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/automotive_care/tire_rotation_and_balancing.png'),
                'subcategory_id' => 3,
                'type' => 'fixed',
                'updated_at' => '2023-09-05 07:25:14',
                'provider_address_mapping'=>[
                    [
                        'id' => 13,
                        'service_id' => 14,
                        'provider_address_id' => 25,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 14,
                        'service_id' => 14,
                        'provider_address_id' => 26,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => 5.0,
                'category_id' => 26,
                'created_at' => '2023-09-05 07:38:36',
                'deleted_at' => NULL,
                'description' => 'Restore the beauty and functionality of your wooden chairs with our skilled craftsmanship. We repair, refinish, and revitalize chairs for renewed comfort and charm.',
                'discount' => 2.0,
                'duration' => '00:50',
                'id' => 15,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Wooden Chair Restoration',
                'price' => 25.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/carpenter/wooden_chair_restoration_1.png'),
                'subcategory_id' => 5,
                'type' => 'fixed',
                'updated_at' => '2023-09-05 08:01:22',
                'provider_address_mapping'=>[
                    [
                        'id' => 107,
                        'service_id' => 15,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 108,
                        'service_id' => 15,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 109,
                        'service_id' => 15,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 110,
                        'service_id' => 15,
                        'provider_address_id' => 7,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 111,
                    //     'service_id' => 15,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 112,
                        'service_id' => 15,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 113,
                        'service_id' => 15,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 26,
                'created_at' => '2023-09-05 13:51:50',
                'deleted_at' => NULL,
                'description' => 'Renew the allure of your cabinets. Our professionals fix hinges, handles, and refinish surfaces, breathing new life into your cabinets while restoring their functionality and beauty.  🪚🔨',
                'discount' => 1.0,
                'duration' => '00:20',
                'id' => 16,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Cabinet Fix & Refinish',
                'price' => 20.0,
                'provider_id' => 8,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/carpenter/cabinet_fix_and_refinish_1.png'),
                'subcategory_id' => 5,
                'type' => 'fixed',
                'updated_at' => '2023-09-08 12:18:35',
                'provider_address_mapping'=>[
                    [
                        'id' => 152,
                        'service_id' => 16,
                        'provider_address_id' => 14,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 26,
                'created_at' => '2023-09-05 13:57:52',
                'deleted_at' => NULL,
                'description' => 'Experience superior structural support. Our experts install beams and columns with precision, enhancing load-bearing capacity and ensuring the stability of your building. 🪛🛠️',
                'discount' => NULL,
                'duration' => '00:15',
                'id' => 17,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Beam and Column Installation',
                'price' => 22.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/carpenter/beam_and_column_installation_1.png'),
                'subcategory_id' => 6,
                'type' => 'fixed',
                'updated_at' => '2023-09-05 13:57:52',
                'provider_address_mapping'=>[
                    [
                        'id' => 114,
                        'service_id' => 17,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 115,
                        'service_id' => 17,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 116,
                        'service_id' => 17,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 117,
                        'service_id' => 17,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 118,
                        'service_id' => 17,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 119,
                        'service_id' => 17,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 121,
                        'service_id' => 17,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 122,
                    //     'service_id' => 17,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 123,
                        'service_id' => 17,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 124,
                        'service_id' => 17,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 24,
                'created_at' => '2023-09-05 14:05:49',
                'deleted_at' => NULL,
                'description' => 'Our expert cleaners transform your home into a spotless haven. From dusting to mopping, every corner is meticulously cleaned, leaving you with a refreshed living environment. 🧽🧹🪣🧼',
                'discount' => 5.0,
                'duration' => '00:30',
                'id' => 18,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Full House Cleaning',
                'price' => 33.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cleaning/full_house_cleaning_1.jpeg'),
                'subcategory_id' => 7,
                'type' => 'hourly',
                'updated_at' => '2023-09-05 14:05:49',
                'provider_address_mapping'=>[
                    [
                        'id' => 125,
                        'service_id' => 18,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 126,
                        'service_id' => 18,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 127,
                        'service_id' => 18,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 128,
                        'service_id' => 18,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 129,
                        'service_id' => 18,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 130,
                        'service_id' => 18,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 24,
                'created_at' => '2023-09-05 14:07:49',
                'deleted_at' => NULL,
                'description' => 'Renew your spaces with our Ceiling and Wall Cleaning service, restoring freshness and brightness to your interiors. 🧽🧹🧻',
                'discount' => 4.0,
                'duration' => '0:50',
                'id' => 19,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 1,
                'name' => 'Ceiling and Wall Cleaning',
                'price' => 26.0,
                'provider_id' => 12,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cleaning/ceiling_and_wall_cleaning.png'),
                'subcategory_id' => 7,
                'type' => 'fixed',
                'updated_at' => '2023-09-06 05:27:26',
                'provider_address_mapping'=>[
                    [
                        'id' => 61,
                        'service_id' => 19,
                        'provider_address_id' => 21,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 62,
                        'service_id' => 19,
                        'provider_address_id' => 20,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 24,
                'created_at' => '2023-09-06 10:18:58',
                'deleted_at' => NULL,
                'description' => 'Renew your carpets\' vibrancy. Our specialized cleaning process removes stains and dirt, leaving your carpets soft, clean, and inviting. 🧽🧹🧼',
                'discount' => NULL,
                'duration' => '00:19',
                'id' => 20,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Carpet Cleaning',
                'price' => 40.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cleaning/carpet_cleaning_1.png'),
                'subcategory_id' => 8,
                'type' => 'fixed',
                'updated_at' => '2023-09-06 10:18:58',
                'provider_address_mapping'=>[
                    [
                        'id' => 81,
                        'service_id' => 20,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 82,
                        'service_id' => 20,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 83,
                        'service_id' => 20,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 84,
                        'service_id' => 20,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 24,
                'created_at' => '2023-09-06 10:42:25',
                'deleted_at' => NULL,
                'description' => 'Revive your space with our Curtain Cleaning service, restoring freshness and cleanliness to your drapes. 🧽🧼',
                'discount' => 0.0,
                'duration' => '00:30',
                'id' => 21,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Curtain Cleaning',
                'price' => 0.0,
                'provider_id' => 14,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cleaning/curtain_cleaning_1.png'),
                'subcategory_id' => 8,
                'type' => 'free',
                'updated_at' => '2023-09-06 10:42:25',
                'provider_address_mapping'=>[
                    [
                        'id' => 85,
                        'service_id' => 21,
                        'provider_address_id' => 23,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 86,
                        'service_id' => 21,
                        'provider_address_id' => 24,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 24,
                'created_at' => '2023-09-06 10:43:58',
                'deleted_at' => NULL,
                'description' => 'Ensure fireplace safety and optimal performance with our Chimney Sweeping service, expertly removing debris and buildup. 🧼🧹🧻',
                'discount' => 2.0,
                'duration' => '00:30',
                'id' => 22,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Chimney Sweeping',
                'price' => 15.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cleaning/chimney_sweeping_1.png'),
                'subcategory_id' => 8,
                'type' => 'hourly',
                'updated_at' => '2023-09-06 10:43:58',
                'provider_address_mapping'=>[
                    [
                        'id' => 87,
                        'service_id' => 22,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 88,
                        'service_id' => 22,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 89,
                        'service_id' => 22,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 90,
                        'service_id' => 22,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => 5.0,
                'category_id' => 22,
                'created_at' => '2023-09-06 10:48:04',
                'deleted_at' => NULL,
                'description' => 'Enjoy the convenience of homemade meals with our Daily Meals Preparation service. Our skilled home cooks curate a variety of nutritious and flavorful dishes tailored to your preferences. From breakfast to dinner, we ensure you\'re provided with well-balanced and delicious meals, freeing you from the kitchen and letting you savor homemade goodness. 🥪🍕🍜',
                'discount' => NULL,
                'duration' => '00:25',
                'id' => 23,
                'is_enable_advance_payment' => 1,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Daily Meals Preparation Cook',
                'price' => 23.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cooking/daily_meals_preparation_1.png'),
                'subcategory_id' => 9,
                'type' => 'fixed',
                'updated_at' => '2023-10-02 13:22:29',
                'provider_address_mapping'=>[
                    [
                        'id' => 826,
                        'service_id' => 23,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 827,
                        'service_id' => 23,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 828,
                        'service_id' => 23,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 829,
                        'service_id' => 23,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 830,
                        'service_id' => 23,
                        'provider_address_id' => 7,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 831,
                        'service_id' => 23,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 22,
                'created_at' => '2023-09-06 10:49:46',
                'deleted_at' => NULL,
                'description' => 'Rediscover the joy of family gatherings with our Family-style Dinners. Our home cooks prepare wholesome and comforting meals that bring loved ones together around the table. Enjoy a shared culinary experience that fosters connection and creates lasting memories. 🧆🥙🥗',
                'discount' => NULL,
                'duration' => '00:20',
                'id' => 24,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Family Style Dinner Chef',
                'price' => 32.0,
                'provider_id' => 7,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cooking/family_style_dinners_1.png'),
                'subcategory_id' => 9,
                'type' => 'fixed',
                'updated_at' => '2023-10-02 12:02:29',
                'provider_address_mapping'=>[
                    [
                        'id' => 821,
                        'service_id' => 24,
                        'provider_address_id' => 13,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 22,
                'created_at' => '2023-09-06 11:03:23',
                'deleted_at' => NULL,
                'description' => 'Experience the vibrant flavors of Mexico with our Authentic Mexican Chef service. Our skilled chefs craft traditional dishes that capture the essence of Mexican cuisine, bringing the zest of Mexico to your table. 🫔🌮',
                'discount' => NULL,
                'duration' => '00:45',
                'id' => 25,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Authentic Mexican Chef',
                'price' => 16.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cooking/authentic_mexican_chef_1.jpg'),
                'subcategory_id' => 10,
                'type' => 'fixed',
                'updated_at' => '2023-09-06 11:03:23',
                'provider_address_mapping'=>[
                    [
                        'id' => 98,
                        'service_id' => 25,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 99,
                        'service_id' => 25,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 100,
                        'service_id' => 25,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 101,
                        'service_id' => 25,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 22,
                'created_at' => '2023-09-06 11:05:50',
                'deleted_at' => NULL,
                'description' => 'Elevate your dining experience with our Italian Cook chef service, where expertly crafted Italian dishes transport your taste buds to the heart of Italy. 🫕 🍝🍜',
                'discount' => NULL,
                'duration' => '00:23',
                'id' => 26,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Chinese Food',
                'price' => 41.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cooking/chinese_food.png'),
                'subcategory_id' => 10,
                'type' => 'fixed',
                'updated_at' => '2023-09-06 11:05:50',
                'provider_address_mapping'=>[
                    [
                        'id' => 102,
                        'service_id' => 26,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 103,
                        'service_id' => 26,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 104,
                        'service_id' => 26,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 105,
                        'service_id' => 26,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 106,
                    //     'service_id' => 26,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 22,
                'created_at' => '2023-09-06 11:46:24',
                'deleted_at' => NULL,
                'description' => 'Elevate your dining experience with our Italian Cook chef service, where expertly crafted Italian dishes transport your taste buds to the heart of Italy. 🍕🥘🍜',
                'discount' => NULL,
                'duration' => '00:55',
                'id' => 27,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Italian Cook',
                'price' => 10.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cooking/italian_cook_1.png'),
                'subcategory_id' => 10,
                'type' => 'fixed',
                'updated_at' => '2023-09-06 11:46:24',
                'provider_address_mapping'=>[
                    [
                        'id' => 135,
                        'service_id' => 27,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 136,
                        'service_id' => 27,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 137,
                        'service_id' => 27,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 138,
                        'service_id' => 27,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 25,
                'created_at' => '2023-09-06 13:48:44',
                'deleted_at' => NULL,
                'description' => 'Fix faulty wiring promptly. Our experts diagnose and repair wiring issues, ensuring your electrical systems function flawlessly. 🔧🪛',
                'discount' => NULL,
                'duration' => '00:20',
                'id' => 28,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Wiring Repair',
                'price' => 26.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/electrician/wiring_repair_1.png'),
                'subcategory_id' => 11,
                'type' => 'fixed',
                'updated_at' => '2023-09-06 13:48:44',
                'provider_address_mapping'=>[
                    [
                        'id' => 139,
                        'service_id' => 28,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 140,
                        'service_id' => 28,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 141,
                        'service_id' => 28,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 142,
                        'service_id' => 28,
                        'provider_address_id' => 7,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 143,
                        'service_id' => 28,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 25,
                'created_at' => '2023-09-06 13:51:35',
                'deleted_at' => NULL,
                'description' => 'Transform your interiors with our expert indoor lighting installation. We install a variety of fixtures, enhancing ambiance and functionality. 🔧🪛🛠️',
                'discount' => NULL,
                'duration' => '00:35',
                'id' => 29,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Indoor Lighting Installation',
                'price' => 28.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/electrician/indoor_lighting_installation_1.png'),
                'subcategory_id' => 12,
                'type' => 'fixed',
                'updated_at' => '2023-09-06 13:51:35',
                'provider_address_mapping'=>[
                    [
                        'id' => 144,
                        'service_id' => 29,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 145,
                        'service_id' => 29,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 146,
                        'service_id' => 29,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 147,
                        'service_id' => 29,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 25,
                'created_at' => '2023-09-08 05:12:20',
                'deleted_at' => NULL,
                'description' => 'Illuminate your surroundings. Our outdoor lighting installation creates a welcoming environment while enhancing security and aesthetics. 🔧🪛💡',
                'discount' => NULL,
                'duration' => '00:20',
                'id' => 30,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Outdoor Lighting Setup',
                'price' => 30.0,
                'provider_id' => 14,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/electrician/outdoor_lighting_setup_1.png'),
                'subcategory_id' => 12,
                'type' => 'hourly',
                'updated_at' => '2023-09-08 05:12:20',
                'provider_address_mapping'=>[
                    [
                        'id' => 150,
                        'service_id' => 30,
                        'provider_address_id' => 23,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 151,
                        'service_id' => 30,
                        'provider_address_id' => 24,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 21,
                'created_at' => '2023-09-08 13:31:22',
                'deleted_at' => NULL,
                'description' => 'Uncover issues quickly. Our advanced diagnostics pinpoint engine problems, enabling efficient repairs. 🪛 🛠️ 🚒 🚙 🚛',
                'discount' => 1.0,
                'duration' => '00:20',
                'id' => 31,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Engine Diagnostics',
                'price' => 12.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/automotive_care/engine_diagnostics.png'),
                'subcategory_id' => 4,
                'type' => 'fixed',
                'updated_at' => '2023-09-08 13:31:22',
                'provider_address_mapping'=>[
                    [
                        'id' => 153,
                        'service_id' => 31,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 154,
                        'service_id' => 31,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 155,
                        'service_id' => 31,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 156,
                        'service_id' => 31,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => 10.0,
                'category_id' => 21,
                'created_at' => '2023-09-08 13:33:26',
                'deleted_at' => NULL,
                'description' => 'Enjoy a pristine cabin. Our professionals clean and care for your vehicle\'s interior, from upholstery to dashboard. 🚛🚙',
                'discount' => 10.0,
                'duration' => '00:25',
                'id' => 32,
                'is_enable_advance_payment' => 1,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Interior Cleaning and Care',
                'price' => 45.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/automotive_care/interior_cleaning_and_care.png'),
                'subcategory_id' => 40,
                'type' => 'fixed',
                'updated_at' => '2023-09-08 13:33:26',
                'provider_address_mapping'=>[
                    [
                        'id' => 157,
                        'service_id' => 32,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 158,
                        'service_id' => 32,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 159,
                        'service_id' => 32,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 160,
                        'service_id' => 32,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 21,
                'created_at' => '2023-09-08 13:35:35',
                'deleted_at' => NULL,
                'description' => 'Smooth gear shifts matter. We expertly repair transmissions, ensuring seamless performance. 🪛 🛠️',
                'discount' => 2.0,
                'duration' => '00:30',
                'id' => 33,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Transmission Repair',
                'price' => 42.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/automotive_care/transmission_repair.png'),
                'subcategory_id' => 4,
                'type' => 'hourly',
                'updated_at' => '2023-09-08 13:35:35',
                'provider_address_mapping'=>[
                    [
                        'id' => 161,
                        'service_id' => 33,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 162,
                        'service_id' => 33,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 163,
                        'service_id' => 33,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 164,
                        'service_id' => 33,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 165,
                        'service_id' => 33,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 166,
                        'service_id' => 33,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 167,
                    //     'service_id' => 33,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 168,
                        'service_id' => 33,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 26,
                'created_at' => '2023-09-08 13:38:53',
                'deleted_at' => NULL,
                'description' => 'Complete your doors with our door casing and trim service. Our experts carefully install decorative casing and trim to frame your doors beautifully. 🪛🛠️',
                'discount' => 0.0,
                'duration' => '0:40',
                'id' => 34,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 1,
                'name' => 'Door Casing and Trim',
                'price' => 26.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/carpenter/door_casing_and_trim.png'),
                'subcategory_id' => 48,
                'type' => 'fixed',
                'updated_at' => '2023-09-08 13:47:56',
                'provider_address_mapping'=>[
                    [
                        'id' => 181,
                        'service_id' => 34,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 182,
                        'service_id' => 34,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 183,
                        'service_id' => 34,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 184,
                        'service_id' => 34,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 185,
                        'service_id' => 34,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 186,
                        'service_id' => 34,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 24,
                'created_at' => '2023-09-08 13:45:00',
                'deleted_at' => NULL,
                'description' => 'Experience the transformation of your kitchen and bathroom with our Deep Cleaning service. Our meticulous team targets every nook and cranny, removing grime, stains, and buildup, leaving your spaces sparkling, sanitized, and refreshed. 🧽🧼🧹🪣',
                'discount' => 4.0,
                'duration' => '00:35',
                'id' => 35,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Kitchen & BathRoom Deep Cleaning',
                'price' => 38.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cleaning/kitchen_and_bathroom_deep_cleaning_1.png'),
                'subcategory_id' => 47,
                'type' => 'fixed',
                'updated_at' => '2023-09-08 13:45:00',
                'provider_address_mapping'=>[
                    [
                        'id' => 176,
                        'service_id' => 35,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 177,
                        'service_id' => 35,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 178,
                        'service_id' => 35,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 179,
                        'service_id' => 35,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 180,
                        'service_id' => 35,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => 4.0,
                'category_id' => 9,
                'created_at' => '2023-09-08 13:51:35',
                'deleted_at' => NULL,
                'description' => 'Keep your AC in peak condition. Our comprehensive tune-up optimizes performance, extends lifespan, and prevents potential issues. 🪛🛠️',
                'discount' => 5.0,
                'duration' => '0:25',
                'id' => 36,
                'is_enable_advance_payment' => 1,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'AC Tune-up',
                'price' => 53.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/ac_coolcare/ac_tune_up.png'),
                'subcategory_id' => 2,
                'type' => 'fixed',
                'updated_at' => '2023-10-06 11:44:46',
                'provider_address_mapping'=>[
                    [
                        'id' => 845,
                        'service_id' => 36,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 846,
                        'service_id' => 36,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 847,
                        'service_id' => 36,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 9,
                'created_at' => '2023-09-08 13:53:57',
                'deleted_at' => NULL,
                'description' => 'Experience engine efficiency and temperature control with our Coolant Renewal Service. We replace old coolant to ensure optimal performance and prevent overheating. 🔩🔧',
                'discount' => 0.0,
                'duration' => '00:23',
                'id' => 37,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Coolant Renewal Service',
                'price' => 40.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/ac_coolcare/coolant_renewal_service.png'),
                'subcategory_id' => 2,
                'type' => 'fixed',
                'updated_at' => '2023-09-08 13:53:57',
                'provider_address_mapping'=>[
                    [
                        'id' => 191,
                        'service_id' => 37,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 192,
                        'service_id' => 37,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 193,
                        'service_id' => 37,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 194,
                    //     'service_id' => 37,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 195,
                        'service_id' => 37,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 196,
                        'service_id' => 37,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 21,
                'created_at' => '2023-09-08 13:56:32',
                'deleted_at' => NULL,
                'description' => 'Preserve your vehicle\'s finish. We apply protective coatings and perform polishing for a long-lasting shine.  🚛🚙🚗',
                'discount' => 0.0,
                'duration' => '00:36',
                'id' => 38,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Paint Protection and Polishing',
                'price' => 35.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/automotive_care/paint_protection_and_polishing_1.png'),
                'subcategory_id' => 40,
                'type' => 'fixed',
                'updated_at' => '2023-09-08 13:56:32',
                'provider_address_mapping'=>[
                    [
                        'id' => 197,
                        'service_id' => 38,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 198,
                        'service_id' => 38,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 199,
                    //     'service_id' => 38,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 200,
                        'service_id' => 38,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 201,
                        'service_id' => 38,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 10,
                'created_at' => '2023-09-09 06:04:40',
                'deleted_at' => NULL,
                'description' => 'Preserve sentimental pieces. Our tailors restore vintage or cherished garments, returning them to their former glory. 🥻👔👚',
                'discount' => 4.0,
                'duration' => '00:25',
                'id' => 39,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Garment Restoration',
                'price' => 42.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/tailor/garment_restoration_1.png'),
                'subcategory_id' => 41,
                'type' => 'hourly',
                'updated_at' => '2023-09-09 06:04:40',
                'provider_address_mapping'=>[
                    [
                        'id' => 210,
                        'service_id' => 39,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 211,
                        'service_id' => 39,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 212,
                        'service_id' => 39,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 213,
                        'service_id' => 39,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 11,
                'created_at' => '2023-09-09 06:10:07',
                'deleted_at' => NULL,
                'description' => 'Immerse yourself in cinematic bliss. Our service includes the installation of home theater systems that deliver high-quality audio and video. 📺 🖥️ 🎛️',
                'discount' => 0.0,
                'duration' => '00:26',
                'id' => 40,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Home Theater Setup',
                'price' => 12.0,
                'provider_id' => 15,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/smart_home/home_theater_setup_1.png'),
                'subcategory_id' => 32,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 06:10:07',
                'provider_address_mapping'=>[
                    [
                        'id' => 214,
                        'service_id' => 40,
                        'provider_address_id' => 25,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 215,
                        'service_id' => 40,
                        'provider_address_id' => 26,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 10,
                'created_at' => '2023-09-09 06:16:19',
                'deleted_at' => NULL,
                'description' => 'Breathe new life into torn garments. Our skilled tailors expertly mend fabric and apply patches for seamless repairs. 🪡🧵',
                'discount' => NULL,
                'duration' => '00:25',
                'id' => 41,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Patchwork and Fabric Repair',
                'price' => 35.0,
                'provider_id' => 12,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/tailor/patchwork_and_fabric_repair_2.png'),
                'subcategory_id' => 41,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 06:16:19',
                'provider_address_mapping'=>[
                    [
                        'id' => 216,
                        'service_id' => 41,
                        'provider_address_id' => 20,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 217,
                        'service_id' => 41,
                        'provider_address_id' => 21,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 17,
                'created_at' => '2023-09-09 06:39:44',
                'deleted_at' => NULL,
                'description' => 'Celebrate blessings and success. Our Pandits conduct the Satyanarayan Katha, invoking Lord Vishnu\'s grace for prosperity. 🔥',
                'discount' => 0.0,
                'duration' => '00:20',
                'id' => 42,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Satyanarayan Katha',
                'price' => 30.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/pandit/satyanarayan_katha_1.png'),
                'subcategory_id' => 17,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 06:39:44',
                'provider_address_mapping'=>[
                    [
                        'id' => 218,
                        'service_id' => 42,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 219,
                        'service_id' => 42,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 220,
                        'service_id' => 42,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 221,
                        'service_id' => 42,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 16,
                'created_at' => '2023-09-09 06:43:21',
                'deleted_at' => NULL,
                'description' => 'Say goodbye to roaches. Our roach control service tackles infestations head-on, using safe and efficient methods to ensure a roach-free environment. 🪲🪳🪰🐞',
                'discount' => 4.0,
                'duration' => '00:35',
                'id' => 43,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Roach Control',
                'price' => 40.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/pest_control/roach_control_1.png'),
                'subcategory_id' => 19,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 06:43:21',
                'provider_address_mapping'=>[
                    [
                        'id' => 222,
                        'service_id' => 43,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 223,
                        'service_id' => 43,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 224,
                        'service_id' => 43,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 225,
                        'service_id' => 43,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => 5.0,
                'category_id' => 15,
                'created_at' => '2023-09-09 06:45:18',
                'deleted_at' => NULL,
                'description' => 'Capture cherished moments with our Family & Couple\'s Portraits service. Let us create timeless, heartwarming memories for you and your loved ones through beautifully crafted photography. 📸',
                'discount' => 4.0,
                'duration' => '0:30',
                'id' => 44,
                'is_enable_advance_payment' => 1,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Family & Couple\'s Portraits',
                'price' => 50.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/photography/family_and_couple_portraits_1.png'),
                'subcategory_id' => 21,
                'type' => 'fixed',
                'updated_at' => '2023-10-06 11:46:06',
                'provider_address_mapping'=>[
                    [
                        'id' => 853,
                        'service_id' => 44,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 854,
                        'service_id' => 44,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 855,
                        'service_id' => 44,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 856,
                        'service_id' => 44,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 14,
                'created_at' => '2023-09-09 06:47:19',
                'deleted_at' => NULL,
                'description' => 'Treat your skin to luxury. Our estheticians offer personalized facials targeting your specific skin concerns, leaving you refreshed and radiant. 🧖‍♀️',
                'discount' => 0.0,
                'duration' => '00:25',
                'id' => 45,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Customized Facials',
                'price' => 25.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/salon/customized_facials_1.png'),
                'subcategory_id' => 26,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 06:48:26',
                'provider_address_mapping'=>[
                    [
                        'id' => 240,
                        'service_id' => 45,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 241,
                        'service_id' => 45,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 242,
                        'service_id' => 45,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 243,
                        'service_id' => 45,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 244,
                        'service_id' => 45,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 22,
                'created_at' => '2023-09-09 07:00:56',
                'deleted_at' => NULL,
                'description' => 'Indulge in exquisite sweetness with our Dessert Chef service, where delectable creations redefine dessert experiences. 🎂🧁',
                'discount' => 0.0,
                'duration' => '00:20',
                'id' => 46,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Dessert Chef',
                'price' => 15.0,
                'provider_id' => 13,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cooking/dessert_chef_1.jpg'),
                'subcategory_id' => 45,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 07:00:56',
                'provider_address_mapping'=>[
                    [
                        'id' => 245,
                        'service_id' => 46,
                        'provider_address_id' => 22,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 20,
                'created_at' => '2023-09-09 07:05:33',
                'deleted_at' => NULL,
                'description' => 'Our Green Space Guardians service to ensure your garden thrives year-round. Our expert team provides meticulous care, from pruning to fertilizing, to maintain your green haven\'s health and beauty. Relax while we keep your garden pristine and flourishing. 🌴🌾🪴🥀',
                'discount' => 0.0,
                'duration' => '00:30',
                'id' => 47,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Green Space Guardians',
                'price' => 19.0,
                'provider_id' => 17,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/gardener/green_space_gardians.png'),
                'subcategory_id' => 13,
                'type' => 'fixed',
                'updated_at' => '2023-09-11 10:42:05',
                'provider_address_mapping'=>[
                    [
                        'id' => 834,
                        'service_id' => 47,
                        'provider_address_id' => 29,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 835,
                        'service_id' => 47,
                        'provider_address_id' => 30,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 19,
                'created_at' => '2023-09-09 07:12:41',
                'deleted_at' => NULL,
                'description' => 'Enjoy clean and crisp clothing. Our wash and fold service ensures your everyday clothes are laundered with care. 👖👕👗👘',
                'discount' => 0.0,
                'duration' => '00:25',
                'id' => 48,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Regular Clothing Wash And Fold',
                'price' => 18.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/laundry/regular_clothing_wash_1.png'),
                'subcategory_id' => 50,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 07:12:41',
                'provider_address_mapping'=>[
                    [
                        'id' => 812,
                        'service_id' => 48,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 813,
                        'service_id' => 48,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 814,
                        'service_id' => 48,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 815,
                        'service_id' => 48,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 20,
                'created_at' => '2023-09-09 07:16:51',
                'deleted_at' => NULL,
                'description' => 'Keep your lawn immaculate. Our professionals provide precise mowing and trimming, ensuring a neat and manicured appearance. ⛏️🪓🪴',
                'discount' => 1.0,
                'duration' => '00:40',
                'id' => 49,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Lawn Mowing and Trimming',
                'price' => 41.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/gardener/lawn_mowing_and_trimming.png'),
                'subcategory_id' => 14,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 07:16:51',
                'provider_address_mapping'=>[
                    [
                        'id' => 252,
                        'service_id' => 49,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 253,
                        'service_id' => 49,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 254,
                    //     'service_id' => 49,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 255,
                        'service_id' => 49,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 256,
                        'service_id' => 49,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 18,
                'created_at' => '2023-09-09 07:18:54',
                'deleted_at' => NULL,
                'description' => 'Elevate your interiors. Our skilled painters provide complete room painting, adding color and style to your living spaces. 🖌️',
                'discount' => 0.0,
                'duration' => '00:25',
                'id' => 50,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Whole Room Painting',
                'price' => 25.0,
                'provider_id' => 12,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/painter/whole_room_painting_1.png'),
                'subcategory_id' => 15,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 07:18:54',
                'provider_address_mapping'=>[
                    [
                        'id' => 257,
                        'service_id' => 50,
                        'provider_address_id' => 20,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 258,
                        'service_id' => 50,
                        'provider_address_id' => 21,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 17,
                'created_at' => '2023-09-09 07:30:58',
                'deleted_at' => NULL,
                'description' => 'Create a sacred union. Our Marriage Puja service invokes blessings for a harmonious and blessed marital journey. 🔥 👫🏻',
                'discount' => 3.0,
                'duration' => '00:15',
                'id' => 51,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Marriage Puja',
                'price' => 45.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/pandit/marriage_puja.png'),
                'subcategory_id' => 17,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 07:30:58',
                'provider_address_mapping'=>[
                    [
                        'id' => 259,
                        'service_id' => 51,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 260,
                        'service_id' => 51,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 261,
                        'service_id' => 51,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 262,
                        'service_id' => 51,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 12,
                'created_at' => '2023-09-09 07:36:27',
                'deleted_at' => NULL,
                'description' => 'Elevate your security. Our highly trained bodyguards provide personalized protection, ensuring your safety in various environments. 👮🏻',
                'discount' => 10.0,
                'duration' => '00:20',
                'id' => 52,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Bodyguard Services',
                'price' => 40.0,
                'provider_id' => 8,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/security_guard/bodyguard_services_1.png'),
                'subcategory_id' => 29,
                'type' => 'hourly',
                'updated_at' => '2023-09-29 14:02:46',
                'provider_address_mapping'=>[
                    [
                        'id' => 816,
                        'service_id' => 52,
                        'provider_address_id' => 14,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 23,
                'created_at' => '2023-09-09 07:40:01',
                'deleted_at' => NULL,
                'description' => 'Our experts swiftly address pipe bursts, minimizing water loss and property damage.  🛠️👨🏻‍🔧',
                'discount' => 0.0,
                'duration' => '00:35',
                'id' => 53,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Pipe Bursting Repair',
                'price' => 0.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/plumber/pipe_bursting_repair_1.png'),
                'subcategory_id' => 23,
                'type' => 'free',
                'updated_at' => '2023-10-02 12:32:00',
                'provider_address_mapping'=>[
                    [
                        'id' => 822,
                        'service_id' => 53,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 823,
                        'service_id' => 53,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 824,
                        'service_id' => 53,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 825,
                        'service_id' => 53,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 13,
                'created_at' => '2023-09-09 07:49:22',
                'deleted_at' => NULL,
                'description' => 'Pay attention to the details. We focus on high-touch areas such as doorknobs, light switches, and handles, effectively reducing the spread of germs and viruses. 🧴🪳',
                'discount' => 5.0,
                'duration' => '00:30',
                'id' => 54,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'High Touch Point Disinfection',
                'price' => 35.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/sanitization/high_touch_point_disinfection_1.png'),
                'subcategory_id' => 27,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 07:49:22',
                'provider_address_mapping'=>[
                    [
                        'id' => 273,
                        'service_id' => 54,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 274,
                        'service_id' => 54,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 275,
                        'service_id' => 54,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 276,
                        'service_id' => 54,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 12,
                'created_at' => '2023-09-09 07:50:42',
                'deleted_at' => NULL,
                'description' => 'Secure VIP movements. Our expert personnel offer discreet escort services, ensuring a safe and smooth experience for high-profile individuals. 👮🏻',
                'discount' => 0.0,
                'duration' => '00:40',
                'id' => 55,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'VIP Escort Protection',
                'price' => 41.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/security_guard/vip_escort_protection_1.png'),
                'subcategory_id' => 29,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 07:50:42',
                'provider_address_mapping'=>[
                    [
                        'id' => 288,
                        'service_id' => 55,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 289,
                        'service_id' => 55,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 290,
                        'service_id' => 55,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 291,
                        'service_id' => 55,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 292,
                        'service_id' => 55,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 293,
                        'service_id' => 55,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 294,
                        'service_id' => 55,
                        'provider_address_id' => 7,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 295,
                        'service_id' => 55,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 296,
                    //     'service_id' => 55,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 297,
                        'service_id' => 55,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 298,
                        'service_id' => 55,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 11,
                'created_at' => '2023-09-09 07:52:40',
                'deleted_at' => NULL,
                'description' => 'Illuminate your home intelligently. Our experts install smart lighting systems that you can control remotely for enhanced ambiance and energy efficiency. 💡🔌',
                'discount' => 4.0,
                'duration' => '00:30',
                'id' => 56,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Smart Lighting Installation',
                'price' => 50.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/smart_home/smart_lighting_installation_1.png'),
                'subcategory_id' => 31,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 07:52:40',
                'provider_address_mapping'=>[
                    [
                        'id' => 303,
                        'service_id' => 56,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 304,
                        'service_id' => 56,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 305,
                        'service_id' => 56,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 306,
                        'service_id' => 56,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 10,
                'created_at' => '2023-09-09 07:54:59',
                'deleted_at' => NULL,
                'description' => 'Get your garments tailored to the right length. Our skilled tailors adjust hems for a clean and polished look. 🪡🧵🧥🥻',
                'discount' => 2.0,
                'duration' => '00:25',
                'id' => 57,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Hemming and Length Adjustment',
                'price' => 40.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/tailor/hemming_and_length_adjustment_1.png'),
                'subcategory_id' => 33,
                'type' => 'hourly',
                'updated_at' => '2023-09-09 07:54:59',
                'provider_address_mapping'=>[
                    [
                        'id' => 307,
                        'service_id' => 57,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 308,
                        'service_id' => 57,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 309,
                        'service_id' => 57,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 310,
                        'service_id' => 57,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 311,
                        'service_id' => 57,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 11,
                'created_at' => '2023-09-09 07:58:24',
                'deleted_at' => NULL,
                'description' => 'Streamline your household with Smart Appliance Integration. We connect your appliances to your smart home network, enabling remote operation and energy management, making daily tasks more convenient and efficient. 📱💡🔌',
                'discount' => 0.0,
                'duration' => '00:40',
                'id' => 58,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Smart Appliance Integration',
                'price' => 25.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/smart_home/smart_appliance_integration.png'),
                'subcategory_id' => 31,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 07:58:24',
                'provider_address_mapping'=>[
                    [
                        'id' => 312,
                        'service_id' => 58,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 313,
                        'service_id' => 58,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 314,
                        'service_id' => 58,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 315,
                        'service_id' => 58,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => 10.0,
                'category_id' => 10,
                'created_at' => '2023-09-09 08:01:03',
                'deleted_at' => NULL,
                'description' => 'Wear your vision. Our tailors craft custom suits and dresses, reflecting your style and personality. 🧥🥻👔👚',
                'discount' => 0.0,
                'duration' => '00:15',
                'id' => 59,
                'is_enable_advance_payment' => 1,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Bespoke Suits and Dresses',
                'price' => 42.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/tailor/bespoke_suits_and_dresses_1.png'),
                'subcategory_id' => 34,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 08:01:03',
                'provider_address_mapping'=>[
                    [
                        'id' => 316,
                        'service_id' => 59,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 317,
                        'service_id' => 59,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 318,
                        'service_id' => 59,
                        'provider_address_id' => 7,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 319,
                        'service_id' => 59,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 23,
                'created_at' => '2023-09-09 08:18:27',
                'deleted_at' => NULL,
                'description' => 'Experience free-flowing drains. Our clogged drain cleaning service eliminates blockages and ensures efficient drainage. 🧼🪣🪠',
                'discount' => 0.0,
                'duration' => '00:35',
                'id' => 60,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Clogged Drain Cleaning',
                'price' => 36.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/plumber/clogged_drain_cleaning_1.png'),
                'subcategory_id' => 23,
                'type' => 'hourly',
                'updated_at' => '2023-09-09 08:18:27',
                'provider_address_mapping'=>[
                    [
                        'id' => 325,
                        'service_id' => 60,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 326,
                        'service_id' => 60,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 327,
                        'service_id' => 60,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 328,
                        'service_id' => 60,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 329,
                        'service_id' => 60,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 14,
                'created_at' => '2023-09-09 08:20:47',
                'deleted_at' => NULL,
                'description' => 'Add vibrancy to your hair. Our color experts offer a range of options, from subtle highlights to bold transformations. 💆🏻‍♀️',
                'discount' => 0.0,
                'duration' => '00:25',
                'id' => 61,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Hair Coloring',
                'price' => 37.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/salon/hair_coloring_1.jpg'),
                'subcategory_id' => 25,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 08:20:47',
                'provider_address_mapping'=>[
                    [
                        'id' => 334,
                        'service_id' => 61,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 335,
                        'service_id' => 61,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 336,
                        'service_id' => 61,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 337,
                        'service_id' => 61,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 17,
                'created_at' => '2023-09-09 08:24:11',
                'deleted_at' => NULL,
                'description' => 'Unlock your financial potential and career growth with our Consultation service. Our experts provide personalized guidance and strategies for achieving your professional and financial goals. 🔯',
                'discount' => 0.0,
                'duration' => '00:40',
                'id' => 62,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Career and Finance Consultation',
                'price' => 18.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/pandit/career_and_finance_consultation.png'),
                'subcategory_id' => 18,
                'type' => 'hourly',
                'updated_at' => '2023-09-09 08:24:11',
                'provider_address_mapping'=>[
                    [
                        'id' => 338,
                        'service_id' => 62,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 339,
                        'service_id' => 62,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 340,
                        'service_id' => 62,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 341,
                        'service_id' => 62,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 16,
                'created_at' => '2023-09-09 08:25:41',
                'deleted_at' => NULL,
                'description' => 'Sleep soundly again. Our bed bug eradication service eliminates these pests from your home, giving you peace of mind and a restful night\'s sleep. 🧴🪲🪳',
                'discount' => 0.0,
                'duration' => '0:25',
                'id' => 63,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 1,
                'name' => 'Bed Bug Eradication',
                'price' => 20.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/pest_control/bed_bug_eradication_1.png'),
                'subcategory_id' => 19,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 09:29:46',
                'provider_address_mapping'=>[
                    [
                        'id' => 352,
                        'service_id' => 63,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 353,
                        'service_id' => 63,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 354,
                        'service_id' => 63,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 355,
                        'service_id' => 63,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 356,
                        'service_id' => 63,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 18,
                'created_at' => '2023-09-09 09:35:40',
                'deleted_at' => NULL,
                'description' => 'Maintain your interiors\' vibrancy with Color Touch-ups and Maintenance. Our painters provide expert touch-ups and color restoration, ensuring your walls and surfaces look impeccable over time. 🪣🖌️',
                'discount' => 4.0,
                'duration' => '0:10',
                'id' => 64,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Color Touch-ups and Maintenance',
                'price' => 25.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/painter/color_touch_ups_and_maintenance.png'),
                'subcategory_id' => 15,
                'type' => 'fixed',
                'updated_at' => '2023-10-06 11:45:18',
                'provider_address_mapping'=>[
                    [
                        'id' => 848,
                        'service_id' => 64,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 849,
                        'service_id' => 64,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 850,
                        'service_id' => 64,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 851,
                        'service_id' => 64,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 852,
                        'service_id' => 64,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 16,
                'created_at' => '2023-09-09 09:36:54',
                'deleted_at' => NULL,
                'description' => 'Swiftly address rodent issues. Our rodent trapping service uses effective and humane traps to capture and remove rodents from your space, ensuring a pest-free environment. 🧴 🪤',
                'discount' => 0.0,
                'duration' => '00:25',
                'id' => 65,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Rodent Trapping',
                'price' => 40.0,
                'provider_id' => 14,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/pest_control/rodent_trapping_1.png'),
                'subcategory_id' => 20,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 09:36:54',
                'provider_address_mapping'=>[
                    [
                        'id' => 362,
                        'service_id' => 65,
                        'provider_address_id' => 23,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 363,
                        'service_id' => 65,
                        'provider_address_id' => 24,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 23,
                'created_at' => '2023-09-09 09:39:36',
                'deleted_at' => NULL,
                'description' => 'Enjoy hot water efficiently. Our water heater installation service ensures your unit is set up for reliable and consistent hot water supply. 🔩🔧🪛🛠️',
                'discount' => 0.0,
                'duration' => '00:30',
                'id' => 66,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Water Heater Installation',
                'price' => 25.0,
                'provider_id' => 16,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/plumber/water_heater_installation_1.png'),
                'subcategory_id' => 24,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 09:39:36',
                'provider_address_mapping'=>[
                    [
                        'id' => 369,
                        'service_id' => 66,
                        'provider_address_id' => 27,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 370,
                        'service_id' => 66,
                        'provider_address_id' => 28,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 13,
                'created_at' => '2023-09-09 09:42:03',
                'deleted_at' => NULL,
                'description' => 'Maintain a safe work environment. Our office sanitization service covers workstations, common areas, and high-traffic zones, ensuring your employees\' well-being. 😷🚿🧴',
                'discount' => 4.0,
                'duration' => '00:10',
                'id' => 67,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Office Sanitization',
                'price' => 27.0,
                'provider_id' => 13,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/sanitization/office_sanitization_1.png'),
                'subcategory_id' => 28,
                'type' => 'hourly',
                'updated_at' => '2023-09-09 09:42:03',
                'provider_address_mapping'=>[
                    [
                        'id' => 372,
                        'service_id' => 67,
                        'provider_address_id' => 22,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 12,
                'created_at' => '2023-09-09 09:45:26',
                'deleted_at' => NULL,
                'description' => 'Protect your home. Our security personnel provide regular patrols and surveillance, deterring potential threats to your residential property. 👮🏻‍♀️',
                'discount' => 0.0,
                'duration' => '00:30',
                'id' => 68,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Residential Security Patrol',
                'price' => 41.0,
                'provider_id' => 15,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/security_guard/residential_security_patrol.png'),
                'subcategory_id' => 29,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 09:45:26',
                'provider_address_mapping'=>[
                    [
                        'id' => 373,
                        'service_id' => 68,
                        'provider_address_id' => 25,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 374,
                        'service_id' => 68,
                        'provider_address_id' => 26,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 11,
                'created_at' => '2023-09-09 09:50:08',
                'deleted_at' => NULL,
                'description' => 'Secure your home with ease. Our experts install smart locks that provide convenient keyless entry and allow you to manage access remotely. 🖥️',
                'discount' => 0.0,
                'duration' => '00:25',
                'id' => 69,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Smart Lock Installation',
                'price' => 16.0,
                'provider_id' => 12,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/smart_home/smart_lock_installation_1.png'),
                'subcategory_id' => 31,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 09:50:08',
                'provider_address_mapping'=>[
                    [
                        'id' => 375,
                        'service_id' => 69,
                        'provider_address_id' => 20,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 376,
                        'service_id' => 69,
                        'provider_address_id' => 21,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 27,
                'created_at' => '2023-09-09 09:53:06',
                'deleted_at' => NULL,
                'description' => 'Discover the essence of modern fashion with our Contemporary Style Clothing. Embrace chic and trend-setting designs that reflect the spirit of today\'s fashion, offering you both elegance and individuality. 🧥🥻👔👚',
                'discount' => 0.0,
                'duration' => '00:30',
                'id' => 70,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Contemporary Style Clothing',
                'price' => 26.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/tailor/contemporary_style_clothing_1.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 09:53:06',
                'provider_address_mapping'=>[
                    [
                        'id' => 377,
                        'service_id' => 70,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 378,
                        'service_id' => 70,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 379,
                        'service_id' => 70,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 380,
                        'service_id' => 70,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ],
                'visit_type' => 'online',
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 11,
                'created_at' => '2023-09-09 09:54:45',
                'deleted_at' => NULL,
                'description' => 'Safeguard your premises with our alarm system installation service. Our expert technicians strategically place sensors and detectors, creating a comprehensive security net that alerts you instantly in case of unauthorized access or emergencies. 🖲️',
                'discount' => 2.0,
                'duration' => '00:40',
                'id' => 71,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Alarm System Installation',
                'price' => 45.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/smart_home/alarm_system_installation_1.png'),
                'subcategory_id' => 42,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 09:54:45',
                'provider_address_mapping'=>[
                    [
                        'id' => 381,
                        'service_id' => 71,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 382,
                        'service_id' => 71,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 383,
                        'service_id' => 71,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 384,
                        'service_id' => 71,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 385,
                        'service_id' => 71,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 386,
                        'service_id' => 71,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 387,
                        'service_id' => 71,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 388,
                        'service_id' => 71,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 13,
                'created_at' => '2023-09-09 09:56:45',
                'deleted_at' => NULL,
                'description' => 'Ensure a clean dining experience. Our experts sanitize dining areas and food preparation zones, adhering to high hygiene standards for your customers\' health. 🧽🧼🧴',
                'discount' => 10.0,
                'duration' => '00:15',
                'id' => 72,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Restaurant and Cafe Sanitization',
                'price' => 50.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/sanitization/restaurant_and_cafe_sanitization_1.png'),
                'subcategory_id' => 27,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 09:56:45',
                'provider_address_mapping'=>[
                    [
                        'id' => 389,
                        'service_id' => 72,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 390,
                        'service_id' => 72,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 391,
                        'service_id' => 72,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 392,
                        'service_id' => 72,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 15,
                'created_at' => '2023-09-09 09:58:19',
                'deleted_at' => NULL,
                'description' => 'Relive your special day. Our wedding photographers artistically capture every emotion and detail, preserving the magic of your wedding. 📸📹',
                'discount' => 0.0,
                'duration' => '00:40',
                'id' => 73,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Wedding Photography',
                'price' => 16.0,
                'provider_id' => 16,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/photography/wedding_photography_1.png'),
                'subcategory_id' => 22,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 09:58:19',
                'provider_address_mapping'=>[
                    [
                        'id' => 393,
                        'service_id' => 73,
                        'provider_address_id' => 27,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 394,
                        'service_id' => 73,
                        'provider_address_id' => 28,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 27,
                'created_at' => '2023-09-09 09:59:46',
                'deleted_at' => NULL,
                'description' => 'Handle with care. Our experts clean delicate fabrics, preserving their quality and extending their lifespan. 👗👘🧥🥻👔',
                'discount' => NULL,
                'duration' => '00:10',
                'id' => 74,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Delicate Garment Cleaning',
                'price' => 45.0,
                'provider_id' => 7,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/laundry/delicate_garment_cleaning_1.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 09:59:46',
                'provider_address_mapping'=>[
                    [
                        'id' => 396,
                        'service_id' => 74,
                        'provider_address_id' => 13,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                    ],
                'visit_type' => 'online',
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 18,
                'created_at' => '2023-09-09 10:02:27',
                'deleted_at' => NULL,
                'description' => 'Boost curb appeal. Our exterior painting service revitalizes your home/building\'s facade, protecting it from the elements while enhancing its beauty. 🖌️🧑🏻‍🎨',
                'discount' => 4.0,
                'duration' => '0:25',
                'id' => 75,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Whole House/Building Exterior Painting',
                'price' => 23.0,
                'provider_id' => 12,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/painter/whole_house_building_exterior_painting_1.png'),
                'subcategory_id' => 16,
                'type' => 'fixed',
                'updated_at' => '2023-10-06 11:43:19',
                'provider_address_mapping'=>[
                    [
                        'id' => 843,
                        'service_id' => 75,
                        'provider_address_id' => 21,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 844,
                        'service_id' => 75,
                        'provider_address_id' => 20,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 19,
                'created_at' => '2023-09-09 10:03:55',
                'deleted_at' => NULL,
                'description' => 'Preserve luxury fabrics. We provide meticulous dry cleaning for silk and designer garments, keeping them looking impeccable. 🧥🥻👔👚',
                'discount' => 5.0,
                'duration' => '00:15',
                'id' => 76,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Silk and Designer Garment Care',
                'price' => 35.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/laundry/silk_and_designer_garment_care.png'),
                'subcategory_id' => 38,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:03:55',
                'provider_address_mapping'=>[
                    [
                        'id' => 399,
                        'service_id' => 76,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 400,
                        'service_id' => 76,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 401,
                        'service_id' => 76,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 402,
                        'service_id' => 76,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 18,
                'created_at' => '2023-09-09 10:06:09',
                'deleted_at' => NULL,
                'description' => 'Enrich your environment. We craft murals and wall art, transforming blank spaces into captivating scenes that reflect your style, passions, or brand identity. 🧑🏻‍🎨🖌️🎨',
                'discount' => 1.0,
                'duration' => '00:20',
                'id' => 77,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Murals and Wall Art',
                'price' => 32.0,
                'provider_id' => 13,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/painter/murals_and_wall_art.png'),
                'subcategory_id' => 36,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:06:09',
                'provider_address_mapping'=>[
                    [
                        'id' => 403,
                        'service_id' => 77,
                        'provider_address_id' => 22,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 14,
                'created_at' => '2023-09-09 10:08:56',
                'deleted_at' => NULL,
                'description' => 'Express your style. Our nail artists create intricate designs and patterns, adding a unique and artistic touch to your nails. 💅🏼',
                'discount' => 2.0,
                'duration' => '00:25',
                'id' => 78,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Nail Art',
                'price' => 37.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/salon/nail_art_1.png'),
                'subcategory_id' => 43,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:08:56',
                'provider_address_mapping'=>[
                    [
                        'id' => 404,
                        'service_id' => 78,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 405,
                        'service_id' => 78,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 406,
                        'service_id' => 78,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 407,
                        'service_id' => 78,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 408,
                        'service_id' => 78,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 409,
                        'service_id' => 78,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 410,
                        'service_id' => 78,
                        'provider_address_id' => 7,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 411,
                        'service_id' => 78,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 412,
                    //     'service_id' => 78,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 413,
                        'service_id' => 78,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 414,
                        'service_id' => 78,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 27,
                'created_at' => '2023-09-09 10:11:40',
                'deleted_at' => NULL,
                'description' => 'Elevate your artwork and memories with our Custom Frame Painting service. Our skilled painters meticulously paint frames to match your chosen color scheme or complement the artwork, adding a personalized touch to your decor. 🧑🏻‍🎨🖌️🎨',
                'discount' => 0.0,
                'duration' => '00:10',
                'id' => 79,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Custom Frame Painting',
                'price' => 12.0,
                'provider_id' => 17,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/painter/custom_frame_painting.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:11:40',
                'provider_address_mapping'=>[
                    [
                        'id' => 415,
                        'service_id' => 79,
                        'provider_address_id' => 29,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 416,
                        'service_id' => 79,
                        'provider_address_id' => 30,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ],
                'visit_type' => 'online',
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 19,
                'created_at' => '2023-09-09 10:12:43',
                'deleted_at' => NULL,
                'description' => 'Step out in elegance. Our experts dry clean formal attire, ensuring you make a stunning impression at special events.',
                'discount' => 7.0,
                'duration' => '00:35',
                'id' => 80,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Evening Gown and Formal Attire Cleaning',
                'price' => 28.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/laundry/evening_gown_and_formal_attire_cleaning_1.png'),
                'subcategory_id' => 38,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:12:43',
                'provider_address_mapping'=>[
                    [
                        'id' => 417,
                        'service_id' => 80,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 418,
                        'service_id' => 80,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 419,
                        'service_id' => 80,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 420,
                        'service_id' => 80,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 421,
                        'service_id' => 80,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 422,
                        'service_id' => 80,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 27,
                'created_at' => '2023-09-09 10:14:24',
                'deleted_at' => NULL,
                'description' => 'Create cohesive gallery walls with our Multi-Frame Set Painting. Our team paints multiple frames to match, allowing you to curate a unified display that showcases your artwork or photographs beautifully. 🧑🏻‍🎨🖌️🎨',
                'discount' => 4.0,
                'duration' => '00:30',
                'id' => 81,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Multi Frame Set Painting',
                'price' => 38.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/painter/multi_frame_set_painting_1.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:14:24',
                'provider_address_mapping'=>[
                    [
                        'id' => 423,
                        'service_id' => 81,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 424,
                        'service_id' => 81,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 425,
                        'service_id' => 81,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 426,
                        'service_id' => 81,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 427,
                        'service_id' => 81,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 428,
                        'service_id' => 81,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ],
                'visit_type' => 'online'
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 15,
                'created_at' => '2023-09-09 10:16:55',
                'deleted_at' => NULL,
                'description' => 'Document your corporate events professionally. Our photographers capture the ambiance and key moments, creating impactful visuals for your business. 📸📹',
                'discount' => 5.0,
                'duration' => '00:50',
                'id' => 82,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Corporate Event Photography',
                'price' => 36.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/photography/corporate_event_photography_1.png'),
                'subcategory_id' => 22,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:16:55',
                'provider_address_mapping'=>[
                    [
                        'id' => 429,
                        'service_id' => 82,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 430,
                        'service_id' => 82,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 431,
                        'service_id' => 82,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 432,
                        'service_id' => 82,
                        'provider_address_id' => 7,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 433,
                        'service_id' => 82,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 16,
                'created_at' => '2023-09-09 10:18:29',
                'deleted_at' => NULL,
                'description' => 'Prevent pest breeding grounds with Drainage System Pest Management. Our experts optimize drainage systems, eliminating standing water and preventing pest attraction and reproduction.🧴🚿',
                'discount' => 2.0,
                'duration' => '00:15',
                'id' => 83,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Drainage System Pest Management',
                'price' => 42.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/pest_control/drainage_system_pest_management_1.png'),
                'subcategory_id' => 20,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:18:29',
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 17,
                'created_at' => '2023-09-09 10:19:39',
                'deleted_at' => NULL,
                'description' => 'Discover compatibility factors. Our astrologers assess relationship dynamics, providing insights to foster harmonious connections. 🔯',
                'discount' => 4.0,
                'duration' => '00:20',
                'id' => 84,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Relationship Compatibility Reading',
                'price' => 36.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/pandit/relationship_compatibility_reading.png'),
                'subcategory_id' => 18,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:19:39',
                'provider_address_mapping'=>[
                    [
                        'id' => 434,
                        'service_id' => 84,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 435,
                        'service_id' => 84,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 436,
                        'service_id' => 84,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 437,
                        'service_id' => 84,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 25,
                'created_at' => '2023-09-09 10:21:35',
                'deleted_at' => NULL,
                'description' => 'Our troubleshooting experts quickly diagnose faults, ensuring your systems are up and running smoothly.  🔩🔧🪛🧑🏻‍🔧',
                'discount' => 0.0,
                'duration' => '00:20',
                'id' => 85,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Fault Diagnosis',
                'price' => 25.0,
                'provider_id' => 16,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/electrician/fault_diagnosis_1.png'),
                'subcategory_id' => 46,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:21:35',
                'provider_address_mapping'=>[
                    [
                        'id' => 438,
                        'service_id' => 85,
                        'provider_address_id' => 27,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 439,
                        'service_id' => 85,
                        'provider_address_id' => 28,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 20,
                'created_at' => '2023-09-09 10:23:09',
                'deleted_at' => NULL,
                'description' => 'Sculpt your garden. Our skilled gardeners perform careful pruning and trimming to enhance plant health and shape. 🌲🪴⛏️🪓',
                'discount' => 5.0,
                'duration' => '00:25',
                'id' => 86,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Pruning and Trimming',
                'price' => 28.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/gardener/pruning_and_trimming_1.png'),
                'subcategory_id' => 14,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:23:09',
                'provider_address_mapping'=>[
                    [
                        'id' => 440,
                        'service_id' => 86,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 441,
                        'service_id' => 86,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 442,
                        'service_id' => 86,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 444,
                        'service_id' => 86,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 445,
                        'service_id' => 86,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 23,
                'created_at' => '2023-09-09 10:25:09',
                'deleted_at' => NULL,
                'description' => 'Clear sewer line blockages. Our experts provide thorough cleaning to ensure proper sewage flow and prevent backups. 🧑🏻‍🔧🪠🔩🔧',
                'discount' => 3.0,
                'duration' => '00:25',
                'id' => 87,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Sewer Line Cleaning',
                'price' => 27.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/plumber/leak_repair_1.jpg'),
                'subcategory_id' => 44,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:25:09',
                'provider_address_mapping'=>[
                    [
                        'id' => 446,
                        'service_id' => 87,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 447,
                        'service_id' => 87,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 448,
                        'service_id' => 87,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 449,
                        'service_id' => 87,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 450,
                        'service_id' => 87,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 27,
                'created_at' => '2023-09-09 10:27:14',
                'deleted_at' => NULL,
                'description' => 'Look your best for special events. Our hairstylists create stunning updos and styles that complement your outfit and occasion. 💇🏻 💆🏻‍♀️',
                'discount' => 5.0,
                'duration' => '00:40',
                'id' => 88,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Special Occasion Styling',
                'price' => 30.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/salon/special_occasion_styling_1.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:27:14',
                'provider_address_mapping'=>[
                    [
                        'id' => 451,
                        'service_id' => 88,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 452,
                        'service_id' => 88,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 453,
                        'service_id' => 88,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 454,
                        'service_id' => 88,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 455,
                        'service_id' => 88,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 456,
                        'service_id' => 88,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ],
                'visit_type' => 'online',
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 13,
                'created_at' => '2023-09-09 10:29:08',
                'deleted_at' => NULL,
                'description' => 'Enjoy a clean outdoor space. Our specialized service sanitizes outdoor areas, such as patios and play areas, creating a safe environment for outdoor activities. 🧴🚿',
                'discount' => 3.0,
                'duration' => '00:35',
                'id' => 89,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Outdoor Area Sanitization',
                'price' => 34.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/sanitization/outdoor_area_sanitization_1.png'),
                'subcategory_id' => 35,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:29:08',
                'provider_address_mapping'=>[
                    [
                        'id' => 807,
                        'service_id' => 89,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 808,
                        'service_id' => 89,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 809,
                        'service_id' => 89,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 810,
                        'service_id' => 89,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 811,
                        'service_id' => 89,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 12,
                'created_at' => '2023-09-09 10:30:12',
                'deleted_at' => NULL,
                'description' => 'Secure business premises. Our trained guards monitor access, ensuring the safety of employees, customers, and assets. 👮🏻‍♀️',
                'discount' => 0.0,
                'duration' => '00:20',
                'id' => 90,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Commercial Building Security',
                'price' => 42.0,
                'provider_id' => 17,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/security_guard/commercial_building_security.png'),
                'subcategory_id' => 30,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:30:12',
                'provider_address_mapping'=>[
                    [
                        'id' => 462,
                        'service_id' => 90,
                        'provider_address_id' => 29,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 463,
                        'service_id' => 90,
                        'provider_address_id' => 30,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 18,
                'created_at' => '2023-09-09 10:33:05',
                'deleted_at' => NULL,
                'description' => 'Personalize your spaces. Our painters use intricate stenciling techniques to apply custom designs, patterns, or motifs, making your interiors unique and visually appealing. 🧑🏻‍🎨🖌️🎨',
                'discount' => 2.0,
                'duration' => '00:30',
                'id' => 91,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Custom Stenciling',
                'price' => 26.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/painter/custom_stenciling_1.png'),
                'subcategory_id' => 36,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:33:05',
                'provider_address_mapping'=>[
                    [
                        'id' => 464,
                        'service_id' => 91,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 465,
                        'service_id' => 91,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 466,
                        'service_id' => 91,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 467,
                    //     'service_id' => 91,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 468,
                        'service_id' => 91,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 19,
                'created_at' => '2023-09-09 10:34:31',
                'deleted_at' => NULL,
                'description' => 'Maintain your leather\'s allure. Our experts clean and care for leather and suede items, ensuring their longevity and appearance. 🧼🧥',
                'discount' => 2.0,
                'duration' => '00:30',
                'id' => 92,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Leather and Suede Cleaning',
                'price' => 20.0,
                'provider_id' => 7,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/laundry/leather_and_suede_cleaning_1.png'),
                'subcategory_id' => 37,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:34:31',
                'provider_address_mapping'=>[
                    [
                        'id' => 469,
                        'service_id' => 92,
                        'provider_address_id' => 13,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => 10.0,
                'category_id' => 9,
                'created_at' => '2023-09-09 10:35:39',
                'deleted_at' => NULL,
                'description' => 'Experience optimal airflow. Our experts identify and eliminate airflow restrictions, restoring balanced and effective cooling. 🔩🔧🧑🏻‍🔧',
                'discount' => 3.0,
                'duration' => '00:25',
                'id' => 93,
                'is_enable_advance_payment' => 1,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Airflow Problem Identification',
                'price' => 35.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/ac_coolcare/airflow_problem_identification.png'),
                'subcategory_id' => 49,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:35:39',
                'provider_address_mapping'=>[
                    [
                        'id' => 475,
                        'service_id' => 93,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 476,
                        'service_id' => 93,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 477,
                    //     'service_id' => 93,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 478,
                        'service_id' => 93,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 479,
                        'service_id' => 93,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 14,
                'created_at' => '2023-09-09 10:38:35',
                'deleted_at' => NULL,
                'description' => 'Our skilled stylists provide personalized haircuts and styling to match your preferences, leaving you with a fresh and fashionable look. 💇🏻',
                'discount' => 0.0,
                'duration' => '00:30',
                'id' => 94,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Haircut and Styling',
                'price' => 34.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/salon/haircut_and_styling_1.png'),
                'subcategory_id' => 25,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:38:35',
                'provider_address_mapping'=>[
                    [
                        'id' => 486,
                        'service_id' => 94,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 487,
                        'service_id' => 94,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 488,
                        'service_id' => 94,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 489,
                    //     'service_id' => 94,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 490,
                        'service_id' => 94,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 491,
                        'service_id' => 94,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 27,
                'created_at' => '2023-09-09 10:40:06',
                'deleted_at' => NULL,
                'description' => 'Travel with peace of mind. Our professionals sanitize car interiors, ensuring a clean and hygienic environment for your journeys.  🧴🚿',
                'discount' => 0.0,
                'duration' => '00:20',
                'id' => 95,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Car Interior Sanitization',
                'price' => 15.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/sanitization/car_interior_sanitization_1.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:40:06',
                'provider_address_mapping'=>[
                    [
                        'id' => 492,
                        'service_id' => 95,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 493,
                        'service_id' => 95,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 494,
                        'service_id' => 95,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 495,
                        'service_id' => 95,
                        'provider_address_id' => 7,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 496,
                    //     'service_id' => 95,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 497,
                        'service_id' => 95,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ],
                'visit_type' => 'online',
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 14,
                'created_at' => '2023-09-09 10:41:21',
                'deleted_at' => NULL,
                'description' => 'Indulge in pampering perfection with our Manicure & Pedicure services. Our skilled technicians ensure your hands and feet receive meticulous care, leaving them refreshed and rejuvenated. 💅🏼',
                'discount' => 0.0,
                'duration' => '00:20',
                'id' => 96,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Manicure & Pedicure',
                'price' => 26.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/salon/manicure_and_pedicure_1.png'),
                'subcategory_id' => 43,
                'type' => 'hourly',
                'updated_at' => '2023-09-09 10:41:21',
                'provider_address_mapping'=>[
                    [
                        'id' => 503,
                        'service_id' => 96,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 504,
                        'service_id' => 96,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 505,
                        'service_id' => 96,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 506,
                        'service_id' => 96,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 507,
                        'service_id' => 96,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 9,
                'created_at' => '2023-09-09 10:43:10',
                'deleted_at' => NULL,
                'description' => 'Efficient cooling restored. Our experts skillfully repair compressors, bringing back optimal cooling power to your AC unit. 👨🏻‍🔧🔩🔧🪛',
                'discount' => 0.0,
                'duration' => '00:25',
                'id' => 97,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Compressor Fix',
                'price' => 39.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/ac_coolcare/compressor_fix.png'),
                'subcategory_id' => 49,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:43:10',
                'provider_address_mapping'=>[
                    [
                        'id' => 508,
                        'service_id' => 97,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 509,
                        'service_id' => 97,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 510,
                        'service_id' => 97,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 511,
                        'service_id' => 97,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 512,
                        'service_id' => 97,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 11,
                'created_at' => '2023-09-09 10:51:33',
                'deleted_at' => NULL,
                'description' => 'Keep an eye on your property anytime, anywhere. Our service includes the installation of smart security cameras for comprehensive surveillance and peace of mind. 🖲️',
                'discount' => 0.0,
                'duration' => '00:20',
                'id' => 98,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Security Camera Setup',
                'price' => 24.0,
                'provider_id' => 12,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/smart_home/security_camera_setup_1.png'),
                'subcategory_id' => 32,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:51:33',
                'provider_address_mapping'=>[
                    [
                        'id' => 513,
                        'service_id' => 98,
                        'provider_address_id' => 20,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 514,
                        'service_id' => 98,
                        'provider_address_id' => 21,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 25,
                'created_at' => '2023-09-09 10:55:09',
                'deleted_at' => NULL,
                'description' => 'Restore circuit functionality. Our skilled electricians repair circuit issues, preventing disruptions and ensuring safety. 🔧🪛🛠️',
                'discount' => 0.0,
                'duration' => '00:20',
                'id' => 99,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Circuit Repair',
                'price' => 15.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/electrician/circuit_repair_1.png'),
                'subcategory_id' => 46,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:55:09',
                'provider_address_mapping'=>[
                    [
                        'id' => 515,
                        'service_id' => 99,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 516,
                        'service_id' => 99,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 517,
                        'service_id' => 99,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 518,
                        'service_id' => 99,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 519,
                        'service_id' => 99,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 27,
                'created_at' => '2023-09-09 10:56:40',
                'deleted_at' => NULL,
                'description' => 'Add an artistic flair to your frames with our Artistic Frame Design service. Collaborate with our designers to create unique patterns, motifs, or intricate designs that transform your frames into captivating visual elements. 🧑🏻‍🎨🖌️🎨',
                'discount' => 0.0,
                'duration' => '00:20',
                'id' => 100,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Artistic Frame Designer',
                'price' => 37.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/painter/artistic_frame_design_1.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-10-06 06:41:54',
                'provider_address_mapping'=>[
                    [
                        'id' => 836,
                        'service_id' => 100,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 837,
                        'service_id' => 100,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 838,
                        'service_id' => 100,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 839,
                        'service_id' => 100,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 840,
                        'service_id' => 100,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ],
                'visit_type' => 'online',
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 23,
                'created_at' => '2023-09-09 10:57:59',
                'deleted_at' => NULL,
                'description' => 'Our skilled plumbers fix leaks promptly, preventing water wastage and potential water damage. 🧑🏻‍🔧🔧🪛',
                'discount' => 0.0,
                'duration' => '00:30',
                'id' => 101,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Leak Repair',
                'price' => 35.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/plumber/leak_repair_2.png'),
                'subcategory_id' => 23,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:57:59',
                'provider_address_mapping'=>[
                    [
                        'id' => 525,
                        'service_id' => 101,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 526,
                        'service_id' => 101,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 527,
                        'service_id' => 101,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 528,
                    //     'service_id' => 101,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 529,
                        'service_id' => 101,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 14,
                'created_at' => '2023-09-09 10:59:16',
                'deleted_at' => NULL,
                'description' => 'Renew your skin\'s glow. Our exfoliation and peel treatments remove dead skin cells, revealing smoother and more youthful skin. 🧖‍♀️',
                'discount' => 0.0,
                'duration' => '00:20',
                'id' => 102,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Exfoliation and Peels',
                'price' => 28.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/salon/exfoliation_and_peels_1.png'),
                'subcategory_id' => 26,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 10:59:16',
                'provider_address_mapping'=>[
                    [
                        'id' => 640,
                        'service_id' => 102,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 641,
                        'service_id' => 102,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 642,
                        'service_id' => 102,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 643,
                        'service_id' => 102,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 644,
                        'service_id' => 102,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 645,
                        'service_id' => 102,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 11,
                'created_at' => '2023-09-09 12:15:16',
                'deleted_at' => NULL,
                'description' => 'Streamlined entertainment. Our professionals integrate smart TVs, making it easy to access your favorite shows, movies, and streaming services. 🧑🏻‍🔧📺',
                'discount' => 0.0,
                'duration' => '00:25',
                'id' => 103,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Smart TV Integration',
                'price' => 25.0,
                'provider_id' => 15,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/smart_home/smart_tv_integration_1.png'),
                'subcategory_id' => 32,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 12:15:16',
                'provider_address_mapping'=>[
                    [
                        'id' => 638,
                        'service_id' => 103,
                        'provider_address_id' => 25,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 639,
                        'service_id' => 103,
                        'provider_address_id' => 26,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 10,
                'created_at' => '2023-09-09 12:17:16',
                'deleted_at' => NULL,
                'description' => 'Restore and strengthen seams for extended garment life. Our tailors skillfully mend and reinforce stitching. 🪡🧵👗🥻',
                'discount' => 0.0,
                'duration' => '00:25',
                'id' => 104,
                'is_enable_advance_payment' => 0,
                'is_featured' => 1,
                'is_slot' => 0,
                'name' => 'Seam Repair and Reinforcement',
                'price' => 45.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/tailor/seam_repair_and_reinforcement_1.png'),
                'subcategory_id' => 33,
                'type' => 'hourly',
                'updated_at' => '2023-09-09 12:18:02',
                'provider_address_mapping'=>[
                    [
                        'id' => 722,
                        'service_id' => 104,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 723,
                        'service_id' => 104,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 724,
                        'service_id' => 104,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 725,
                        'service_id' => 104,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 726,
                        'service_id' => 104,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 22,
                'created_at' => '2023-09-09 12:20:50',
                'deleted_at' => NULL,
                'description' => 'Expert bakers create bespoke cakes for special occasions, turning your ideas into delicious reality. 🍰🧁🥧',
                'discount' => 4.0,
                'duration' => '00:25',
                'id' => 105,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Custom Cake Creations',
                'price' => 35.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cooking/custom_cake_creations_1.png'),
                'subcategory_id' => 45,
                'type' => 'hourly',
                'updated_at' => '2023-09-09 12:20:50',
                'provider_address_mapping'=>[
                    [
                        'id' => 666,
                        'service_id' => 105,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 667,
                        'service_id' => 105,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 668,
                        'service_id' => 105,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 669,
                        'service_id' => 105,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 670,
                        'service_id' => 105,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 671,
                        'service_id' => 105,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    // [
                    //     'id' => 672,
                    //     'service_id' => 105,
                    //     'provider_address_id' => 9,
                    //     'created_at' => NULL,
                    //     'updated_at' => NULL,
                    // ],
                    [
                        'id' => 673,
                        'service_id' => 105,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 25,
                'created_at' => '2023-09-09 12:22:25',
                'deleted_at' => NULL,
                'description' => 'Our skilled electricians ensure safe and efficient wiring installation, powering your space with precision and reliability. 🧑🏻‍🔧🔧🪛🛠️',
                'discount' => 2.0,
                'duration' => '00:20',
                'id' => 106,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Electrical Wiring Installation',
                'price' => 26.0,
                'provider_id' => 15,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/electrician/electrical_wiring_installation_1.png'),
                'subcategory_id' => 11,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 12:22:25',
                'provider_address_mapping'=>[
                    [
                        'id' => 674,
                        'service_id' => 106,
                        'provider_address_id' => 25,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 675,
                        'service_id' => 106,
                        'provider_address_id' => 26,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => 2.0,
                'category_id' => 24,
                'created_at' => '2023-09-09 12:30:23',
                'deleted_at' => NULL,
                'description' => 'Maintain a productive workspace with our office cleaning service. Our professional cleaners ensure your office is organized, sanitized, and conducive to a positive working environment. 🧽🧼',
                'discount' => 0.0,
                'duration' => '00:30',
                'id' => 107,
                'is_enable_advance_payment' => 1,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Office Cleaning',
                'price' => 32.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/cleaning/office_cleaning_1.png'),
                'subcategory_id' => 7,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 12:31:43',
                'provider_address_mapping'=>[
                    [
                        'id' => 683,
                        'service_id' => 107,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 684,
                        'service_id' => 107,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 685,
                        'service_id' => 107,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 686,
                        'service_id' => 107,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 687,
                        'service_id' => 107,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 688,
                        'service_id' => 107,
                        'provider_address_id' => 8,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 689,
                        'service_id' => 107,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 23,
                'created_at' => '2023-09-09 12:33:14',
                'deleted_at' => NULL,
                'description' => 'Upgrade your fixtures with ease. Our plumbers install faucets, sinks, and other fixtures, enhancing functionality and aesthetics. 🧑🏻‍🔧🔧🪛',
                'discount' => 2.0,
                'duration' => '00:25',
                'id' => 108,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Fixture Installation',
                'price' => 18.0,
                'provider_id' => 15,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/plumber/fixture_installation_1.png'),
                'subcategory_id' => 24,
                'type' => 'hourly',
                'updated_at' => '2023-09-09 12:40:23',
                'provider_address_mapping'=>[
                    [
                        'id' => 710,
                        'service_id' => 108,
                        'provider_address_id' => 25,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 711,
                        'service_id' => 108,
                        'provider_address_id' => 26,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 13,
                'created_at' => '2023-09-09 12:35:01',
                'deleted_at' => NULL,
                'description' => 'Ensure your living space is germ-free. Our professionals perform a thorough sanitization of your entire home, targeting surfaces and areas to promote a clean and safe environment. 🧴',
                'discount' => 0.0,
                'duration' => '0:25',
                'id' => 109,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 1,
                'name' => 'Full Home Sanitization',
                'price' => 43.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/sanitization/full_home_sanitization_1.png'),
                'subcategory_id' => 27,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 12:35:44',
                'provider_address_mapping'=>[
                    [
                        'id' => 698,
                        'service_id' => 109,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 699,
                        'service_id' => 109,
                        'provider_address_id' => 10,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 700,
                        'service_id' => 109,
                        'provider_address_id' => 6,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 701,
                        'service_id' => 109,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 702,
                        'service_id' => 109,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 1,
                'advance_payment_amount' => NULL,
                'category_id' => 9,
                'created_at' => '2023-09-09 12:38:33',
                'deleted_at' => NULL,
                'description' => 'Breathe clean air. We promptly replace filters, improving air quality and ensuring efficient circulation throughout your space. 🔩🧑🏻‍🔧🔧🪛',
                'discount' => 0.0,
                'duration' => '00:30',
                'id' => 110,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Filter Replacement',
                'price' => 15.0,
                'provider_id' => 4,
                'service_type' => 'service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/ac_coolcare/filter_replacement.png'),
                'subcategory_id' => 2,
                'type' => 'fixed',
                'updated_at' => '2023-09-09 12:38:33',
                'provider_address_mapping'=>[
                    [
                        'id' => 703,
                        'service_id' => 110,
                        'provider_address_id' => 1,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 704,
                        'service_id' => 110,
                        'provider_address_id' => 2,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 705,
                        'service_id' => 110,
                        'provider_address_id' => 3,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 706,
                        'service_id' => 110,
                        'provider_address_id' => 4,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 707,
                        'service_id' => 110,
                        'provider_address_id' => 5,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 708,
                        'service_id' => 110,
                        'provider_address_id' => 7,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ],
                    [
                        'id' => 709,
                        'service_id' => 110,
                        'provider_address_id' => 31,
                        'created_at' => NULL,
                        'updated_at' => NULL,
                    ]
                ]
            ],
            [
                'added_by' => 44,
                'advance_payment_amount' => NULL,
                'category_id' => 14,
                'created_at' => '2023-09-11 10:37:55',
                'deleted_at' => NULL,
                'description' => 'Elevate your beauty with our Face Care service. Experience rejuvenation and radiance through personalized skincare treatments. 🧖‍♀️',
                'discount' => NULL,
                'duration' => '0',
                'id' => 111,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Face Care',
                'price' => 0.0,
                'provider_id' => 44,
                'service_type' => 'user_post_service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/post-job/face_message.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-09-11 10:37:55',
            ],
            [
                'added_by' => 47,
                'advance_payment_amount' => NULL,
                'category_id' => 20,
                'created_at' => '2023-09-11 10:53:47',
                'deleted_at' => NULL,
                'description' => 'Elevate your surroundings with our Tree Plantation service. We specialize in nurturing green landscapes and contributing to a healthier environment. 🌲🪴🥀🌻',
                'discount' => NULL,
                'duration' => '0',
                'id' => 112,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Tree Plantation',
                'price' => 0.0,
                'provider_id' => 47,
                'service_type' => 'user_post_service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/post-job/green_plant_creation.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-09-11 10:53:47',
            ],
            // [
            //     'added_by' => 49,
            //     'advance_payment_amount' => NULL,
            //     'category_id' => 22,
            //     'created_at' => '2023-10-02 13:50:05',
            //     'deleted_at' => '2023-10-02 13:52:30',
            //     'description' => 'Experience the enchantment of delightful confections with our Macaron Magic Makers service. Our skilled artisans craft these sweet masterpieces, combining artistry and flavors to create moments of pure indulgence. ??',
            //     'discount' => NULL,
            //     'duration' => '0',
            //     'id' => 113,
            //     'is_enable_advance_payment' => 0,
            //     'is_featured' => 0,
            //     'is_slot' => 0,
            //     'name' => 'Macaron Magic Makers',
            //     'price' => 0.0,
            //     'provider_id' => 49,
            //     'service_type' => 'user_post_service',
            //     'status' => 1,
            //     'service_attachment' => public_path('/images/services/cooking/daily_meals_preparation_1.png'),
            //     'subcategory_id' => NULL,
            //     'type' => 'fixed',
            //     'updated_at' => '2023-10-02 13:52:30',
            // ],
            [
                'added_by' => 49,
                'advance_payment_amount' => NULL,
                'category_id' => 22,
                'created_at' => '2023-10-02 13:52:22',
                'deleted_at' => NULL,
                'description' => 'Experience the enchantment of delightful confections with our Macaron Magic Makers service. Our skilled artisans craft these sweet masterpieces, combining artistry and flavors to create moments of pure indulgence. 🍩🍪',
                'discount' => NULL,
                'duration' => '0',
                'id' => 114,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Macaron Magic Makers',
                'price' => 0.0,
                'provider_id' => 49,
                'service_type' => 'user_post_service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/post-job/macaron_delights.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-10-02 13:52:22',
            ],
            [
                'added_by' => 3,
                'advance_payment_amount' => NULL,
                'category_id' => 14,
                'created_at' => '2023-10-02 13:55:04',
                'deleted_at' => NULL,
                'description' => 'Elevate your locks with our Hair Care service. Our skilled stylists provide tailored treatments and stylish cuts, leaving your hair refreshed, rejuvenated, and ready to make a statement. 🧖‍♀️',
                'discount' => NULL,
                'duration' => '0',
                'id' => 115,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Hair Care',
                'price' => 0.0,
                'provider_id' => 3,
                'service_type' => 'user_post_service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/post-job/hair_spa.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-10-02 13:55:04',
            ],
            [
                'added_by' => 3,
                'advance_payment_amount' => NULL,
                'category_id' => 9,
                'created_at' => '2023-10-02 13:56:03',
                'deleted_at' => NULL,
                'description' => 'Elevate your indoor comfort with our AC Clean Up service. Our experts ensure your air conditioning system is pristine and operating efficiently, providing you with cleaner, cooler air.🔩🧑🏻‍🔧',
                'discount' => NULL,
                'duration' => '0',
                'id' => 116,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'AC Clean Up',
                'price' => 0.0,
                'provider_id' => 3,
                'service_type' => 'user_post_service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/post-job/ac_refresh_and_revive.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-10-02 13:56:03',
            ],
            [
                'added_by' => 3,
                'advance_payment_amount' => NULL,
                'category_id' => 24,
                'created_at' => '2023-10-02 13:59:03',
                'deleted_at' => NULL,
                'description' => 'Experience the ultimate home transformation with our Complete Home Cleaning service. Our dedicated team leaves no corner untouched, ensuring a spotless and refreshed living space. 🧽🧼🧹🪣',
                'discount' => NULL,
                'duration' => '0',
                'id' => 117,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Complete Home Cleaning',
                'price' => 0.0,
                'provider_id' => 3,
                'service_type' => 'user_post_service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/post-job/ultimate_deep_cleaning.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-10-02 13:59:03',
            ],
            // [
            //     'added_by' => 3,
            //     'advance_payment_amount' => NULL,
            //     'category_id' => 26,
            //     'created_at' => '2023-10-02 14:02:29',
            //     'deleted_at' => '2023-10-03 05:22:44',
            //     'description' => 'Elevate your living spaces with our Interior Design service. Our talented designers create personalized environments that harmonize style, functionality, and comfort. ??‍?',
            //     'discount' => NULL,
            //     'duration' => '0',
            //     'id' => 118,
            //     'is_enable_advance_payment' => 0,
            //     'is_featured' => 0,
            //     'is_slot' => 0,
            //     'name' => 'Interior Design',
            //     'price' => 0.0,
            //     'provider_id' => 3,
            //     'service_type' => 'user_post_service',
            //     'status' => 1,
            //     'service_attachment' => public_path('/images/services/carpenter/wooden_chair_restoration_1.png'),
            //     'subcategory_id' => NULL,
            //     'type' => 'fixed',
            //     'updated_at' => '2023-10-03 05:22:44',
            // ],
            [
                'added_by' => 3,
                'advance_payment_amount' => NULL,
                'category_id' => 18,
                'created_at' => '2023-10-03 05:23:39',
                'deleted_at' => NULL,
                'description' => 'Elevate your living spaces with our Interior Design service. Our talented designers create personalized environments that harmonize style, functionality, and comfort. 🧑🏻‍🎨',
                'discount' => NULL,
                'duration' => '0',
                'id' => 119,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Interior Design',
                'price' => 0.0,
                'provider_id' => 3,
                'service_type' => 'user_post_service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/post-job/interior_elegance_creations.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-10-03 05:23:39',
            ],
            [
                'added_by' => 3,
                'advance_payment_amount' => NULL,
                'category_id' => 18,
                'created_at' => '2023-10-03 05:25:36',
                'deleted_at' => NULL,
                'description' => 'Transform your space with Canvas Artwork. Discover captivating and personalized art pieces that add elegance and character to your decor. 🧑🏻‍🎨🖌️🎨',
                'discount' => NULL,
                'duration' => '0',
                'id' => 120,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Canvas Artwork',
                'price' => 0.0,
                'provider_id' => 3,
                'service_type' => 'user_post_service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/post-job/celestial_artistry_on_canvas.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-10-03 05:25:36',
            ],
            // [
            //     'added_by' => 3,
            //     'advance_payment_amount' => NULL,
            //     'category_id' => 25,
            //     'created_at' => '2023-10-03 05:51:38',
            //     'deleted_at' => '2023-10-03 05:52:19',
            //     'description' => 'Get your electrical systems back in top shape with our Wire Repair service. Our skilled technicians ensure safe and efficient wire repairs, restoring functionality to your home or business. ???️',
            //     'discount' => NULL,
            //     'duration' => '0',
            //     'id' => 121,
            //     'is_enable_advance_payment' => 0,
            //     'is_featured' => 0,
            //     'is_slot' => 0,
            //     'name' => 'Wire Repair',
            //     'price' => 0.0,
            //     'provider_id' => 3,
            //     'service_type' => 'user_post_service',
            //     'status' => 1,
            //     'service_attachment' => public_path('/images/services/electrician/wiring_repair_1.png'),
            //     'subcategory_id' => NULL,
            //     'type' => 'fixed',
            //     'updated_at' => '2023-10-03 05:52:19',
            // ],
            [
                'added_by' => 3,
                'advance_payment_amount' => NULL,
                'category_id' => 25,
                'created_at' => '2023-10-03 05:53:21',
                'deleted_at' => NULL,
                'description' => 'Get your electrical systems back in top shape with our Wire Repair service. Our skilled technicians ensure safe and efficient wire repairs, restoring functionality to your home or business. 🔧🪛🛠️',
                'discount' => NULL,
                'duration' => '0',
                'id' => 122,
                'is_enable_advance_payment' => 0,
                'is_featured' => 0,
                'is_slot' => 0,
                'name' => 'Wire Repair',
                'price' => 0.0,
                'provider_id' => 3,
                'service_type' => 'user_post_service',
                'status' => 1,
                'service_attachment' => public_path('/images/services/post-job/electrical_wire_repair_solutions.png'),
                'subcategory_id' => NULL,
                'type' => 'fixed',
                'updated_at' => '2023-10-03 05:53:21',
            ],
        ];
        
        foreach ($data as $key => $val) {
            $featureImage = $val['service_attachment'] ?? null;
            $serviceData = Arr::except($val, ['provider_address_mapping','service_attachment']);
            $service = Service::create($serviceData);
            if (isset($featureImage)) {
                $this->attachFeatureImage($service, $featureImage);
            }
            
            if (isset($val['provider_address_mapping'])) {
                $addresses = $val['provider_address_mapping'];
                foreach($addresses as $addressData){
                    $address = new ProviderServiceAddressMapping($addressData);
                    $address->save();
                }
            }
        }
    }
    private function attachFeatureImage($model, $publicPath)
    {

        $file = new \Illuminate\Http\File($publicPath);

        $media = $model->addMedia($file)->preservingOriginal()->toMediaCollection('service_attachment');

        return $media;

    }
}