<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Arr;
use App\Models\ServiceProof;

class ServiceProofsTableSeeder extends Seeder
{

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        
            $data = [
                [
                'id' => 1,
                'title' => 'Leak Repair Success: Before & After ?️',
                'description' => 'Witness the transformation! ? No more leaks, just peace of mind. #LeakRepairSuccess',
                'service_id' => 101,
                'booking_id' => 209,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/ac-tune-up.png'),
                'created_at' => '2024-01-31 05:49:10',
                'updated_at' => '2024-01-31 05:49:10',
            ],
            [
                'id' => 2,
                'title' => 'Filter Replacement ?️ Service Proof',
                'description' => 'Successfully replaced filters, ensuring clean and efficient performance! #HandymanServices #FilterReplacement',
                'service_id' => 110,
                'booking_id' => 208,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/filter_relacement.png'),
                'created_at' => '2024-01-31 05:51:49',
                'updated_at' => '2024-01-31 05:51:49',
            ],
            [
                'id' => 3,
                'title' => 'Fresh Look Assurance ?',
                'description' => 'Your dapper haircut and styling transformation! ?‍♂️✂️ #NewLookConfidence',
                'service_id' => 94,
                'booking_id' => 207,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/new_look.png'),
                'created_at' => '2024-01-31 06:03:55',
                'updated_at' => '2024-01-31 06:03:55',
            ],
            [
                'id' => 4,
                'title' => 'Sparkling Elegance Assurance',
                'description' => 'Your Evening Gown and Formal Attire now shine like new! ✨? #EleganceRestored #ProfessionalCare',
                'service_id' => 80,
                'booking_id' => 203,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/elegance_restored.png'),
                'created_at' => '2024-01-31 06:05:47',
                'updated_at' => '2024-01-31 06:05:47',
            ],
            [
                'id' => 5,
                'title' => 'Sparkling Spaces Deluxe ?✨',
                'description' => 'Transformed kitchen and bathroom with our top-notch deep cleaning! #CleanSpaces #HappyCustomer',
                'service_id' => 35,
                'booking_id' => 202,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/clean_spaces.png'),
                'created_at' => '2024-01-31 06:08:28',
                'updated_at' => '2024-01-31 06:08:28',
            ],
            [
                'id' => 6,
                'title' => 'Satisfaction Guaranteed: Custom Cake Creations Delivered with Excellence!',
                'description' => '? Successfully transformed a vision into reality! #HappyCustomer #CraftedWithCare',
                'service_id' => 105,
                'booking_id' => 201,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/crafted_with_care.png'),
                'created_at' => '2024-01-31 06:10:22',
                'updated_at' => '2024-01-31 06:10:22',
            ],
            [
                'id' => 7,
                'title' => 'Revived Elegance: Wooden Chair Restoration ?',
                'description' => 'Transformed a tired wooden chair into a masterpiece! #WoodRestorationMagic ✨',
                'service_id' => 15,
                'booking_id' => 199,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/wood_restoration.png'),
                'created_at' => '2024-01-31 06:13:32',
                'updated_at' => '2024-01-31 06:13:32',
            ],
            [
                'id' => 8,
                'title' => 'Exquisite Transformation: Multi Frame Set Painting ?️',
                'description' => 'Revamped your space with a stunning Multi Frame Set Painting! #ArtisticRevival ?',
                'service_id' => 81,
                'booking_id' => 197,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/artistic_revival.png'),
                'created_at' => '2024-01-31 06:15:36',
                'updated_at' => '2024-01-31 06:15:36',
            ],
            [
                'id' => 9,
                'title' => 'Chinese Food Delight ??️',
                'description' => 'Completed kitchen repair for \'Chinese Food\' with precision and expertise! #HandymanMagic #SatisfiedCustomer',
                'service_id' => 26,
                'booking_id' => 195,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/chinese_food_delights.png'),
                'created_at' => '2024-01-31 06:20:48',
                'updated_at' => '2024-01-31 06:20:48',
            ],
            [
                'id' => 10,
                'title' => 'AC Compressor Fix ?',
                'description' => 'Successfully restored cool vibes! ❄️ #ACCompressorFix #HappyCustomer',
                'service_id' => 97,
                'booking_id' => 194,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/ac_compressor_fix.png'),
                'created_at' => '2024-01-31 06:23:15',
                'updated_at' => '2024-01-31 06:23:15',
            ],
            [
                'id' => 11,
                'title' => 'Sparkling Office Magic ✨?',
                'description' => 'Witness the transformation! ? Just completed top-notch \'Office Cleaning\' service for a spotless workspace. #CleanOffice #HappyCustomer',
                'service_id' => 107,
                'booking_id' => 193,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/clean_office.png'),
                'created_at' => '2024-01-31 06:25:56',
                'updated_at' => '2024-01-31 06:25:56',
            ],
            [
                'id' => 12,
                'title' => 'AC Filter Replacement Success!',
                'description' => 'Breath of fresh air restored! ?️ AC Filter Replacement completed successfully. #HappyCustomer',
                'service_id' => 110,
                'booking_id' => 190,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/fresh_air_restored.png'),
                'created_at' => '2024-01-31 06:28:26',
                'updated_at' => '2024-01-31 06:28:26',
            ],
            [
                'id' => 13,
                'title' => 'Seam Repair and Reinforcement Success!',
                'description' => 'Revived and reinforced your garment\'s seams! ?✨ #SeamMagic #ClothRepair',
                'service_id' => 104,
                'booking_id' => 191,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/seam_magic.png'),
                'created_at' => '2024-01-31 06:31:31',
                'updated_at' => '2024-01-31 06:31:31',
            ],
            [
                'id' => 14,
                'title' => '✨ AC Filter Replacement Success! ✨',
                'description' => 'AC filter replaced with precision. #HappyCustomer #HandymanMagic✨',
                'service_id' => 110,
                'booking_id' => 189,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/ac_filter_replacement.png'),
                'created_at' => '2024-01-31 06:34:03',
                'updated_at' => '2024-01-31 06:34:03',
            ],
            [
                'id' => 15,
                'title' => 'Seam Savior Certificate',
                'description' => 'Your cloth\'s seams are now stronger than ever! ?✨ #SeamSavior #ClothRepair',
                'service_id' => 104,
                'booking_id' => 188,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/seam_savior.png'),
                'created_at' => '2024-01-31 06:36:38',
                'updated_at' => '2024-01-31 06:36:38',
            ],
            [
                'id' => 16,
                'title' => 'Crafted Elegance Unleashed',
                'description' => 'Mastering the art of frames, creating timeless beauty in just one service. #CraftsmanshipAtItsBest',
                'service_id' => 100,
                'booking_id' => 187,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/craftsman_ship.png'),
                'created_at' => '2024-01-31 06:39:37',
                'updated_at' => '2024-01-31 06:39:37',
            ],
            [
                'id' => 17,
                'title' => 'AC Filter Renewal Success! ?',
                'description' => 'Enhanced air quality unlocked! AC filter replaced and optimized. #QualityService #CleanAir ?️',
                'service_id' => 110,
                'booking_id' => 186,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/clean_air_ac.png'),
                'created_at' => '2024-01-31 06:41:48',
                'updated_at' => '2024-01-31 06:41:48',
            ],
            [
                'id' => 18,
                'title' => 'Success ?: Office Cleaning Completion',
                'description' => 'Transformed your workspace into a pristine haven! ?✨ #CleanOffice #SatisfiedCustomer',
                'service_id' => 107,
                'booking_id' => 184,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/workspace_cleaning.png'),
                'created_at' => '2024-01-31 06:54:40',
                'updated_at' => '2024-01-31 06:54:40',
            ],
            [
                'id' => 19,
                'title' => 'Clean Office Transformation ?',
                'description' => 'Revitalized your workspace with meticulous #OfficeCleaning! ✨ Your spotless office awaits. #HappyCustomer',
                'service_id' => 110,
                'booking_id' => 181,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/revitalized_cleaning.png'),
                'created_at' => '2024-01-31 06:57:13',
                'updated_at' => '2024-01-31 06:57:13',
            ],
            [
                'id' => 20,
                'title' => 'Stitch & Strengthen Seal',
                'description' => 'Witness the transformation: Seam Repair and Reinforcement cloth fortifying seams! ?✨ #SeamMagic #CraftsmanTouch',
                'service_id' => 104,
                'booking_id' => 178,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/craftsman_touch.png'),
                'created_at' => '2024-01-31 06:59:28',
                'updated_at' => '2024-01-31 06:59:28',
            ],
            [
                'id' => 21,
                'title' => 'Office Oasis Achieved! ?✨',
                'description' => 'Spotless desks, fresh vibes! Your clean office journey is complete. #OfficeMagic #HappyClient',
                'service_id' => 107,
                'booking_id' => 182,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/spotless_desk.png'),
                'created_at' => '2024-01-31 07:01:47',
                'updated_at' => '2024-01-31 07:01:47',
            ],
            [
                'id' => 22,
                'title' => 'Framed Elegance ✨: Unveiling Your Artistic Frame Design Masterpiece!',
                'description' => 'Elevated your space with a personalized touch! ?️ #FramePerfection #CustomerSatisfaction',
                'service_id' => 100,
                'booking_id' => 180,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/frame_perfection.png'),
                'created_at' => '2024-01-31 07:04:43',
                'updated_at' => '2024-01-31 07:04:43',
            ],
            [
                'id' => 23,
                'title' => 'Immaculate Oasis ?✨',
                'description' => 'Transformed your space with a #FullHouseCleaning – spotless and shining, just the way you love it! ✨ #HomeRefreshed',
                'service_id' => 18,
                'booking_id' => 173,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/home_refreshed.png'),
                'created_at' => '2024-01-31 07:12:40',
                'updated_at' => '2024-01-31 07:12:40',
            ],
            [
                'id' => 24,
                'title' => 'Glowing Results ?',
                'description' => 'Transformed dull to dazzling with our Customized Facials! ✨ Your radiant skin awaits! #SkincareMagic #HappyCustomer',
                'service_id' => 45,
                'booking_id' => 170,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/skin_care_magic.png'),
                'created_at' => '2024-01-31 07:14:57',
                'updated_at' => '2024-01-31 07:14:57',
            ],
            [
                'id' => 25,
                'title' => 'Garment Restoration Success ?',
                'description' => 'Revived and renewed your favorite garment! ? Expertly restored to its former glory. #GarmentRestoration #HandymanMagic',
                'service_id' => 39,
                'booking_id' => 168,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/garment_restoration.png'),
                'created_at' => '2024-01-31 07:17:09',
                'updated_at' => '2024-01-31 07:17:09',
            ],
            [
                'id' => 26,
                'title' => 'Brighter Homes Delight ?',
                'description' => 'Successfully completed Smart Lighting Installation at your home! Illuminate your space with the latest tech. #LightingUpgrade ?✨',
                'service_id' => 56,
                'booking_id' => 167,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/lighting_upgrade.png'),
                'created_at' => '2024-01-31 07:19:20',
                'updated_at' => '2024-01-31 07:19:20',
            ],
            [
                'id' => 27,
                'title' => 'Germ-Free Assurance Certificate ?️',
                'description' => 'Completed \'High Touch Point Disinfection\' service! ?✨ #SafeAndSanitized"',
                'service_id' => 54,
                'booking_id' => 166,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/safe_sanitized.png'),
                'created_at' => '2024-01-31 07:21:02',
                'updated_at' => '2024-01-31 07:21:02',
            ],
            [
                'id' => 28,
                'title' => 'Vibrant Transformation! ?‍♂️',
                'description' => 'Witness the magic of hair coloring by a skilled hairdresser! #HairColoring #TransformationMagic',
                'service_id' => 61,
                'booking_id' => 161,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/hair_coloring.png'),
                'created_at' => '2024-01-31 07:23:12',
                'updated_at' => '2024-01-31 07:23:12',
            ],
            [
                'id' => 29,
                'title' => 'Electrifying Success: Wiring Repair at Home ?️⚡',
                'description' => 'Lighting up homes one repair at a time! ? #WiringRepair #HappyCustomers',
                'service_id' => 28,
                'booking_id' => 160,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/wiring_repair.png'),
                'created_at' => '2024-01-31 07:43:33',
                'updated_at' => '2024-01-31 07:43:33',
            ],
            [
                'id' => 30,
                'title' => 'AC Tune-up Completion Proof ?️',
                'description' => 'Another cool success! Chill vibes restored! ❄️ #HappyCustomer',
                'service_id' => 36,
                'booking_id' => 155,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/ac-tune-up.png'),
                'created_at' => '2024-01-31 11:09:20',
                'updated_at' => '2024-01-31 11:09:20',
            ],
            [
                'id' => 31,
                'title' => 'Authentic Mexican Chef Delight ??‍?',
                'description' => 'Delighted to have created a flavorful journey for a happy customer. #MexicanCuisine #ChefLife',
                'service_id' => 25,
                'booking_id' => 152,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/mexican_cuisine.png'),
                'created_at' => '2024-01-31 11:16:16',
                'updated_at' => '2024-01-31 11:16:16',
            ],
            [
                'id' => 32,
                'title' => 'Bright Transformation ?',
                'description' => 'Transformed a space with #IndoorLightingMagic ?✨',
                'service_id' => 29,
                'booking_id' => 151,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/indoor_light_magic.png'),
                'created_at' => '2024-01-31 11:19:37',
                'updated_at' => '2024-01-31 11:19:37',
            ],
            [
                'id' => 33,
                'title' => 'Tailoring Excellence Certificate',
                'description' => 'Successfully transformed your garment with expert Hemming and Length Adjustment! #SartorialMastery ?',
                'service_id' => 57,
                'booking_id' => 143,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/sartorial_mastery.png'),
                'created_at' => '2024-01-31 11:23:00',
                'updated_at' => '2024-01-31 11:23:00',
            ],
            [
                'id' => 34,
                'title' => 'Successful Roach Control in Your Kitchen ??',
                'description' => 'Your kitchen is now roach-free! #PestControlChampion ?️',
                'service_id' => 43,
                'booking_id' => 137,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/pest_control.png'),
                'created_at' => '2024-01-31 11:26:25',
                'updated_at' => '2024-01-31 11:26:25',
            ],
            [
                'id' => 35,
                'title' => 'Revived Elegance: Wooden Chair Restoration ?️',
                'description' => 'Transformed a tired wooden chair into a timeless masterpiece! #FurnitureRevival ?‍?',
                'service_id' => 15,
                'booking_id' => 129,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/furniture_revival.png'),
                'created_at' => '2024-01-31 11:28:33',
                'updated_at' => '2024-01-31 11:28:33',
            ],
            [
                'id' => 36,
                'title' => 'AC Airflow Problem Identified ?️',
                'description' => 'Swiftly diagnosed and resolved AC airflow issue, ensuring optimal cooling! #CoolingExperts #HandymanAtYourService',
                'service_id' => 93,
                'booking_id' => 126,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/cooling_experts.png'),
                'created_at' => '2024-01-31 11:42:18',
                'updated_at' => '2024-01-31 11:42:18',
            ],
            [
                'id' => 37,
                'title' => 'Ride Assurance ?✨',
                'description' => 'Revitalized interiors! #InteriorCarCleaning done with precision, ensuring a fresh and pristine driving experience. ?? #HappyCustomer',
                'service_id' => 32,
                'booking_id' => 124,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/interior_car_cleaning.png'),
                'created_at' => '2024-01-31 11:47:38',
                'updated_at' => '2024-01-31 11:47:38',
            ],
            [
                'id' => 38,
                'title' => 'Chimney Bliss Certificate ?✨',
                'description' => 'Completed #ChimneySweeping – Your fireplace is now pristine and ready for cozy moments! #SatisfiedCustomer',
                'service_id' => 22,
                'booking_id' => 122,
                'user_id' => 51,
                'booking_attachment' => public_path('/images/service_proof/chimney_sweeping.png'),
                'created_at' => '2024-01-31 11:54:43',
                'updated_at' => '2024-01-31 11:54:43',
            ],
        ];
        
        foreach ($data as $key => $val) {
            $featureImage = $val['booking_attachment'] ?? null;
            $serviceproofData = Arr::except($val, ['booking_attachment']);
            $serviceproof = ServiceProof::create($serviceproofData);
            if (isset($featureImage)) {
                $this->attachFeatureImage($serviceproof, $featureImage);
            }
        }
    }

    private function attachFeatureImage($model, $publicPath)
    {

        $file = new \Illuminate\Http\File($publicPath);

        $media = $model->addMedia($file)->preservingOriginal()->toMediaCollection('booking_attachment');

        return $media;

    }
}